/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.kmservice.service.impl;

import com.alibaba.nacos.common.utils.CollectionUtils;
import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.athena.domain.common.BaseEntity;
import com.digiwin.athena.domain.core.app.Application;
import com.digiwin.athena.domain.core.app.ApplicationRelation;
import com.digiwin.athena.kmservice.service.KmApplicationService;
import com.digiwin.athena.kmservice.service.KmDBService;
import com.digiwin.athena.kmservice.utils.MergeUtil;
import com.digiwin.athena.kmservice.utils.ServiceUtils;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;

@Service
public class DbApplicationServiceImpl
extends KmDBService
implements KmApplicationService {
    @Override
    public Application applicationByCodeAndVersion(String code, String version) throws DWBusinessException {
        String tenantId = ServiceUtils.getTenantId();
        List<Application> applications = this.systemTemplate().find(Query.query((CriteriaDefinition)Criteria.where((String)"tenantId").in(new Object[]{tenantId, "SYSTEM", null}).and("code").is((Object)code).and("version").is((Object)version)), Application.class);
        return CollectionUtils.isNotEmpty(applications = MergeUtil.excludeSameCode(applications, Application.class, null)) ? applications.get(0) : null;
    }

    @Override
    public List<String> getCodeByTypeAndAppCodeAndVersion(String type, String appCode, String version) throws DWBusinessException {
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"appCode").is((Object)appCode).and("type").is((Object)type).and("version").is((Object)version));
        List relations = this.systemTemplate().find(query, ApplicationRelation.class);
        return relations.stream().map(BaseEntity::getCode).distinct().collect(Collectors.toList());
    }

    @Override
    public MongoTemplate systemTemplate() {
        return super.getMongoTemplateSys();
    }

    @Override
    public MongoTemplate tenantTemplate() {
        return super.getMongoTemplateTenant();
    }
}

