/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.kmservice.support;

import com.digiwin.athena.domain.core.Activity;
import com.digiwin.athena.kmservice.support.MergePolicy;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class MergePolicyBuilder {
    private static Map<String, MergePolicy> policyMap = new ConcurrentHashMap<String, MergePolicy>();

    public static MergePolicy of() {
        MergePolicy policy = new MergePolicy();
        MergePolicyBuilder.addPublics(policy.getRegs());
        return policy;
    }

    public static MergePolicy of(String ... regxs) {
        MergePolicy policy = new MergePolicy();
        for (String reg : regxs) {
            policy.getRegs().add(reg);
        }
        MergePolicyBuilder.addPublics(policy.getRegs());
        return policy;
    }

    public static MergePolicy getPolicy(String key) {
        MergePolicy policy = new MergePolicy();
        MergePolicy cached = policyMap.get(key);
        if (null != cached) {
            policy.setRegs(cached.getRegs());
        } else {
            MergePolicyBuilder.addPublics(policy.getRegs());
        }
        return policy;
    }

    public static void init() {
        policyMap.put(Activity.class.getName(), MergePolicyBuilder.of(".config.approve"));
    }

    public static void addPublics(List<String> regs) {
        regs.add(".*.lang");
    }

    public static void main(String[] args) {
        System.out.println(".aa.bb.lang.aa".matches(".*.lang"));
    }

    static {
        MergePolicyBuilder.init();
    }
}

