package com.digiwin.athena.kmservice.action.execution;

import com.digiwin.app.container.exceptions.DWException;
import com.digiwin.app.container.exceptions.DWRuntimeException;

/**
 * @description:
 * @author: liunansheng
 * @date: 2024/9/4 13:39
 */
@FunctionalInterface
public interface ProductNameGetter {

    String getProductName();


    /**
     * 通过MDC获取产品名称，一个实例只会获取一次
     */
    class MdcProductNameGetter implements ProductNameGetter {

        private final ProductNameResolver resolver;

        private final String apiName;

        private final String tenantId;

        private String productName;

        private boolean present;

        public MdcProductNameGetter(ProductNameResolver resolver, String apiName, String tenantId) {
            this.resolver = resolver;
            this.apiName = apiName;
            this.tenantId = tenantId;
        }

        public String getProductName() {
            // present 表示是否已经获取过产品名称,不可重复获取，否则有严重性能问题
            if (!present) {
                try {
                    productName = resolver.getProductName(apiName, tenantId);
                    present = true;
                } catch (DWException e) {
                    throw new DWRuntimeException(e.getErrorCode(), e.getMessage(), e);
                } catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            return productName;
        }
    }
}
