package com.digiwin.athena.kmservice.action.metadata;

import cn.hutool.extra.spring.SpringUtil;
import com.digiwin.app.container.exceptions.DWException;
import com.digiwin.athena.kmservice.common.Neo4jConstants;
import com.digiwin.athena.kmservice.action.execution.model.ActionDefinitionDTO;
import com.digiwin.athena.kmservice.action.execution.model.ActionExecutionDTO;
import com.digiwin.athena.kmservice.utils.I18nUtils;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

@Component
public class KmActionClient implements InitializingBean {

    private Map<String, ActionHandler> handler = new ConcurrentHashMap<>();

    @Override
    public void afterPropertiesSet() throws Exception {
        Map<String, ActionHandler> handlerMap = SpringUtil.getBeansOfType(ActionHandler.class);
        for (Map.Entry<String, ActionHandler> entry : handlerMap.entrySet()) {
            handler.put((entry.getValue().getActionLabel()), entry.getValue());
        }
    }

    public ActionDefinitionDTO doHandlerMetadata(List<String> actionLabels, Map<String, Object> actionMatched) throws Exception {
        Set<String> strings = handler.keySet();
        boolean exist = false;
        ActionDefinitionDTO result = null;
        for(String str : strings){
            if(actionLabels.contains(str)){
                exist = true;
                result = handler.get(str).processMetadata(actionMatched);
                break;
            }
        }
        if(exist){
            return result;
        }else{
            throw new DWException("P.KG.500.0026", I18nUtils.getValue("knowledgegraph.actionPulled") + actionMatched.get(Neo4jConstants.PROPERTY_ACTION_ID).toString());
        }
    }

    public ActionExecutionDTO doHandlerExecution(List<String> actionLabels, Map<String, Object> actionMatched) throws Exception {
        Set<String> strings = handler.keySet();
        boolean exist = false;
        ActionExecutionDTO result = null;
        for(String str : strings){
            if(actionLabels.contains(str)){
                exist = true;
                result = handler.get(str).processExecution(actionMatched);
                break;
            }
        }
        if(exist){
            return result;
        }else{
            throw new DWException("P.KG.500.0026",I18nUtils.getValue("knowledgegraph.actionPulled") + actionMatched.get(Neo4jConstants.PROPERTY_ACTION_ID).toString());
        }
    }
}
