package com.digiwin.athena.kmservice.configuration.mongoConvert;

import org.springframework.core.convert.converter.Converter;
import org.springframework.data.convert.ReadingConverter;

import java.util.List;

/**
 * mongo 数据类型转换器 读取 list---> string
 * @author gengwei
 * @since 2025/10/24 09:15
 */
@ReadingConverter
public class ListToStringConverter implements Converter<List<?>, String> {

    @Override
    public String convert(List<?> source) {
        if (source == null || source.isEmpty()) {
            return null;
        }
        return String.join(",", source.stream().map(String::valueOf).toArray(String[]::new));
    }
}
