package com.digiwin.athena.kmservice.service;


import cn.hutool.extra.spring.SpringUtil;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.athena.kg.monitorRule.secondCalculate.ActionRecast;
import com.digiwin.athena.kg.action.Action;
import com.digiwin.athena.kmservice.action.execution.KmDataPullingPathGenerator;
import com.digiwin.athena.kmservice.action.execution.ProductNameResolver;
import com.digiwin.athena.kmservice.action.execution.model.*;
import com.digiwin.athena.kmservice.action.model.LogConstant;
import com.digiwin.athena.kmservice.action.model.LogDataDto;
import com.digiwin.athena.kmservice.action.model.LogDto;
import com.digiwin.athena.kmservice.common.Constants;
import com.digiwin.athena.kmservice.locale.Lang;
import com.digiwin.athena.kmservice.service.impl.KmDBCommonServiceImpl;
import com.digiwin.athena.kmservice.utils.IAMUtils;
import com.digiwin.athena.repository.neo4j.ActionRepository;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

import java.util.*;

/**
 * 获取action的执行路径
 * 使用方需增加iamUrl、iamApToken、espUrl、mdcUrl、espMdcUrl的环境变量配置
 * @author yinhaiye
 * @date 2025/03/25 10:15
 */
@Lang
@Service
@Slf4j
public class ActionExecutionPathService {

    @Autowired
    private KmTenantService kmTenantService;

    @Autowired
    private KmDBCommonServiceImpl kmDBCommonService;

    @Autowired(required = false)
    ActionRepository actionRepository;

    @Autowired
    IAMUtils iamUtils;

    @Autowired
    ProductNameResolver productNameResolver;

    /**
     * 容器会动态生成一个子类然后将这个被注解的方法重写/实现，最终调用的是子类的方法。
     */
    public KmDataPullingPathGenerator getDataPullingPathGenerator() {
        KmDataPullingPathGenerator bean = SpringUtil.getBean(KmDataPullingPathGenerator.class);
        return bean;
    }

    public Object postQueryExecutionPath(String actionId, String tenantId, List<String> existingActionParams, List<String> existingSysParams) throws Exception {
        try {
            // 如果是指标需要获取到指标对应的actionId
            String tenantVersion = kmTenantService.getTenantVersion(tenantId);
            if (StringUtils.isNotEmpty(actionId) && actionId.startsWith("METRIC_")) {
                List<Action> actionList = actionRepository.findByActionIdAndVersion(actionId, tenantVersion);
                if (!CollectionUtils.isEmpty(actionList)) {
                    actionId = actionList.get(0).getQuoteMetricCode();
                }
            }

            List<String> existingActionParamsWithoutRoot = this.removeActionParamRoot(existingActionParams);
            List<String> existingSysParamsWithoutRoot = this.removeActionParamRoot(existingSysParams);
            List<String> subtractSysParams = (List<String>) CollectionUtils.subtract(existingSysParamsWithoutRoot, existingActionParamsWithoutRoot);
            List<String> existingAllParams = (List<String>) CollectionUtils.union(existingActionParamsWithoutRoot, existingSysParamsWithoutRoot);
            ActionExecutionPathDTO pathDTO = getDataPullingPathGenerator().Generate(actionId, tenantId, existingAllParams,tenantVersion);
            //后续处理ActionExecution，设置productName，locale等
            // actions的重复问题处理
            handleDistinctActions(pathDTO.getActions());
            // 查询action二次计算的定义
            List<ActionRecast> actionRecast = kmDBCommonService.getActionRecastListByActionIds(Collections.singletonList(actionId));
            if (!CollectionUtils.isEmpty(actionRecast)) {
                pathDTO.setRecast(actionRecast.get(0).getRecast());
            }

            JSONObject actionParamMapping = kmDBCommonService.getAgiledataParameterPappingByCodeAndVersion(actionId, tenantVersion);
            if (!ObjectUtils.isEmpty(actionParamMapping)) {
                pathDTO.setStandardParameterMapping(actionParamMapping.getJSONObject("parameterMapping"));
            }

            this.postActionExecutionProcessor(pathDTO.getActions(), tenantId, subtractSysParams);
            this.logTrace(actionId, true, null);
            return pathDTO;
        } catch (Exception e) {
            this.logTrace(actionId, false, e.getMessage());
            throw new Exception(e);
        }
    }

    private List<String> removeActionParamRoot(List<String> existsActionParams) {
        List<String> actionParamsWithoutRoot = new ArrayList();
        if (!CollectionUtils.isEmpty(existsActionParams)) {
            existsActionParams.forEach(e -> {
                if (e.startsWith(Constants.ROOT)) {
                    actionParamsWithoutRoot.add(e.substring(2));
                } else {
                    actionParamsWithoutRoot.add(e);
                }
            });
        }
        return actionParamsWithoutRoot;
    }

    // actions的重复问题处理
    private void handleDistinctActions(List<ActionExecutionDTO> actions) {
        if (!CollectionUtils.isEmpty(actions)) {
            actions.forEach(action -> {
                List<ActionExecutionParamDTO> params = action.getParams();
                List<ActionExecutionParamDTO> uniqueParams = new ArrayList<>();

                // 使用 HashSet 去重
                Set<String> distinctParams = new HashSet<>();

                for (ActionExecutionParamDTO param : params) {
                    if (param instanceof PullingActionExecutionParamDTO) {
                        PullingActionExecutionParamDTO pullingParam = (PullingActionExecutionParamDTO) param;
                        String key = createKey(pullingParam.getName(), pullingParam.getType().toString(), pullingParam.getValue(), pullingParam.getSource());
                        // 根据 key 去重
                        if (!distinctParams.contains(key)) {
                            // actions中的#替换为.
//                            uniqueParams.add(JSON.parseObject(JSON.toJSONString(param).replaceAll("#", "."), PullingActionExecutionParamDTO.class));
                            uniqueParams.add(param);
                            distinctParams.add(key);
                        }
                    } else {
                        String key = createKey(param.getName(), param.getType().toString(), param.getValue(), null);
                        // 根据 key 去重
                        if (!distinctParams.contains(key)) {
                            uniqueParams.add(param);
                            distinctParams.add(key);
                        }
                    }
                }

                action.setParams(uniqueParams);
            });
        }
    }

    private String createKey(String name, String type, String value, String source) {
        return name + type + value + (source != null ? source : "");
    }

    private void logTrace(String actionId, boolean success, String errorMsg) {
        LogDataDto logDataDto = new LogDataDto(actionId, "行动actionId", LogConstant.TYPE_CONFIG, LogConstant.LABEL_ACTION);
        String message = success ? "知识图谱求取行动逻辑图谱成功" : "知识图谱求取行动逻辑图谱失败,失败信息:" + errorMsg;
        LogDto logDto = new LogDto(message, Arrays.asList(logDataDto));
        if(success){
            log.info(logDto.toString());
        }else{
            log.error(logDto.toString());
        }

    }

    private void postActionExecutionProcessor(List<ActionExecutionDTO> actionExecutions, String tenantId, List<String> existsSysParamsWithoutRoot) throws Exception {
        for (ActionExecutionDTO e : actionExecutions) {
            if (e instanceof ESPActionExecutionDTO) {
                String productName = this.productNameResolver.getProductName(((ESPActionExecutionDTO) e).getServiceName(), tenantId);
                ((ESPActionExecutionDTO) e).setProductName(productName);
            } else if (e instanceof StartProcessActionExecutionDTO) {
                Map<String, Object> headers = DWServiceContext.getContext().getRequestHeader();
                String token = headers == null ? null : (String) headers.get("token");
                ((StartProcessActionExecutionDTO) e).setLocale(this.iamUtils.getTenantLocale(token));
            } else if (e instanceof StartDataEventActionExecutionDTO) {
                Map<String, Object> headers = DWServiceContext.getContext().getRequestHeader();
                String token = headers == null ? null : (String) headers.get("token");
                ((StartDataEventActionExecutionDTO) e).setLocale(this.iamUtils.getTenantLocale(token));
            } else if (e instanceof StartServiceComposerActionExecutionDTO) {
                Map<String, Object> headers = DWServiceContext.getContext().getRequestHeader();
                String token = headers == null ? null : (String) headers.get("token");
                ((StartServiceComposerActionExecutionDTO) e).setLocale(this.iamUtils.getTenantLocale(token));
            }
            // 如果存在sysParam，则把type改为SYSPARAM
            if (CollectionUtils.isNotEmpty(existsSysParamsWithoutRoot)) {
                List<ActionExecutionParamDTO> params = e.getParams();
                if (CollectionUtils.isNotEmpty(params)) {
                    for (ActionExecutionParamDTO executionParamDTO : params) {

                        String value = (!(executionParamDTO instanceof  MultiPathActionExecutionParamDTO) && executionParamDTO.getValue().startsWith("$.")) ? executionParamDTO.getValue().substring(2) : executionParamDTO.getValue();
                        if (existsSysParamsWithoutRoot.contains(value)) {
                            executionParamDTO.setType(ActionParamTypeEnum.SYSPARAM);
                        }
                    }
                }
            }
        }

        // todo  敏捷报表修改 后续考虑去掉
        /*if (CollectionUtils.isNotEmpty(existsSysParamsWithoutRoot)) {
            for (ActionExecutionDTO e : actionExecutions) {
                List<ActionExecutionParamDTO> params = e.getParams();
                if (CollectionUtils.isNotEmpty(params)) {
                    for (ActionExecutionParamDTO executionParamDTO : params) {
                        List<String> pathData = getArrayData(executionParamDTO.getName());
                        setSysParam(pathData,params);
                    }
                }
            }
        }*/

//        actionExecutions.forEach(e->{
//            if(e instanceof ESPActionExecutionDTO){
//                String productName = null;
//                 productName = this.productNameResolver.getProductName(((ESPActionExecutionDTO) e).getServiceName(), tenantId);
//                ((ESPActionExecutionDTO) e).setProductName(productName);
//            }else if(e instanceof StartProcessActionExecutionDTO){
//                Map<String, Object> headers = DWServiceContext.getContext().getRequestHeader();
//                String token = headers == null ? null : (String)headers.get("token");
//                ((StartProcessActionExecutionDTO) e).setLocale(this.iamUtils.getTenantLocale(token));
//            }else if(e instanceof StartDataEventActionExecutionDTO){
//                Map<String, Object> headers = DWServiceContext.getContext().getRequestHeader();
//                String token = headers == null ? null : (String)headers.get("token");
//                ((StartDataEventActionExecutionDTO) e).setLocale(this.iamUtils.getTenantLocale(token));
//            }
//            //如果存在sysParam，则把type改为SYSPARAM
//            if(CollectionUtils.isNotEmpty(existsSysParamsWithoutRoot)){
//                List<ActionExecutionParamDTO> params = e.getParams();
//                if(CollectionUtils.isNotEmpty(params)){
//                    for(ActionExecutionParamDTO executionParamDTO : params){
//                        String value = executionParamDTO.getValue().startsWith("$.") ? executionParamDTO.getValue().substring(2) : executionParamDTO.getValue();
//                        if(existsSysParamsWithoutRoot.contains(value)){
//                            executionParamDTO.setType(ActionParamTypeEnum.SYSPARAM);
//                        }
//                    }
//                }
//            }
//        });
    }
}
