package com.digiwin.athena.kmservice.action.metadata;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.app.resource.DWResourceBundleUtils;
import com.digiwin.athena.dto.ApiDataFieldMetadataDTO;
import com.digiwin.athena.kg.action.ActionRequestMetadataDTO;
import com.digiwin.athena.kg.action.ActionResponseMetadataDTO;
import com.digiwin.athena.kmservice.common.Neo4jConstants;
import com.digiwin.athena.kmservice.action.execution.model.ActionDefinitionDTO;
import com.digiwin.athena.kmservice.action.execution.model.ActionRequestDefinitionDTO;
import com.digiwin.athena.kmservice.action.execution.model.ActionResponseDefinitionDTO;
import com.digiwin.athena.kmservice.action.execution.model.ApiDataFieldDefinitionDTO;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.CollectionUtils;

import java.util.*;
import java.util.function.Consumer;

public abstract  class ActionMetadataGeneratorBase {

    public ActionDefinitionDTO Generate(Map<String, Object> actionQueryResult) {
        ActionDefinitionDTO metadataDTO = CreateInstance(actionQueryResult);

        metadataDTO.setActionId(actionQueryResult.get(Neo4jConstants.PROPERTY_ACTION_ID).toString());
        //ActionDefinitionDTO的type及子类属性都在ActionMetadataGeneratorBase的继承类中实现
        metadataDTO.setRequest(this.generateRequest(actionQueryResult));
        metadataDTO.setResponse(this.generateResponse(actionQueryResult));
        metadataDTO.setActionMode(actionQueryResult.get(Neo4jConstants.ACTION_MODE));
        metadataDTO.setAggregation(actionQueryResult.get(Neo4jConstants.ACTION_AGGREGATION));
        if (Objects.nonNull(actionQueryResult.get("lang"))) {
            String locale = DWResourceBundleUtils.getCurrentLocale().toString();
            JSONObject lang = (JSONObject) actionQueryResult.get("lang");
            updateMetadataDTO(lang, locale, metadataDTO);
        }
        return metadataDTO;
    }

    protected abstract ActionDefinitionDTO CreateInstance(Map<String, Object> actionQueryResult);


    public ActionRequestDefinitionDTO generateRequest(Map<String, Object> actionQueryResult){
        ActionRequestMetadataDTO requestMetadataDTO = new ActionRequestMetadataDTO();
        requestMetadataDTO.setParameters(JSON.parseArray(actionQueryResult.get("request_parameters").toString(), ApiDataFieldMetadataDTO.class));

        ActionRequestDefinitionDTO requestDefinitionDTO = new ActionRequestDefinitionDTO();
        List<ApiDataFieldDefinitionDTO> fields = new ArrayList<>();
        if(!CollectionUtils.isEmpty(requestMetadataDTO.getParameters())) {
            for (ApiDataFieldMetadataDTO fieldMetadata : requestMetadataDTO.getParameters()) {
                fields.add(convert(fieldMetadata));
            }
        }
        requestDefinitionDTO.setParameters(fields);

        return requestDefinitionDTO;
    }

    public ActionResponseDefinitionDTO generateResponse(Map<String, Object> actionQueryResult){
        ActionResponseMetadataDTO responseMetadataDTO = new ActionResponseMetadataDTO();
        responseMetadataDTO.setData(JSON.parseObject(actionQueryResult.get("response_object").toString(), ApiDataFieldMetadataDTO.class));

        ActionResponseDefinitionDTO responseDefinitionDTO = new ActionResponseDefinitionDTO();

        if (responseMetadataDTO.getData() != null) {
            responseDefinitionDTO.setData(convert(responseMetadataDTO.getData()));
        }

        return responseDefinitionDTO;
    }


    private ApiDataFieldDefinitionDTO convert(ApiDataFieldMetadataDTO metadata) {
        Locale locale = DWResourceBundleUtils.getCurrentLocale();
        String localeStr = locale.toString();
        ApiDataFieldDefinitionDTO definition = new ApiDataFieldDefinitionDTO();
        // APC大屏部分会有#, 需要替换为.
//        definition.setData_name(StringUtils.isNotEmpty(metadata.getData_name()) ? metadata.getData_name().replaceAll("#",".") : "");
        definition.setData_name(metadata.getData_name());
        definition.setData_type(metadata.getData_type());
        definition.setIs_array(metadata.getIs_array());
        definition.setIs_datakey(metadata.getIs_datakey());
        definition.setRequired(metadata.getRequired());
        definition.setIs_businesskey(metadata.getIs_businesskey());
        String description = metadata.getDescription() != null ? metadata.getDescription().getZh_CN() : null;
        String remark = metadata.getRemark() != null ? metadata.getRemark().getZh_CN() : null;
        if ("zh_TW".equals(localeStr) && StringUtils.isNotEmpty(description)) {
            description = metadata.getDescription().getZh_TW();
        }
        if ("zh_TW".equals(localeStr) && StringUtils.isNotEmpty(remark)) {
            remark = metadata.getRemark().getZh_TW();
        }
        definition.setDescription(description);
        definition.setRemark(remark);
        definition.setEnum_key(metadata.getEnum_key());
        definition.setCan_filter(metadata.isCan_filter());
        definition.setCan_sort(metadata.isCan_sort());
        definition.setPercent(metadata.getPercent());
        definition.setDecimal(metadata.getDecimal());
        List<ApiDataFieldDefinitionDTO> fieldDefinitionDTOS = new ArrayList<>();
        if (metadata.getField() != null) {
            for (ApiDataFieldMetadataDTO fieldMetadata : metadata.getField()) {
                fieldDefinitionDTOS.add(convert(fieldMetadata));
            }
        }
        definition.setField(fieldDefinitionDTOS);
        return definition;
    }

    // 新增一个辅助方法
    private void updateMetadataDTO(JSONObject lang, String locale, ActionDefinitionDTO metadataDTO) {
        if (Objects.nonNull(lang)) {
            updateField(lang.getJSONObject("actionName"), locale, metadataDTO::setActionName);
            updateField(lang.getJSONObject("actionTypeDescription"), locale, metadataDTO::setActionTypeDescription);
        }
    }

    // 新增一个通用的辅助方法来处理字段更新逻辑
    private void updateField(JSONObject fieldJson, String locale, Consumer<String> fieldSetter) {
        if (Objects.nonNull(fieldJson)) {
            String fieldValue = fieldJson.getString(locale);
            if (StringUtils.isNotEmpty(fieldValue)) {
                fieldSetter.accept(fieldValue);
            }
        }
    }

}
