package com.digiwin.athena.kmservice.action.metadata;

import com.digiwin.athena.kmservice.common.Neo4jConstants;
import com.digiwin.athena.kmservice.action.execution.model.ActionDefinitionDTO;
import com.digiwin.athena.kmservice.action.execution.model.ActionExecutionDTO;
import com.digiwin.athena.kmservice.action.execution.model.ActionTypeEnum;
import com.digiwin.athena.kmservice.action.execution.model.TransformActionExecutionDTO;
import org.springframework.stereotype.Component;

import java.util.Map;


@Component
public class BmdApiActionHandlerImpl implements ActionHandler<Map<String, Object>> {
    @Override
    public ActionDefinitionDTO processMetadata(Map<String, Object> actionMatched) {
        ActionDefinitionDTO eocDefinitionDTO = new BmdApiActionMetadataGenerator().Generate(actionMatched);
        return eocDefinitionDTO;
    }

    @Override
    public ActionExecutionDTO processExecution(Map<String, Object> actionMatched) {
        TransformActionExecutionDTO executionDTO = new TransformActionExecutionDTO();
        executionDTO.setActionId(actionMatched.get(Neo4jConstants.PROPERTY_ACTION_ID).toString());
        executionDTO.setType(ActionTypeEnum.BMD_API);
        executionDTO.setForEach(true);
        return executionDTO;
    }

    @Override
    public String getActionLabel() {
        return Neo4jConstants.LABEL_BMD_API_ACTION;
    }
}
