package com.digiwin.athena.kmservice.action.metadata;

import com.digiwin.athena.kmservice.common.Neo4jConstants;
import com.digiwin.athena.kmservice.action.execution.model.ActionDefinitionDTO;
import com.digiwin.athena.kmservice.action.execution.model.ActionTypeEnum;
import com.digiwin.athena.kmservice.action.execution.model.ESPActionDefinitionDTO;

import java.util.Map;

public class EspActionMetadataGenerator extends ActionMetadataGeneratorBase {

    @Override
    protected ActionDefinitionDTO CreateInstance(Map<String, Object> actionQueryResult) {
        ESPActionDefinitionDTO metadataDTO = new ESPActionDefinitionDTO();
        metadataDTO.setServiceName(actionQueryResult.get(Neo4jConstants.PROPERTY_ESP_ACTION_SERVICE_NAME).toString());
        metadataDTO.setUrl(actionQueryResult.get(Neo4jConstants.PROPERTY_ESP_ACTION_URL).toString());
        metadataDTO.setType(ActionTypeEnum.ESP);
        metadataDTO.setApiMeta(actionQueryResult.get(Neo4jConstants.PROPERTY_ESP_ACTION_API_META));

//        ActionRequestMetadataDTO requestMetadataDTO = new ActionRequestMetadataDTO();
//        requestMetadataDTO.setParameters(JSON.parseArray(actionQueryResult.get("request_parameters").toString(), ApiDataFieldMetadataDTO.class));
//
//        ActionRequestDefinitionDTO requestDefinitionDTO = new ActionRequestDefinitionDTO();
//        List<ApiDataFieldDefinitionDTO> fields = new ArrayList<>();
//        for (ApiDataFieldMetadataDTO fieldMetadata : requestMetadataDTO.getParameters()) {
//            fields.add(convert(fieldMetadata));
//        }
//        requestDefinitionDTO.setParameters(fields);
//
//        ActionResponseMetadataDTO responseMetadataDTO = new ActionResponseMetadataDTO();
//        responseMetadataDTO.setData(JSON.parseObject(actionQueryResult.get("response_object").toString(), ApiDataFieldMetadataDTO.class));
//
//        ActionResponseDefinitionDTO responseDefinitionDTO = new ActionResponseDefinitionDTO();
//
//        if (responseMetadataDTO.getData() != null) {
//            responseDefinitionDTO.setData(convert(responseMetadataDTO.getData()));
//        }
//
//        metadataDTO.setRequest(requestDefinitionDTO);
//        metadataDTO.setResponse(responseDefinitionDTO);

        return metadataDTO;
    }

//    private ApiDataFieldDefinitionDTO convert(ApiDataFieldMetadataDTO metadata) {
//        ApiDataFieldDefinitionDTO definition = new ApiDataFieldDefinitionDTO();
//        definition.setData_name(metadata.getData_name());
//        definition.setData_type(metadata.getData_type());
//        definition.setIs_array(metadata.isIs_array());
//        definition.setIs_datakey(metadata.getIs_datakey());
//        definition.setRequired(metadata.getRequired());
//        List<ApiDataFieldDefinitionDTO> fieldDefinitionDTOS = new ArrayList<>();
//        if (metadata.getField() != null) {
//            for (ApiDataFieldMetadataDTO fieldMetadata : metadata.getField()) {
//                fieldDefinitionDTOS.add(convert(fieldMetadata));
//            }
//        }
//        definition.setField(fieldDefinitionDTOS);
//        return definition;
//    }
}
