package com.digiwin.athena.kmservice.analysis;

import com.digiwin.athena.kmservice.support.KmRestTemplate;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.pool.PoolStats;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.filter.OncePerRequestFilter;

import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebFilter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;


/**
 *
 * 手动开启filter统计功能
 */

@WebFilter
@Component
public class UriAnalysisFilter extends OncePerRequestFilter {


    private  Map<String,UriAnalysisBean> uriBeans =  new HashMap<>();

    private boolean uriAnalysisEnable = false;

    @Override
    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {

        long t1 = System.currentTimeMillis();
        boolean error = false;
        try {
            filterChain.doFilter(request,response);
        }catch (Exception e){
            error =true;
            throw e;
        }finally {
            if(uriAnalysisEnable){
                long duration = System.currentTimeMillis() -t1;
                String uri = request.getRequestURI();
                UriAnalysisBean bean = uriBeans.get(uri);
                if(null==bean){
                    bean = new UriAnalysisBean();
                    bean.setUri(uri);
                    bean.setStartTime(new Date());
                    uriBeans.put(uri,bean);
                }
                bean.getTotalCount().incrementAndGet();
                if(!error){bean.getSuccessCount().incrementAndGet();}
                bean.getTotalTime().addAndGet(duration);
                if(duration>bean.getMax()){bean.setMax(duration);}
                if(duration<bean.getMax()){bean.setMin(duration);}
            }
        }




    }


    public void startAnalysis(){
        this.uriAnalysisEnable = true;
        this.uriBeans.clear();
    }

    public void stopAnalysis(){
        this.uriAnalysisEnable = false;
        this.uriBeans.clear();
    }

    public Map<String,UriAnalysisBean> uriAnalysisBeanMap(){

        uriBeans.forEach((k,v)->{
            if(v.getTotalCount().get()>0){
                v.setAvg(v.getTotalTime().get()/v.getTotalCount().get());
                v.setSuccessRate(100* v.getSuccessCount().get()/v.getTotalCount().get());
            }
        });

        return uriBeans;
    }
}
