package com.digiwin.athena.kmservice.dtd;

import com.alibaba.nacos.common.utils.CollectionUtils;
import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.app.container.exceptions.DWException;
import com.digiwin.athena.domain.core.DataState;
import com.digiwin.athena.domain.core.Project;
import com.digiwin.athena.domain.core.StateMap;
import com.digiwin.athena.domain.core.Task;
import com.digiwin.athena.domain.core.app.Application;
import com.digiwin.athena.domain.core.flow.FlowGraph;
import com.digiwin.athena.domain.definition.features.DataTagging;
import com.digiwin.athena.dto.BasicQuery;
import com.digiwin.athena.dto.TaskPathResp;
import com.digiwin.athena.dto.TaskPathVo;
import com.digiwin.athena.kmservice.povo.DataRequest;
import com.digiwin.athena.kmservice.service.KmApplicationService;
import com.digiwin.athena.kmservice.utils.I18nUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

import java.util.*;

@Service
public class DtdService {

    @Autowired
    @Qualifier("dataMapDataPickService")
    private DataMapDataPickService dataPickService;


    @Autowired
    KmApplicationService kmApplicationService;


    public Project getProjectByCode(String code) throws DWException {
        Project p = dataPickService.findBetter(code, Project.class);
        return p;
    }

    public Project getUserProject(String projectCode, String stateCode) throws DWException {
        Project up = null;
        Map<String, Object> param = new HashMap<>();
        param.put("primaryProjectCode", projectCode);
        param.put("init.code", stateCode);
        param.put("executeType", "user");
        up = dataPickService.findOne(BasicQuery.of(param, null), Project.class);
        return up;
    }

    public DataState getDataState(String code) throws DWException {
        return dataPickService.findByCode(code, DataState.class);
    }


    public TaskPathResp postExecutePath(DataRequest request) throws DWException {
        com.digiwin.athena.kmservice.utils.ServiceUtils.getContext().setEocInfo(request.getEocInfo());
        TaskPathResp resp = new TaskPathResp();
        String tenantId = com.digiwin.athena.kmservice.utils.ServiceUtils.getTenantId();
        request.setTenantId(tenantId);
        // 判断项目信息
        Project pro = getProjectByCode(request.getProjectCode());
        if (null == pro) {
            throw new DWException("P.DM.500.0001", I18nUtils.getValue("P.DM.500.0001") + request);
        }
        String topProjectCode = pro.getCode();
        if (null != pro.getPrimaryProjectCode()) {
            topProjectCode = pro.getPrimaryProjectCode();
        }
        Application application = kmApplicationService.applicationByCodeAndVersion(pro.getApplication(), dataPickService.tenantVersion());
        // 应用是否悬停
        boolean individualAll = Optional.ofNullable(application).map(Application::getIndividualAll).orElse(false);
        Project up = getUserProject(topProjectCode, request.getFromStateCode());
        resp.setStartProject(up);
        DataState begin = getDataState(request.getFromStateCode());
        resp.setFromState(begin);
        if (reachProjectEnd(request.getFromStateCode(), request.getToStateCode(), pro)) {
            return resp;
        }
        // 找任务
        List<Task> tasks = bestTaskByFrom(request.getFromStateCode(), request);
        if (!tasks.isEmpty()) {
            Map<String, List<Task>> groups = new HashMap<>();
            // 在悬停情况下，移除掉租户id等于SYSTEM的
            tasks.removeIf(t -> individualAll && "SYSTEM".equals(t.getTenantId()));
            tasks.forEach(t -> {
                if (null == t.getGroup()) {
                    t.setGroup("default");
                }
                groups.computeIfAbsent(t.getGroup(), k -> new ArrayList<>()).add(t);
            });
            for (Map.Entry<String, List<Task>> entry : groups.entrySet()) {
                List<Task> v = entry.getValue();
                sortTasks(v, request);
                TaskPathVo vo = new TaskPathVo();
                vo.setTasks(v);
                Task first = v.get(0);
                first = fillTaskDetail(first);
                dealFeatures(first);
                vo.setTask(first);
                v.set(0, first);
                resp.getPaths().add(vo);
            }
        }
        return resp;
    }

    private void dealFeatures(Task detail) {
        if (null == detail) {
            return;
        }
        detail.setFeatures(detail.getFeeInfo());
    }
    private Task fillTaskDetail(Task task) throws DWException {
        if (task == null) {
            return null;
        }
        task = dataPickService.findBetter(task.getCode(), Task.class);
        if (null != task.getFlowCode()) {
            FlowGraph graph = dataPickService.findByCode(task.getFlowCode(), FlowGraph.class);
            task.setFlow(graph);
        }
        return task;
    }

    private List<Task> bestTaskByFrom(String from, DataRequest request) throws DWBusinessException {
        List<String> codes = new ArrayList<>();
        codes.add(from);
        Map<String, Object> param = new HashMap<>();
        param.put("from", codes);
        List<Task> tasks = dataPickService.find(BasicQuery.of(param, request.getEocInfo()), Task.class);
        tasks.forEach(task -> {
            for (StateMap sm : task.getStateMaps()) {
                if (from.equals(sm.getInput())) {
                    if (null != sm.getGroup()) {
                        task.setGroup(sm.getGroup());
                    }
                    break;
                }
            }
        });

        return tasks;
    }

    private void sortTasks(List<Task> tasks, DataRequest request) {
        for (Task t : tasks) {
            if (null == t.getPriority()) {
                t.setPriority(0);
            }
            if (null == t.getScore()) {
                t.setScore(0);
            }
            t.setScore(t.getPriority() * 100 + t.getScore());
            if (CollectionUtils.isNotEmpty(t.getDataFeatures()) && !request.getDateFeatures().isEmpty()) {
                for (DataTagging dt : t.getDataFeatures()) {
                    if (request.getDateFeatures().contains(dt.getCode())) {
                        t.setScore(t.getScore() + dt.getWeight());
                    }
                }
            }
        }
        tasks.sort((o1, o2) -> o2.getScore() - o1.getScore());
    }

    private boolean reachProjectEnd(String current, String to, Project project) {
        if (to.equals(current)) {
            return true;
        }
        if (null != project.getEnds()) {
            for (DataState state : project.getEnds()) {
                if (state.getCode().equals(current)) {
                    return true;
                }
            }
        }

        return false;
    }


}
