/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.kmservice.action.metadata;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.app.resource.DWResourceBundleUtils;
import com.digiwin.athena.dto.ApiDataFieldMetadataDTO;
import com.digiwin.athena.kg.action.ActionRequestMetadataDTO;
import com.digiwin.athena.kg.action.ActionResponseMetadataDTO;
import com.digiwin.athena.kmservice.action.execution.model.ActionDefinitionDTO;
import com.digiwin.athena.kmservice.action.execution.model.ActionRequestDefinitionDTO;
import com.digiwin.athena.kmservice.action.execution.model.ActionResponseDefinitionDTO;
import com.digiwin.athena.kmservice.action.execution.model.ApiDataFieldDefinitionDTO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.CollectionUtils;

public abstract class ActionMetadataGeneratorBase {
    public ActionDefinitionDTO Generate(Map<String, Object> actionQueryResult) {
        ActionDefinitionDTO metadataDTO = this.CreateInstance(actionQueryResult);
        metadataDTO.setActionId(actionQueryResult.get("actionId").toString());
        metadataDTO.setRequest(this.generateRequest(actionQueryResult));
        metadataDTO.setResponse(this.generateResponse(actionQueryResult));
        metadataDTO.setActionMode(actionQueryResult.get("actionMode"));
        metadataDTO.setAggregation(actionQueryResult.get("aggregation"));
        if (Objects.nonNull(actionQueryResult.get("lang"))) {
            String locale = DWResourceBundleUtils.getCurrentLocale().toString();
            JSONObject lang = (JSONObject)actionQueryResult.get("lang");
            this.updateMetadataDTO(lang, locale, metadataDTO);
        }
        return metadataDTO;
    }

    protected abstract ActionDefinitionDTO CreateInstance(Map<String, Object> var1);

    public ActionRequestDefinitionDTO generateRequest(Map<String, Object> actionQueryResult) {
        ActionRequestMetadataDTO requestMetadataDTO = new ActionRequestMetadataDTO();
        requestMetadataDTO.setParameters(JSON.parseArray((String)actionQueryResult.get("request_parameters").toString(), ApiDataFieldMetadataDTO.class));
        ActionRequestDefinitionDTO requestDefinitionDTO = new ActionRequestDefinitionDTO();
        ArrayList<ApiDataFieldDefinitionDTO> fields = new ArrayList<ApiDataFieldDefinitionDTO>();
        if (!CollectionUtils.isEmpty((Collection)requestMetadataDTO.getParameters())) {
            for (ApiDataFieldMetadataDTO fieldMetadata : requestMetadataDTO.getParameters()) {
                fields.add(this.convert(fieldMetadata));
            }
        }
        requestDefinitionDTO.setParameters(fields);
        return requestDefinitionDTO;
    }

    public ActionResponseDefinitionDTO generateResponse(Map<String, Object> actionQueryResult) {
        ActionResponseMetadataDTO responseMetadataDTO = new ActionResponseMetadataDTO();
        responseMetadataDTO.setData((ApiDataFieldMetadataDTO)JSON.parseObject((String)actionQueryResult.get("response_object").toString(), ApiDataFieldMetadataDTO.class));
        ActionResponseDefinitionDTO responseDefinitionDTO = new ActionResponseDefinitionDTO();
        if (responseMetadataDTO.getData() != null) {
            responseDefinitionDTO.setData(this.convert(responseMetadataDTO.getData()));
        }
        return responseDefinitionDTO;
    }

    private ApiDataFieldDefinitionDTO convert(ApiDataFieldMetadataDTO metadata) {
        String remark;
        Locale locale = DWResourceBundleUtils.getCurrentLocale();
        String localeStr = locale.toString();
        ApiDataFieldDefinitionDTO definition = new ApiDataFieldDefinitionDTO();
        definition.setData_name(metadata.getData_name());
        definition.setData_type(metadata.getData_type());
        definition.setIs_array(metadata.getIs_array());
        definition.setIs_datakey(metadata.getIs_datakey());
        definition.setRequired(metadata.getRequired());
        definition.setIs_businesskey(metadata.getIs_businesskey());
        String description = metadata.getDescription() != null ? metadata.getDescription().getZh_CN() : null;
        String string = remark = metadata.getRemark() != null ? metadata.getRemark().getZh_CN() : null;
        if ("zh_TW".equals(localeStr) && StringUtils.isNotEmpty((CharSequence)description)) {
            description = metadata.getDescription().getZh_TW();
        }
        if ("zh_TW".equals(localeStr) && StringUtils.isNotEmpty((CharSequence)remark)) {
            remark = metadata.getRemark().getZh_TW();
        }
        definition.setDescription(description);
        definition.setRemark(remark);
        definition.setEnum_key(metadata.getEnum_key());
        definition.setCan_filter(metadata.isCan_filter());
        definition.setCan_sort(metadata.isCan_sort());
        definition.setPercent(metadata.getPercent());
        definition.setDecimal(metadata.getDecimal());
        ArrayList<ApiDataFieldDefinitionDTO> fieldDefinitionDTOS = new ArrayList<ApiDataFieldDefinitionDTO>();
        if (metadata.getField() != null) {
            for (ApiDataFieldMetadataDTO fieldMetadata : metadata.getField()) {
                fieldDefinitionDTOS.add(this.convert(fieldMetadata));
            }
        }
        definition.setField(fieldDefinitionDTOS);
        return definition;
    }

    private void updateMetadataDTO(JSONObject lang, String locale, ActionDefinitionDTO metadataDTO) {
        if (Objects.nonNull(lang)) {
            this.updateField(lang.getJSONObject("actionName"), locale, metadataDTO::setActionName);
            this.updateField(lang.getJSONObject("actionTypeDescription"), locale, metadataDTO::setActionTypeDescription);
        }
    }

    private void updateField(JSONObject fieldJson, String locale, Consumer<String> fieldSetter) {
        String fieldValue;
        if (Objects.nonNull(fieldJson) && StringUtils.isNotEmpty((CharSequence)(fieldValue = fieldJson.getString(locale)))) {
            fieldSetter.accept(fieldValue);
        }
    }
}

