/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.kmservice.cache.old;

import com.alibaba.fastjson.JSON;
import com.digiwin.athena.kmservice.cache.old.Cache;
import com.digiwin.athena.kmservice.cache.old.ParamIndex;
import com.digiwin.athena.kmservice.cache.old.RedisConf;
import com.digiwin.athena.kmservice.cache.old.RedisDataType;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.sql.Date;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StopWatch;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Aspect
@Component(value="oldCacheAspect")
public class CacheAspect {
    private static final Logger log = LoggerFactory.getLogger(CacheAspect.class);
    @Autowired
    private RedisTemplate redisTemplate;
    @Autowired
    private RedisConf redisConf;

    @Around(value="@annotation(com.digiwin.athena.kmservice.cache.old.Cache)")
    public Object cache(ProceedingJoinPoint jp) throws Throwable {
        StopWatch clock;
        Object result;
        block12: {
            if (!this.redisConf.getUse().booleanValue()) {
                return jp.proceed();
            }
            Signature sig = jp.getSignature();
            if (!(sig instanceof MethodSignature)) {
                throw new IllegalArgumentException("\u8be5\u6ce8\u89e3\u53ea\u80fd\u653e\u5728\u65b9\u6cd5\u4e0a");
            }
            MethodSignature msig = (MethodSignature)sig;
            Method method = msig.getMethod();
            Cache annotation = method.getAnnotation(Cache.class);
            Class<?> returnType = method.getReturnType();
            RedisDataType redisDataType = annotation.dataType();
            boolean language = annotation.language();
            boolean tenant = annotation.tenant();
            String key = this.generateKey(method, jp.getArgs(), language, tenant);
            result = null;
            Boolean hasKey = false;
            Boolean proceedThrowError = false;
            clock = new StopWatch();
            try {
                clock.start();
                if (!RedisDataType.STRING.equals((Object)redisDataType)) break block12;
                hasKey = this.redisTemplate.hasKey((Object)key);
                result = this.redisTemplate.opsForValue().get((Object)key);
                log.info("hasKey({}):{},resultIsEmpty:{}", new Object[]{key, hasKey, ObjectUtils.isEmpty((Object)result)});
                if ((hasKey.booleanValue() || !ObjectUtils.isEmpty((Object)result)) && (!hasKey.booleanValue() || !ObjectUtils.isEmpty((Object)result) || annotation.loadEmpty())) break block12;
                log.info("get data from cache with key({}) is null, execute method", (Object)key);
                try {
                    result = jp.proceed();
                }
                catch (Throwable throwable) {
                    proceedThrowError = true;
                    throw throwable;
                }
                if (!ObjectUtils.isEmpty((Object)result) || annotation.loadEmpty()) {
                    if (annotation.ttlSecs() == 0L) {
                        this.redisTemplate.opsForValue().set((Object)key, result);
                    } else {
                        this.redisTemplate.opsForValue().set((Object)key, result, annotation.ttlSecs(), TimeUnit.SECONDS);
                    }
                }
            }
            catch (Throwable throwable) {
                if (proceedThrowError.booleanValue()) {
                    throw throwable;
                }
                log.error("cache error:{}, execute method", (Object)throwable.getMessage());
                result = jp.proceed();
            }
        }
        clock.stop();
        return result;
    }

    private Object castedValue(Object value) throws Exception {
        String result = this.toString(value);
        String[] split = StringUtils.split((String)result, (String)"@@@");
        if (split.length == 3) {
            return JSON.parseArray((String)split[2], Class.forName(split[1]));
        }
        if (split.length == 2) {
            return JSON.parseObject((String)split[1], Class.forName(split[0]));
        }
        return value;
    }

    private String valueWithClazz(Object result, Method method) {
        Type genericReturnType = method.getGenericReturnType();
        if (null == genericReturnType) {
            return JSON.toJSONString((Object)result);
        }
        if (genericReturnType instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)genericReturnType;
            Type actualTypeArgument1 = pt.getActualTypeArguments()[0];
            return result.getClass().getName() + "@@@" + actualTypeArgument1.getTypeName() + "@@@" + JSON.toJSONString((Object)result);
        }
        return result.getClass().getName() + "@@@" + JSON.toJSONString((Object)result);
    }

    private String valueWithClazz(Object result) {
        return result.getClass().getName() + "@@@" + JSON.toJSONString((Object)result);
    }

    private String generateKey(Method method, Object[] args, boolean language, boolean tenant) {
        ServletRequestAttributes requestAttributes;
        ServletRequestAttributes requestAttributes2;
        ServletRequestAttributes requestAttributes3;
        Cache annotation = method.getAnnotation(Cache.class);
        String redisKey = annotation.key();
        if (StringUtils.isEmpty((CharSequence)redisKey)) {
            redisKey = method.getName();
        }
        StringBuilder sb = new StringBuilder(annotation.namespace());
        boolean application = annotation.application();
        String applicationCode = "SYSTEM";
        if (application && (requestAttributes3 = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes()) != null) {
            HttpServletRequest request = requestAttributes3.getRequest();
            applicationCode = ObjectUtils.isEmpty((Object)request.getHeader("applicationCode")) ? "SYSTEM" : request.getHeader("applicationCode");
        }
        sb.append(":").append(applicationCode);
        String tenantId = "SYSTEM";
        if (tenant && (requestAttributes2 = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes()) != null) {
            HttpServletRequest request = requestAttributes2.getRequest();
            tenantId = ObjectUtils.isEmpty((Object)request.getAttribute("tenantId")) ? "SYSTEM" : request.getAttribute("tenantId").toString();
        }
        sb.append(":").append(tenantId);
        String locale = "zh_CN";
        if (language && (requestAttributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes()) != null) {
            HttpServletRequest request = requestAttributes.getRequest();
            locale = ObjectUtils.isEmpty((Object)request.getHeader("locale")) ? "zh_CN" : request.getHeader("locale");
        }
        sb.append(":").append(locale);
        sb.append(":");
        if (annotation.useParamIndex()) {
            sb.append(redisKey);
            int parameterCount = method.getParameterCount();
            if (parameterCount == 0) {
                return sb.toString();
            }
            if (parameterCount == 1) {
                return sb.append("$").append(args[0]).toString();
            }
            boolean hasKeyParam = false;
            Parameter[] parameters = method.getParameters();
            StringBuilder noKeyParam = new StringBuilder();
            TreeMap sortedMap = new TreeMap();
            ArrayList<Integer> orderList = null;
            for (int i = 0; i < parameters.length; ++i) {
                ParamIndex annotationKeyParam = parameters[i].getAnnotation(ParamIndex.class);
                if (annotationKeyParam != null) {
                    hasKeyParam = true;
                    if (sortedMap.containsKey(annotationKeyParam.order())) {
                        ((List)sortedMap.get(annotationKeyParam.order())).add(annotationKeyParam.value());
                    } else {
                        orderList = new ArrayList<Integer>();
                        orderList.add(annotationKeyParam.value());
                        sortedMap.put(annotationKeyParam.order(), orderList);
                    }
                }
                if (hasKeyParam) continue;
                noKeyParam.append("$").append(args[i]);
            }
            if (hasKeyParam) {
                StringBuffer keyParam = new StringBuffer();
                for (Map.Entry temp : sortedMap.entrySet()) {
                    ((List)temp.getValue()).forEach(e -> keyParam.append("$").append(args[e]));
                }
                return sb.append(keyParam).toString();
            }
            return sb.append((CharSequence)noKeyParam).toString();
        }
        Class<?>[] parameterTypes = method.getParameterTypes();
        String[] split = StringUtils.split((String)redisKey, (String)"$");
        StringBuilder toReplaceKey = new StringBuilder(split[0]);
        if (split.length > 1) {
            for (int i = 1; i < split.length; ++i) {
                toReplaceKey.append("$").append(this.toString(args[Integer.parseInt(split[i])], parameterTypes[Integer.parseInt(split[i])]));
            }
        }
        return sb.append((CharSequence)toReplaceKey).toString();
    }

    private String getField() {
        return null;
    }

    private String getRequestParam(ProceedingJoinPoint jp) {
        try {
            Object[] args;
            ArrayList<String> paramList = new ArrayList<String>();
            for (Object arg : args = jp.getArgs()) {
                String paramStr;
                if (arg instanceof HttpServletRequest || arg instanceof HttpServletResponse || (paramStr = this.toString(arg)) == null) continue;
                paramList.add(paramStr);
            }
            return ((Object)paramList).toString();
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u8bf7\u6c42\u53c2\u6570\u5f02\u5e38", (Throwable)e);
            return "";
        }
    }

    private String toString(Object arg) {
        if (arg instanceof String) {
            return String.valueOf(arg);
        }
        return JSON.toJSONString((Object)arg);
    }

    private String toString(Object arg, Class type) {
        if (CacheAspect.isPrimitive(type)) {
            return String.valueOf(arg);
        }
        return JSON.toJSONString((Object)arg);
    }

    private static boolean isPrimitive(Class<?> c) {
        return c != null && (c.isPrimitive() || c.equals(String.class) || Number.class.isAssignableFrom(c) || Boolean.class.equals(c) || Character.class.isAssignableFrom(c) || java.util.Date.class.equals(c) || Date.class.equals(c));
    }

    private static boolean isWrapClass(Class clz) {
        try {
            return ((Class)clz.getField("TYPE").get(null)).isPrimitive();
        }
        catch (Exception e) {
            return false;
        }
    }
}

