package com.digiwin.athena.kmservice.action.execution;

import com.digiwin.athena.kmservice.common.Constants;
import com.digiwin.athena.kmservice.action.execution.model.ActionExecutionParamDTO;
import com.digiwin.athena.kmservice.action.execution.model.ActionParamTypeEnum;
import com.digiwin.athena.kmservice.action.execution.model.PullingActionExecutionParamDTO;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.CollectionUtils;

import java.util.*;

public class LevelMapping {
    private final static String SPLIT = "##";
    private Map<String, String> valueToName = new HashMap<>();
    private Map<String, ActionExecutionParamDTO> nameToExecutionParam = new HashMap<>();
    private Map<String, Set<String>> nameToVaule = new HashMap<>();
    private Map<String, Set<String>> sourcePulling = new HashMap<>();


    public LevelMapping() {
        Set<String> set = new HashSet<>();
        set.add(Constants.ROOT);
        nameToVaule.put(Constants.ROOT, set);
    }

    public void put(List<String> existsParam, String targetPath) {
        if (existsParam.contains(targetPath)) {  //existsParam包含的是fieldPath
            if(targetPath.lastIndexOf(".") > 0){ //表示是field
                while (targetPath.lastIndexOf(".") > 0) {
                    targetPath = targetPath.substring(0, targetPath.lastIndexOf("."));
                    Set<String> valueLevelList = null;
                    if ((valueLevelList = nameToVaule.get(Constants.ROOT + targetPath)) == null) {
                        valueLevelList = new HashSet<>();
                    }
                    boolean add = true;
                    Iterator<String> it = valueLevelList.iterator();
                    while (it.hasNext()) {
                        String check = it.next();
                        if (!StringUtils.equals(Constants.ROOT + targetPath, check) && (Constants.ROOT + targetPath).contains(check)) {
                            it.remove();
                        }
                        if (check.contains(Constants.ROOT + targetPath)) {
                            add = false;
                        }
                    }
                    if (add) {
                        valueLevelList.add(Constants.ROOT + targetPath);
                    }
                    nameToVaule.put(Constants.ROOT + targetPath, valueLevelList);
                }
            }else{ //表示直接是集合
                Set<String> valueLevelList = null;
                if ((valueLevelList = nameToVaule.get(Constants.ROOT + targetPath)) == null) {
                    valueLevelList = new HashSet<>();
                }
                boolean add = true;
                Iterator<String> it = valueLevelList.iterator();
                while (it.hasNext()) {
                    String check = it.next();
                    if (!StringUtils.equals(Constants.ROOT + targetPath, check) && (Constants.ROOT + targetPath).contains(check)) {
                        it.remove();
                    }
                    if (check.contains(Constants.ROOT + targetPath)) {
                        add = false;
                    }
                }
                if (add) {
                    valueLevelList.add(Constants.ROOT + targetPath);
                }
                nameToVaule.put(Constants.ROOT + targetPath, valueLevelList);
            }
        } else if (existsParam.contains(targetPath.substring(targetPath.lastIndexOf(".") + 1))) { //existsParam包含的是fieldName
            targetPath = targetPath.substring(0, targetPath.lastIndexOf("."));
            Set<String> valueLevelList = null;
            if ((valueLevelList = nameToVaule.get(Constants.ROOT + targetPath)) == null) {
                valueLevelList = new HashSet<>();
            }
            boolean add = true;
            Iterator<String> it = valueLevelList.iterator();
            while (it.hasNext()) {
                String check = it.next();
                if (check.contains(Constants.ROOT)) {
                    add = false;
                }
            }

            if (add) {
                valueLevelList.add(Constants.ROOT);
            }

            // todo 湖州敏捷报表缺失$.data,此情况是$.data.data的时候出现第一层data没有其他入参的情况，先这样处理,后续去掉
            /*if (StringUtils.isNotEmpty(targetPath)) {
                String[] pathSegments = targetPath.split("\\.");
                if (pathSegments.length >= 2 && pathSegments[0].equals(pathSegments[1])) {
                    nameToVaule.put(ActionCons.ROOT + pathSegments[0], valueLevelList);
                }
            }*/
            /*String[] pathSegments = targetPath.split("\\.");
            int levels = pathSegments.length;
            for (int i = 0; i < levels; i++) {
                int dotIndex = targetPath.lastIndexOf(".");
                if (dotIndex == -1) {
                    break; // 如果字符串中没有更多的部分，则退出循环
                }

                String part = targetPath.substring(0, dotIndex);
                nameToVaule.put(ActionCons.ROOT + part, valueLevelList);
                targetPath = part; // 更新目标路径为当前部分

                if (i == levels - 1) {
                    // 添加最后一级路径
                    nameToVaule.put(ActionCons.ROOT + targetPath, valueLevelList);
                }
            }*/
            nameToVaule.put(Constants.ROOT + targetPath, valueLevelList);
        }
    }

    public void put(String existsParamMatched, String targetPath) {
        boolean flag = true;
        while (existsParamMatched.lastIndexOf(".") > 0 && targetPath.lastIndexOf(".") > 0) {
            flag = false;
            existsParamMatched = existsParamMatched.substring(0, existsParamMatched.lastIndexOf("."));
            targetPath = targetPath.substring(0, targetPath.lastIndexOf("."));
            Set<String> valueLevelList = null;
            if ((valueLevelList = nameToVaule.get(Constants.ROOT + targetPath)) == null) {
                valueLevelList = new HashSet<>();
            }
            boolean add = true;
            Iterator<String> it = valueLevelList.iterator();
            while (it.hasNext()) {
                String check = it.next();
                if (!StringUtils.equals(Constants.ROOT + existsParamMatched, check) && (Constants.ROOT + existsParamMatched).contains(check)) {
                    it.remove();
                }
                if (check.contains(Constants.ROOT + existsParamMatched)) {
                    add = false;
                }
            }
            if (add) {
                valueLevelList.add(Constants.ROOT + existsParamMatched);
            }
            nameToVaule.put(Constants.ROOT + targetPath, valueLevelList);
        }

        if (flag && existsParamMatched.lastIndexOf(".") > 0) {
            Set<String> valueLevelList = null;
            if ((valueLevelList = nameToVaule.get(Constants.ROOT)) == null) {
                valueLevelList = new HashSet<>();
            }
            boolean add = true;
            Iterator<String> it = valueLevelList.iterator();
            String value = Constants.ROOT + existsParamMatched.substring(0, existsParamMatched.lastIndexOf("."));
            while (it.hasNext()) {
                String check = it.next();
                if (!StringUtils.equals(value, check) && value.contains(check)) {
                    it.remove();
                }
                if (check.contains(value)) {
                    add = false;
                }
            }
            if (add) {
                valueLevelList.add(value);
            }
            nameToVaule.put(Constants.ROOT, valueLevelList);
        }

        if (targetPath.lastIndexOf(".") > 0) {
            Set<String> valueLevelList = null;
            if ((valueLevelList = nameToVaule.get(Constants.ROOT + targetPath)) == null) {
                valueLevelList = new HashSet<>();
            }
            boolean add = true;
            Iterator<String> it = valueLevelList.iterator();
            while (it.hasNext()) {
                String check = it.next();
                if (check.contains(Constants.ROOT)) {
                    add = false;
                }
            }
            if (add) {
                valueLevelList.add(Constants.ROOT);
            }
            nameToVaule.put(Constants.ROOT + targetPath, valueLevelList);
        }
    }

    public void putPulling(String source, String name, String value){
        String namePath = name.substring(0, name.lastIndexOf("."));
        String valuePath = value.substring(0, value.lastIndexOf("."));
        //对象中的参数来源param和pulling时，说明此对象这个层级来源非唯一，考虑增加pulling的层级映射
        //namePath == $ 时表示此参数不在对象中
        if(!("$".equals(namePath) && "$".equals(valuePath))){
            //generate最终结果时再判断此对象中是否只有pulling来源
            Set<String> nameAndValueSet = sourcePulling.get(source);
            if(CollectionUtils.isEmpty(nameAndValueSet)){
                nameAndValueSet = new HashSet<>();

            }
            nameAndValueSet.add(namePath + SPLIT + valuePath);
            sourcePulling.put(source, nameAndValueSet);
//            sourcePulling.put(source, namePath + SPLIT + valuePath);
        }

    }
    public List<ActionExecutionParamDTO> generate() {
        List<ActionExecutionParamDTO> result = new ArrayList<>();
        for (String name : nameToVaule.keySet()) {
            Set<String> valueSet = nameToVaule.get(name);
            valueSet.forEach(e -> {
                ActionExecutionParamDTO paramDTO = new ActionExecutionParamDTO();
                paramDTO.setType(ActionParamTypeEnum.PARAM);
                paramDTO.setName(this.removeLastPoint(name));
                paramDTO.setValue(this.removeLastPoint(e));
                String existsName = valueToName.get(e);
                if(StringUtils.isEmpty(existsName)){
                    valueToName.put(e, name);
                    nameToExecutionParam.put(name, paramDTO);
                    result.add(paramDTO);
                }else if(name.contains(existsName)){
                    // todo 湖州敏捷报表缺失$.data
                    result.remove(nameToExecutionParam.get(existsName));
                    valueToName.put(e, name);
                    nameToExecutionParam.put(name, paramDTO);
                    result.add(paramDTO);
                }else if(!existsName.contains(name)){
                    valueToName.put(e, name);
                    nameToExecutionParam.put(name, paramDTO);
                    result.add(paramDTO);
                }
            });
        }
        clearResult(result);
        Set<Map.Entry<String, Set<String>>> entries = sourcePulling.entrySet();
        for(Map.Entry<String, Set<String>> entry : entries){
            String source = entry.getKey();
            Set<String> valueSet = entry.getValue();
            if(!CollectionUtils.isEmpty(valueSet)){
                for(String val : valueSet){
                    String namePath = val.split(SPLIT)[0];
                    String valuePath = val.split(SPLIT)[1];
//            if(nameToVaule.containsKey(namePath)){ //表明不止pulling来源
                    PullingActionExecutionParamDTO pullingParamDTO = new PullingActionExecutionParamDTO();
                    pullingParamDTO.setType(ActionParamTypeEnum.PULLING);
                    pullingParamDTO.setSource(source);
                    pullingParamDTO.setName(namePath);
                    pullingParamDTO.setValue(valuePath);
                    result.add(pullingParamDTO);
//            }
                }
            }

        }
        return removeConflictMapping(result);
    }

    /**
     *                  {
     *                         "name": "$.reply_date.multi_data",
     *                         "value": "$",
     *                         "type": "PARAM"
     *                     },
     *                     {
     *                         "name": "$.reply_date",
     *                         "value": "$.reply_date",
     *                         "type": "PARAM"
     *                     }
     *                     类似此种结构，则把第一个映射给去除
     * @param result
     * @return
     */
    private List<ActionExecutionParamDTO> removeConflictMapping(List<ActionExecutionParamDTO> result){
        if(result.size() <= 1){ //只有一个时，没有冲突节点
            return result;
        }

        Set<ActionExecutionParamDTO> removedList = new HashSet<>(result);
        outer:
        for(int i = 0; i < result.size() - 1; i++){
            for(int j = i + 1; j < result.size(); j++){
                ActionExecutionParamDTO dtoi = result.get(i);
                ActionExecutionParamDTO dtoj = result.get(j);
                if(StringUtils.equals(dtoi.getName(), "$")){
                    continue outer;
                }
                if(StringUtils.equals(dtoj.getName(), "$")){
                    continue;
                }
                if(dtoi.getName().startsWith(dtoj.getName()) && !dtoi.getValue().startsWith(dtoj.getValue())
                        && StringUtils.equals(dtoi.getType().name(), dtoj.getType().name())){
                    if(ActionParamTypeEnum.PULLING.equals(dtoi.getType())){
                        PullingActionExecutionParamDTO dtoi1 = (PullingActionExecutionParamDTO) dtoi;
                        PullingActionExecutionParamDTO dtoj1 = (PullingActionExecutionParamDTO) dtoj;
                        if(StringUtils.equals(dtoi1.getSource(), dtoj1.getSource())){
                            removedList.remove(dtoi);
                            continue outer;
                        }
                    }else {
                        removedList.remove(dtoi);
//                    removedList.add(dtoj);
                        continue outer;
                    }
                }else if(dtoj.getName().startsWith(dtoi.getName()) && !dtoj.getValue().startsWith(dtoi.getValue())
                        && StringUtils.equals(dtoi.getType().name(), dtoj.getType().name())){
                    if(ActionParamTypeEnum.PULLING.equals(dtoi.getType())){
                        PullingActionExecutionParamDTO dtoi1 = (PullingActionExecutionParamDTO) dtoi;
                        PullingActionExecutionParamDTO dtoj1 = (PullingActionExecutionParamDTO) dtoj;
                        if(StringUtils.equals(dtoi1.getSource(), dtoj1.getSource())){
                            removedList.remove(dtoj);
                            continue;
                        }
                    }else {
                        removedList.remove(dtoj);
//                    removedList.add(dtoi);
                        continue;
                    }
                }/*else{
                    removedList.add(dtoj);
                }*/
            }
        }
        return new ArrayList<>(removedList);
    }

    private void clearResult(List<ActionExecutionParamDTO> result){
        //只有$对$的映射时去除
        if(!CollectionUtils.isEmpty(result) && result.size() == 1
                && result.get(0).getName().length() == 1 && result.get(0).getValue().length() == 1 ){
            result.clear();
        }
    }

    private String removeLastPoint(String str){
        if(StringUtils.isEmpty(str)){
            return str;
        }
        int length = str.length();
        if(".".equals(String.valueOf(str.charAt(length - 1)))){
            return str.substring(0, length-1);
        }else{
            return str;
        }

    }
}
