package com.digiwin.athena.kmservice.action.metadata;

import com.digiwin.athena.kmservice.common.Neo4jConstants;
import com.digiwin.athena.kmservice.action.execution.model.ActionDefinitionDTO;
import com.digiwin.athena.kmservice.action.execution.model.ActionExecutionDTO;
import com.digiwin.athena.kmservice.action.execution.model.ActionTypeEnum;
import com.digiwin.athena.kmservice.action.execution.model.StartProcessActionExecutionDTO;
import org.springframework.stereotype.Component;
import org.springframework.util.ObjectUtils;

import java.util.Map;
@Component
public class StartProcessActionHandlerImpl implements ActionHandler<Map<String, Object>> {
//    @Autowired
//    private IAMUtils iamUtils;;

    @Override
    public ActionDefinitionDTO processMetadata(Map<String, Object> actionMatched) throws Exception {
        ActionDefinitionDTO eocDefinitionDTO = new StartProcessActionMetadataGenerator().Generate(actionMatched);
        return eocDefinitionDTO;
    }

    @Override
    public ActionExecutionDTO processExecution(Map<String, Object> actionMatched) throws Exception {
        StartProcessActionExecutionDTO executionDTO = new StartProcessActionExecutionDTO();
        Object o = actionMatched.get(Neo4jConstants.PROPERTY_START_PROCESS_ACTION_SUBJECT);
        if (o != null) {
            executionDTO.setSubject(o.toString());
        }
        executionDTO.setEmergency(Integer.parseInt(actionMatched.getOrDefault(Neo4jConstants.PROPERTY_START_PROCESS_ACTION_EMERGENCY, 50).toString()));
        executionDTO.setActionId(actionMatched.get(Neo4jConstants.PROPERTY_ACTION_ID).toString());
        //locale在com.digiwin.athena.knowledgegraph.action.ActionService.postActionExecutionProcessor中处理
//        executionDTO.setLocale(iamUtils.getTenantLocal());
//        executionDTO.setLocale("zh_TW");
        executionDTO.setRequesterId("Athena");
        executionDTO.setForEach((boolean)actionMatched.getOrDefault("split", false));
        executionDTO.setType(ActionTypeEnum.START_PROCESS);
        if(!ObjectUtils.isEmpty(actionMatched.get("async"))){
            executionDTO.setAsync(Boolean.parseBoolean(String.valueOf(actionMatched.get("async"))));
        }
        return executionDTO;
    }

    @Override
    public String getActionLabel() {
        return Neo4jConstants.LABEL_START_PROCESS_ACTION;
    }
}
