package com.digiwin.athena.knowledgegraph;


import com.jugg.agile.framework.core.dapper.alarm.JaNotify;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.autoconfigure.data.neo4j.Neo4jDataAutoConfiguration;
import org.springframework.boot.autoconfigure.domain.EntityScan;
import org.springframework.boot.context.ApplicationPidFileWriter;
import org.springframework.data.neo4j.repository.config.EnableNeo4jRepositories;
import org.springframework.retry.annotation.EnableRetry;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.scheduling.annotation.EnableScheduling;

@SpringBootApplication(scanBasePackages = {
        "com.digiwin.gateway",
        "com.digiwin.athena.knowledgegraph",
        "com.digiwin.athena.kmservice"
})
@EntityScan({"com.digiwin.athena.domain"
        , "com.digiwin.athena.kg"
        , "com.digiwin.athena.knowledgegraph.domain"
        , "com.digiwin.athena.knowledgegraph.domain2"})
@EnableScheduling
@EnableAsync
@EnableRetry
@EnableNeo4jRepositories(basePackages = "com.digiwin.athena.repository.neo4j")
public class AppBoot {

    {
        System.out.println("dapstart knowledgegraph run...");
    }

    public static void main(String[] args) throws Throwable {

        JaNotify.notifyRun(() -> {
            try {
                SpringApplication springApplication = new SpringApplication(AppBoot.class);
                springApplication.addListeners(new ApplicationPidFileWriter("DWApiGatewayApplication.pid"));
                springApplication.run(args);
            } catch (Throwable e) {
                e.printStackTrace();
                throw e;
            }
        });
    }


    public static void test01() {

        Neo4jDataAutoConfiguration neo4jDataAutoConfiguration;
    }
}
