package com.digiwin.athena.knowledgegraph.action.model.report;

import lombok.Data;

/**
 * @title: Dimension
 * @author: linc
 * @date 2023/11/22 18:21
 * @version: 1.0
 */
@Data
public class Dimension {
    /**
     * 日期格式
     */
    private String dateGranularity;
    /**
     * 字段Code
     */
    private String field;

    private String name;
}

enum DateGranularity {
    D, H, H_M_S, M, Q, W, Y, Y_M, Y_M_D, Y_M_D_H_M, Y_M_D_H_M_S, Y_Q, Y_W;

    public String toValue() {
        switch (this) {
            case D: return "d";
            case H: return "H";
            case H_M_S: return "H_m_s";
            case M: return "M";
            case Q: return "Q";
            case W: return "W";
            case Y: return "y";
            case Y_M: return "y_M";
            case Y_M_D: return "y_M_d";
            case Y_M_D_H_M: return "y_M_d_H_m";
            case Y_M_D_H_M_S: return "y_M_d_H_m_s";
            case Y_Q: return "y_Q";
            case Y_W: return "y_W";
        }
        return null;
    }

    public static DateGranularity forValue(String value) throws Exception {
        if (value.equals("d")) return D;
        if (value.equals("H")) return H;
        if (value.equals("H_m_s")) return H_M_S;
        if (value.equals("M")) return M;
        if (value.equals("Q")) return Q;
        if (value.equals("W")) return W;
        if (value.equals("y")) return Y;
        if (value.equals("y_M")) return Y_M;
        if (value.equals("y_M_d")) return Y_M_D;
        if (value.equals("y_M_d_H_m")) return Y_M_D_H_M;
        if (value.equals("y_M_d_H_m_s")) return Y_M_D_H_M_S;
        if (value.equals("y_Q")) return Y_Q;
        if (value.equals("y_W")) return Y_W;
        throw new Exception("Cannot deserialize DateGranularity");
    }
}
