package com.digiwin.athena.knowledgegraph.clients;

import com.alibaba.fastjson.JSON;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.athena.knowledgegraph.utils.Utils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.http.Header;
import org.apache.http.message.BasicHeader;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;
import org.springframework.stereotype.Service;

import java.util.HashMap;

/**
 * <Description> <br>
 *
 * @author wang.xinyuan<br>
 * @version 1.0<br>
 * @taskId <br>
 * @CreateDate 2021/11/12 <br>
 * @see: com.digiwin.athena.knowledgegraph.utils.AtmcUtils <br>
 */
@Configuration
@Service
public class AtmcUtils {

    @Value("${atmcUrl}")
    private String atmcUrl;

    private final String ATMC_TASK_INFO = "/api/atmc/v1/taskBacklog/history/findTaskBacklogH";

    public HashMap postAtmcTask(Header[] headers, String jsonbody) {

        if (null == headers) {
            headers = Utils.requiredHeaders();
        }

        String token = DWServiceContext.getContext().getToken();
        if (null != token) {
            Header auth = new BasicHeader("token", token);
            headers = ArrayUtils.add(headers, auth);

        }
        String url = atmcUrl + ATMC_TASK_INFO;

        String body = Utils.postJson(url, headers, jsonbody);

        HashMap map = JSON.parseObject(body, HashMap.class);

        return map;

    }
}