package com.digiwin.athena.knowledgegraph.clients;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.athena.knowledgegraph.utils.HttpUtil;
import com.digiwin.athena.knowledgegraph.utils.Utils;
import com.digiwin.athena.kg.authority.AppAuthorizationsResponse;
import com.digiwin.http.client.utils.DWRequestHeaderUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.*;

@Service
@Slf4j
public class CacService {

    @Autowired
    @Qualifier("cacRestTemplate")
    RestTemplate restTemplate;

    @Value("${cacUrl}")
    private String cacUrl;

    @Value("${iamApToken}")
    private String iamApToken;

    private final String AUTHORIZATIONS_TENANTS = "/api/cac/v4/authorizations/tenants/";
    private final String APP_TENANT_INFO = "/api/cac/v4/authorizations/category/app/exclude/policy";

    public Object authorizationsTenants(String tenantId){
        String requestUrl = cacUrl + AUTHORIZATIONS_TENANTS + tenantId;
        HttpHeaders headers = new HttpHeaders();
        Utils.requiredHeaders(headers);
        headers.set(DWRequestHeaderUtils.HEADER_IAM_API_USER_TOKEN, DWServiceContext.getContext().getToken());
        HttpEntity<JSONObject> httpEntity = new HttpEntity<>( headers);
        ResponseEntity<Object> exchange = restTemplate.exchange(requestUrl, HttpMethod.GET, httpEntity, Object.class);
        Object forObject = exchange.getBody();
        return forObject;
    }

//    public List<String> getAithorizationsApplication(String tenantId){
//        List<String> appLists = new ArrayList<>();
//        Object obj = this.authorizationsTenants(tenantId);
//        if( obj == null){
//            return appLists;
//        }
//        JSONArray jsonArray = JSON.parseArray(JSONObject.toJSONString(obj));
//        for(int i = 0 ; i < jsonArray.size(); i++){
//            String code = jsonArray.getJSONObject(i).getString("code");
//            if(!appLists.contains(code)){
//                appLists.add(code);
//            }
//        }
//        return appLists;
//    }

    public List<String> getAuthorizationsApplication(String tenantId){
        Set<String> appLists = new HashSet<>();
        Object obj = this.authorizationsTenants(tenantId);
        if( obj == null){
            return new ArrayList<>();
        }
        JSONArray jsonArray = JSON.parseArray(JSONObject.toJSONString(obj));
        for(int i = 0 ; i < jsonArray.size(); i++){
            String code = jsonArray.getJSONObject(i).getString("code");
            String expiredTime = jsonArray.getJSONObject(i).getString("expiredTime");
            DateTimeFormatter dtf2 = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
            LocalDateTime expiredLocalDateTime = LocalDateTime.parse(expiredTime, dtf2);
            if(expiredLocalDateTime.isBefore(LocalDateTime.now())){
                log.info("app:{} 已经过期了， expiredTime：{}",  code, expiredTime);
                continue;
            }
            appLists.add(code);
        }
        return new ArrayList<>(appLists);
    }

    public String effectiveTenantAndAppInfo(String appCode, int pageNum, int pageSize){

        Map<String, String> paramsMap = new HashMap<>();
        paramsMap.put("tenantId", "");
        paramsMap.put("goodsCode", appCode);
        //cac接口是比较expiredTime是否在 beginTime 和 endTime之间，所以beginTime取当前时间，endTime取9999-12-31
        paramsMap.put("beginTime", LocalDate.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd")));
        paramsMap.put("endTime", "9999-12-31");

        Map<String, Object> requestMap = new HashMap<>();
        requestMap.put("pageNum", pageNum);
        requestMap.put("pageSize", pageSize);
        requestMap.put("params", paramsMap);

        String requestUrl = cacUrl + APP_TENANT_INFO ;
        log.info("requestUrl:{}, requestParam:{}", requestUrl, requestMap);
        Map<String, String> header = Utils.requiredMapHeaders();
        header.put(DWRequestHeaderUtils.HEADER_IAM_API_APP_TOKEN, iamApToken);
//        if (AthenaUserLocal.getUser() != null) {
//            header.put("digi-middleware-auth-user", AthenaUserLocal.getUser().getToken());
//        }
        String forObject = HttpUtil.sendGet(requestUrl, JSON.toJSONString(requestMap), header);
        return forObject;
    }

    public AppAuthorizationsResponse getAllEffectiveTenantAndAppInfo(String appCode){
        String o = this.effectiveTenantAndAppInfo(appCode, 1, 50);
        AppAuthorizationsResponse firstResponse = JSON.parseObject(o, AppAuthorizationsResponse.class);
        int left = firstResponse.getTotal() - firstResponse.getList().size();
        int queryTimes = 1;
        while(left > 0){
            String o1 = this.effectiveTenantAndAppInfo(appCode, ++queryTimes, 50);
            AppAuthorizationsResponse againResponse = JSON.parseObject(o1, AppAuthorizationsResponse.class);
            firstResponse.getList().addAll(againResponse.getList());
            left -= againResponse.getList().size();
        }
        return firstResponse;
    }

    public String getExpiredTenantAndAppInfo(String appCode, int beginMinusDays, int endMinusDays, int pageNum, int pageSize){

        Map<String, String> paramsMap = new HashMap<>();
        paramsMap.put("tenantId", "");
        paramsMap.put("goodsCode", appCode);
        //cac接口是比较expiredTime是否在 beginTime 和 endTime之间，所以beginTime取当前时间-dayBeforeNow，endTime取当前时间前一天
        paramsMap.put("beginTime", LocalDate.now().minusDays(beginMinusDays).format(DateTimeFormatter.ofPattern("yyyy-MM-dd")));
        paramsMap.put("endTime", LocalDate.now().minusDays(endMinusDays).format(DateTimeFormatter.ofPattern("yyyy-MM-dd")));

        Map<String, Object> requestMap = new HashMap<>();
        requestMap.put("pageNum", pageNum);
        requestMap.put("pageSize", pageSize);
        requestMap.put("params", paramsMap);

        String requestUrl = cacUrl + APP_TENANT_INFO ;
        log.info("requestUrl:{}, requestParam:{}", requestUrl, requestMap);
        Map<String, String> header = new HashMap<>();
        header.put(DWRequestHeaderUtils.HEADER_IAM_API_APP_TOKEN, iamApToken);
//        if (AthenaUserLocal.getUser() != null) {
//            header.put("digi-middleware-auth-user", AthenaUserLocal.getUser().getToken());
//        }
        String forObject = HttpUtil.sendGet(requestUrl, JSON.toJSONString(requestMap), header);
        return forObject;
    }

    public AppAuthorizationsResponse getAllExpiredTenantAndAppInfo(String appCode, int beginMinusDays, int endMinusDays){
        String o = this.getExpiredTenantAndAppInfo(appCode, beginMinusDays, endMinusDays,1, 50);
        AppAuthorizationsResponse firstResponse = JSON.parseObject(o, AppAuthorizationsResponse.class);
        int left = firstResponse.getTotal() - firstResponse.getList().size();
        int queryTimes = 1;
        while(left > 0){
            String o1 = this.getExpiredTenantAndAppInfo(appCode, beginMinusDays, endMinusDays, ++queryTimes, 50);
            AppAuthorizationsResponse againResponse = JSON.parseObject(o1, AppAuthorizationsResponse.class);
            firstResponse.getList().addAll(againResponse.getList());
            left -= againResponse.getList().size();
        }
        return firstResponse;
    }


}
