package com.digiwin.athena.knowledgegraph.clients;

import com.alibaba.fastjson.JSON;
import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.athena.knowledgegraph.po.DapResponse;
import com.digiwin.athena.knowledgegraph.po.TbbGlobal;
import com.digiwin.athena.knowledgegraph.utils.I18nUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.*;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

import java.util.Collections;
import java.util.List;
import java.util.Map;

@Service
@Slf4j
public class TBBUtils {
    private final String GLOBAL_DASH_INFO = "/tbb-system/platform_integration/global_dash_info";
    @Value("${tbbUrl}")
    private String tbbUrl;
    @Autowired
    RestTemplate restTemplate;

    public List<TbbGlobal> getGlobal() throws DWBusinessException {
        String url = tbbUrl + GLOBAL_DASH_INFO;
        HttpHeaders headers = new HttpHeaders();
        headers.setAccept(Collections.singletonList(MediaType.APPLICATION_JSON));
        MediaType type = MediaType.parseMediaType("application/json; charset=UTF-8");
        headers.setContentType(type);
        HttpEntity<Map<String, String>> entity = new HttpEntity<>(headers);
        ResponseEntity<DapResponse> result = restTemplate.exchange(url, HttpMethod.GET, entity,DapResponse.class);
        try {
            log.info("getGlobal tbbRes:{}", result.getBody());
            Map response =(Map) result.getBody().getResponse();
            Object data = response.get("data");
            return JSON.parseArray(JSON.toJSONString(data), TbbGlobal.class);
        } catch (Exception e) {
            throw new DWBusinessException(I18nUtils.getValue("knowledgegraph.getGlobalError"));
        }
    }

}

