package com.digiwin.athena.knowledgegraph.component.dao;

import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.athena.domain.component.bo.TenantAppComponentListBO;
import com.digiwin.athena.knowledgegraph.component.ComponentManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Repository;

@Repository
public class TenantAppComponentListDAO {

    @Autowired
    @Qualifier("knowledgegraphTenant")
    private MongoTemplate mongoTemplate;

    public void SaveTenantAppComponentList(TenantAppComponentListBO tenantAppComponentList) throws DWBusinessException {
        this.mongoTemplate.save(tenantAppComponentList);
    }

    /**
     * 根据应用code和租户id获取用户授权下的应用组件
     * @param appCode
     * @param tenantId
     * @return
     * @throws DWBusinessException
     */
    public TenantAppComponentListBO findTenantAppComponentList(String appCode, String tenantId) throws DWBusinessException {

        Query query = new Query();
        query.addCriteria(Criteria.where(ComponentManager.APP_CODE).is(appCode)
                .and(ComponentManager.TENANT_ID).is(tenantId));
        TenantAppComponentListBO result = this.mongoTemplate.findOne(query, TenantAppComponentListBO.class);
        if (result != null) {
            return result;
        } else {
            //throw new DWBusinessException(String.format("No available component list of [%s] for tenant [%s]", appCode, tenantId));
            return null;
        }
    }

    /**
     * 根据应用code和租户id清除租户级应用组件数据
     * @param appCode 应用code
     * @param tenantId 租户id
     * @throws DWBusinessException
     */
    public void removeTenantAppComponentList(String appCode, String tenantId) throws DWBusinessException {
        Query query = new Query();
        query.addCriteria(Criteria.where(ComponentManager.APP_CODE).is(appCode)
                .and(ComponentManager.TENANT_ID).is(tenantId));
        this.mongoTemplate.remove(query, TenantAppComponentListBO.class);
    }
}
