package com.digiwin.athena.knowledgegraph.configuration;

import lombok.extern.slf4j.Slf4j;
import org.springframework.amqp.core.AcknowledgeMode;
import org.springframework.amqp.rabbit.annotation.EnableRabbit;
import org.springframework.amqp.rabbit.config.SimpleRabbitListenerContainerFactory;
import org.springframework.amqp.rabbit.connection.CachingConnectionFactory;
import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.amqp.rabbit.core.RabbitAdmin;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.amqp.RabbitAutoConfiguration;
import org.springframework.boot.autoconfigure.amqp.RabbitProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;

/**
 * MDC的rabbit,用于接收mdc发送的元数据信息，virtualhost与Athena用的不一致
 */
@Configuration
@Slf4j
public class MdcRabbitMQConfig {

    public static final String mdcConnectionFactory =  "mdcConnectionFactory";
    public static final String mdcRabbitTemplate =  "mdcRabbitTemplate";

    {
        System.out.println("========MdcRabbitMQConfig init========");
    }

//    @Value("${spring.rabbitmq.mdc.host}")
//    private String host;
//
//    @Value("${spring.rabbitmq.mdc.port}")
//    private int port;
//
//    @Value("${spring.rabbitmq.mdc.username}")
//    private String username;
//
//    @Value("${spring.rabbitmq.mdc.password}")
//    private String password;
//
//    @Value("${spring.rabbitmq.mdc.virtualHost}")
//    private String virtualHost;

    @Value("${spring.rabbitmq.mdc.addresses}")
    private String addresses;



    @Bean("mdcConnectionFactory")
    public ConnectionFactory mdcConnectionFactory(){
        CachingConnectionFactory connectionFactory = new CachingConnectionFactory();

        RabbitProperties properties = new RabbitProperties();
        properties.setAddresses(addresses);

        connectionFactory.setHost(properties.determineHost());
        connectionFactory.setPort(properties.determinePort());
        connectionFactory.setUsername(properties.determineUsername());
        connectionFactory.setPassword(properties.determinePassword());
        connectionFactory.setVirtualHost(properties.determineVirtualHost());
        return connectionFactory;
    }

    @Bean(name="mdcRabbitTemplate")
    public RabbitTemplate mdcRabbitTemplate(@Qualifier("mdcConnectionFactory") ConnectionFactory connectionFactory){
        RabbitTemplate rabbitTemplate = new RabbitTemplate(connectionFactory);
        return rabbitTemplate;
    }

    @Bean(name = "mdcMessageListenerContainer")
    public SimpleRabbitListenerContainerFactory mdcMessageListenerContainer(
            @Qualifier("mdcConnectionFactory") ConnectionFactory connectionFactory) {
        SimpleRabbitListenerContainerFactory factory = new SimpleRabbitListenerContainerFactory();
        factory.setConnectionFactory(connectionFactory);
        factory.setAcknowledgeMode(AcknowledgeMode.MANUAL);


        return factory;
    }

    @Bean(name="mdcAmqpAdmin")
    @Primary
    public RabbitAdmin mdcAmqpAdmin() {
        return new RabbitAdmin(mdcConnectionFactory());
    }

}
