package com.digiwin.athena.knowledgegraph.configuration;

import com.digiwin.app.service.DWServiceContext;
import com.digiwin.athena.kmservice.utils.TranslateUtil;
import com.digiwin.athena.knowledgegraph.filter.KgFilter;
import com.digiwin.athena.knowledgegraph.utils.AthenaUtils;
import com.digiwin.gateway.token.TokenService;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.Map;

/**
 * @program: codes
 * @description: 描述
 * @author: Tuo
 * @create: 2022-08-16 15:59
 **/
@Aspect
@Component
public class ModuleAspect {

    @Autowired
    TokenService tokenService;

    @Pointcut("execution(public * com.digiwin.athena.knowledgegraph.service.impl.*.*(..))")
    public void serviceImpl() {
    }
    @Pointcut("target(com.digiwin.athena.knowledgegraph.service.KgInnerService)")
    public void kgInnerService() {
    }

    @Around("kgInnerService()")
    public Object kgInnerServiceAround(ProceedingJoinPoint joinPoint) throws Throwable {
        if(null!= KgFilter.getLoginInfo()){
            try {
                Map<String, Object> profile = DWServiceContext.getContext().getProfile();
                String tenantId = (String) profile.getOrDefault("tenantId", "");
                //如果匿名接口 但被传入token  则依然解析token为tenantId
                if (tenantId.isEmpty() && !KgFilter.getLoginInfo().getToken().isEmpty()) {
                    tokenService.verifyIamToken(KgFilter.getLoginInfo().getToken());
                }
                KgFilter.getLoginInfo().setTenantId((String) DWServiceContext.getContext().getProfile().getOrDefault("tenantId", ""));
            }catch (Exception e){}
        }
        Object result = joinPoint.proceed();
        return result;
    }
    @Around("serviceImpl()")
    public Object serviceImplAround(ProceedingJoinPoint joinPoint) throws Throwable {

        Object result = joinPoint.proceed();
        if(null!= KgFilter.getLoginInfo()){
            try {
                Map<String, Object> profile = DWServiceContext.getContext().getProfile();
                String tenantId = (String) profile.getOrDefault("tenantId", "");
                KgFilter.getLoginInfo().setTenantId(tenantId);
            }catch (Exception e){}
        }

        try{
            TranslateUtil.dealLangRecusive(result, AthenaUtils.getCurrentLocale());
        }catch(Exception e){}

        return result;
    }


}
