package com.digiwin.athena.knowledgegraph.domain;

import com.digiwin.athena.kg.domain.CodedEntity;
import com.digiwin.athena.kg.activity.ActivityApprove;
import com.digiwin.athena.kg.activity.Language;
import com.digiwin.athena.kg.activity.Message;
import lombok.Data;
import org.neo4j.ogm.annotation.*;

import java.util.List;
import java.util.Map;

/**
 * @program: athena_backend
 * @description: 描述
 * @author: Tuo
 * @create: 2020-06-28 19:09
 **/
@Data
@NodeEntity
public class ActivityOld extends CodedEntity implements Comparable<ActivityOld>{
    private String name;


    private Integer emergency;
    private String sequence="1";
    //执行类型 参见ActivityExecuteTypeEnum: MANUAL AUTO
    private String executeType;
    //活动类型  CHECK检查 SOLVE异常排除 ADJUSTMENT REPORT  PROCESS MESSAGE
    private String category;
    // 参见ActivityPatternEnum:  NONE,BUSINESS,ADJUSTMENT,MECHANISM;
    private String pattern;

    //里程碑 为true 表示业务型 有细项指标
    private Boolean milestone;

    private String expectedDuration;



    private Boolean showFlow;

    private Boolean dispatchWF;//已过时 该属性被迁移至submitAction
    //活动是否支持多选操作
    private Boolean multipleSelect;
    //json 获取数据action
    private String getDataAction;
    //json 相关查询action  可能包含getDataAction
    private String relationQueries;
    //json 提交数据action
    private String submitActions;
    //json
    private String summaryFields;
    //json 保存过滤按钮
    private String filters;
    //json 操作相关
    private String operations;

    private String checkItems;

    //json 机制任务
    private String reason;

    private String groupFields;

    private String getTaskData;

    private String title;

    private String subTitle;

    private String description;

    private String subDescription;

    private String getFormulaAction;

    private String countItems;

    @Relationship(type = "TRANSLATION",direction = Relationship.OUTGOING)
    private List<Language> languages;

    //细项指标
    private List<String> factors;


//审核相关
    // 0:核决，1：群组
    private Integer approveType;
    //0串接 1并接，目前场景只有串接
    private Integer groupDispatchType;
    //审核任务关联的申请关卡
    private List<String> startApproveActivity;
    private String startApproveActivityName;
    //群组 审核关卡 保存在mongo
    @Transient
    private List<ActivityApprove> approves;
    //核决
    private String decisionRule;

 //消息定义部分 发送消息单独作为一个节点
    @Transient
    private List<Message> messages;

    // 对应设计器流程设定的表单信息
    private Map<String,Object> bindForm;
    //字段权限，从task表中获取
    private List<Object> fieldConfig;

    @Override
    public int compareTo(ActivityOld o) {
        return Integer.parseInt(this.getSequence()) - Integer.parseInt(o.getSequence());
    }
}
