package com.digiwin.athena.knowledgegraph.domain;

import com.digiwin.athena.knowledgegraph.data.Neo4jConstants;
import com.digiwin.athena.knowledgegraph.domain.common.LanguageEntity;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.neo4j.ogm.annotation.GeneratedValue;
import org.neo4j.ogm.annotation.Id;
import org.neo4j.ogm.annotation.NodeEntity;
import org.neo4j.ogm.annotation.Relationship;

import java.util.HashSet;
import java.util.List;
import java.util.Set;

@Data
@NoArgsConstructor
@NodeEntity(label = "IndicatorNode")
public class IndicatorNode extends LanguageEntity {


    /*@GeneratedValue
    private Long id;*/
    @Id
    private String indicatorId;
    //private String parentId;
    private String name;
    private String tendency;
    private Boolean featureSelection;
    private String unit;
    private String group;

    /*@Relationship(type = Neo4jConstants.CONSISTS_OF, direction = Relationship.INCOMING)
    private IndicatorNode parent;*/

    @Relationship(type = Neo4jConstants.CONSISTS_OF)
    private Set<IndicatorNode> consistsOf = new HashSet<>();

    public void addRelation(IndicatorNode sonNode) {
        consistsOf.add(sonNode);
    }

}
