package com.digiwin.athena.knowledgegraph.domain;

import com.digiwin.athena.domain.common.HierarchicalEntity;
import lombok.Data;
import org.springframework.data.mongodb.core.mapping.Document;

import java.util.Map;

@Data
@Document(collection = "mechanismSettings")
public class MechanismSettings extends HierarchicalEntity {
    private String appCode;
    private String version;
    private Map<String, Integer> sort;
    private Map<String, Integer> paradigmSort;

    @Override
    public String entityBizCode() {
        return appCode;
    }
}
