package com.digiwin.athena.knowledgegraph.domain.decisionmodel;

import com.digiwin.athena.domain.generic.MergeRule;
import com.digiwin.athena.domain.common.HierarchicalEntity;
import lombok.Data;
import org.springframework.data.mongodb.core.mapping.Document;


import java.util.List;
import java.util.Map;

@Data
@Document(collection="decisionModel")
public class DecisionModel extends HierarchicalEntity {

    private String id;
    private Boolean enabled;
    private Boolean banSwitch;
    private String code;
    private String name;
    private Boolean useDecisionScheme;
    private Target target;
    private List<Factor> factors;
    private List<Weight> weights;
    private Precondition precondition;

    private List<DecisionScheme> schemes;
    private List<ApiReferenceInfo> referenceInfo;
    private List<DecisionMakingScheme> decisionScheme;
    /**
     * 增加字段返回系统级决策方案
     */

    private List<DecisionMakingScheme> originDecisionScheme;
    /**
     * 当前模型是否启动AI辅助
     */
    private Boolean useAI;

    private String application;

    private String version;

    private Map<String, MergeRule> _mergeRule;

    @Override
    public String entityBizCode() {
        return code;
    }
}
