package com.digiwin.athena.knowledgegraph.domain.decisionmodel;

import com.digiwin.athena.domain.common.BaseObject;
import lombok.Data;
import org.neo4j.ogm.annotation.Transient;
import org.springframework.data.mongodb.core.mapping.Document;


import java.util.List;

@Data
@Document(collection="decisionScheme")
public class DecisionScheme extends BaseObject {


    private String id;
    private String code;
    private String tenantId;
    /*
    决策模型code
     */
    private String evlModelCode;
    @Transient
    private String name;
    private Boolean ifRecommend;
    private Boolean ifOrigin;
    private List<SchemeFactor> factors;
    private String version;
    private Boolean enableAIRecommend;

}
