package com.digiwin.athena.knowledgegraph.domain.digitalstaff;

import lombok.Data;

import java.util.List;

/**
 * <Description> <br>
 *
 * @author wang.xinyuan<br>
 * @version 1.0<br>
 * @taskId <br>
 * @CreateDate 2021/11/11 <br>
 * @see: com.digiwin.athena.knowledgegraph.domain.digitalstaff.DigitalStaffDto <br>
 */
@Data
public class DigitalStaffDto {
    /**
     * 数字员工编码
     */
    private String code;
    /**
     * 数字员工名称
     */
    private String name;
    /**
     * 数字员工类别
     */
    private String categoryName;
    /**
     * 数字员工类别编码
     */
    private String categoryCode;
    /**
     * 对应增强应用code
     */
    private String appCode;
    /**
     * 职级编码
     */
    private String gradeCode;
    /**
     * 职级名称
     */
    private String gradeName;
    /**
     * 职称名称，使用增强应用的名字
     */
    private String titleName;
    /**
     * 项目描述
     */
    private String projectDescribe;
    /**
     * 工作目标描述，对项目描述的更详细的描述
     */
    private String workTargetDescribe;
    /**
     * 职能编码
     */
    private String functionCode;
    /**
     * 职能名称
     */
    private String functionName;
    /**
     * 教育设定
     */
    private Boolean educateSetting;
    /**
     * 起始日期
     */
    private String startDate;
    /**
     * 终止日期
     */
    private String endDate;
    /**
     * 有效期
     */
    private String validPeriod;
    //
    /**
     * 已完成工作状态信息
     */
    private Integer finishJobNum;
    /**
     * 完成工作的拼接字符串
     */
    private String spliceStr;
    /**
     * 工作范围
     */
    private String jobList;
    /**
     * 今日已完成工作历史
     */
    private List<String> finishJobList;
    /**
     * 增强应用相关的应用code
     */
    private String relaAppCode;
    /**
     * 增强应用相关的应用名称
     */
    private String relaAppName;
}