package com.digiwin.athena.knowledgegraph.domain.mechanism;

import com.digiwin.athena.kg.domain.DomainEntity;
import lombok.Data;
import org.springframework.data.mongodb.core.mapping.Document;

import java.util.List;

/**
 * @program: athena_backend
 * @description: 描述
 * @author: Tuo
 * @create: 2020-07-24 19:02
 **/
@Data
@Document
public class MechanismFormula extends DomainEntity {

    /**
     * 主键
     */
    private String key;
    /**
     * 名称
     */
    private String name;
    /**
     * 公式名称
     */
    private String formulaName;
    /**
     * 任务id
     */
    private String taskId;
    /**
     * 公式变量
     */
    private List<FormulaItem> formulaVariables;
    /**
     * 0新发起 1已同意 2已拒绝 3审核通过 4审核不通过
     */
    private Integer status;
    /**
     * 备注
     */
    private String remark;
    /**
     * 对应action template 的id
     */
    private String actionId;


    public String entityBizCode(){
        return key;
    }


}
