package com.digiwin.athena.knowledgegraph.domain.targets;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class TBBTreeNodeFormatter {

    /*
    类型：Int备注： 1 数值   ,  2 百分比
     */
    private Integer type = 1;
    /*
    类型：Int备注：小数位数
     */
    private Integer decimalPlaces = 1;
    /*
    类型：Int备注： 单位 0  None , 1 Million , 2 Billion  , 3 K  , 4  M , 5  G
     */
    private Integer unit = 0;
    /*
    类型：bool备注：是否千分位
     */
    private Boolean useThousandth = true;
    /*
    类型：bool备注： 是否自定义单位
     */
    private Boolean isCustomizeUnit = false;
    /*
    类型：String备注：  自定义单位值
     */
    private String customUnit = "";

}
