package com.digiwin.athena.knowledgegraph.domain.targets;

import lombok.Data;
import org.springframework.data.mongodb.core.mapping.Document;

import javax.validation.Valid;
import java.util.List;
import java.util.Map;

@Data
@Document(collection = "indicatorForest")
public class TenantIndicatorForest {
    /**
     * 租户id
     */
    private String tenantId;

    /**
     * 版本号
     */
    private String version;

    /**
     * 租户指标树节点列表
     */
    @Valid
    private List<TenantIndicatorTreeNodeRelation> indicatorRelations;

    /**
     * 租户指标树节点的特征
     */
    private Map<String, Object> feature;

}
