package com.digiwin.athena.knowledgegraph.domain.triples;

import com.digiwin.athena.knowledgegraph.data.Neo4jConstants;
import lombok.Data;
import org.neo4j.ogm.annotation.GeneratedValue;
import org.neo4j.ogm.annotation.Id;
import org.neo4j.ogm.annotation.NodeEntity;
import org.neo4j.ogm.annotation.Relationship;

import java.util.List;

/**
 * @author tang jie cheng
 * @date 2022-12-12 14:40
 */
@Data
@NodeEntity(label = Neo4jConstants.AUTO_PROGRESSIVE_CONCLUSION)
public class Conclusion {
    @Id
    @GeneratedValue
    private Long id;

    private String name;

    private String code;

    @Relationship(type = Neo4jConstants.AUTO_PROGRESSIVE_VERSION)
    private List<Property> property;
}
