package com.digiwin.athena.knowledgegraph.dto;

import com.digiwin.athena.knowledgegraph.domain.common.LanguageEntity;
import lombok.Data;
import org.apache.commons.lang3.StringUtils;

import java.io.Serializable;
import java.util.List;

@Data
public class CardConfigDTO implements Serializable {

    private String aliasField;

    private Config config;

    @Data
    public static class Config implements Serializable {
        private Data filter;

        private Label label;

        private Data order;

        private Data group;

        private Column column;

        @lombok.Data
        public static class Data extends LanguageEntity implements Serializable {

            private String aliasName;

            private String dataType;

            private String defaultEffective;
            /**
             * 生效范围
             */
            private transient List<String> scope;

        }

        @lombok.Data
        public static class Label extends LanguageEntity implements Serializable {
            private Style style;
            private String defaultEffective;
            private String aliasName;

            @lombok.Data
            public static class Style implements Serializable {
                private String color;

                private String font;

            }
        }

        @lombok.Data
        public static class Column extends LanguageEntity implements Serializable{
            private String valueType;
            private String aliasName;
            private String defaultEffective;

        }
    }
}

