package com.digiwin.athena.knowledgegraph.dto;

import com.digiwin.athena.knowledgegraph.domain.common.LanguageEntity;
import lombok.Data;

import java.util.List;

@Data
public class TargetForAppNodeInfoDto extends LanguageEntity {

    //TODO 返回
    /*
    指标id,指标全局唯一,相同指标id的修改会影响到所有应用该id的树,非必填
     */
    private String id;
    /*
    期别
     */
    private String periodKey;
    /*
    nodeId,调用方提供
     */
    private String nodeId;
    /*
    指标名称
     */
    private String name;
    /*
    指标趋势0,1,2
     */
    private String tendency;
    /*
    趋势名称
     */
    private String tendencyName;
    /*
    指标周期:月
     */
    private String period;
    /*
    单位%
     */
    private String unit;
    /*
    保留小数位2
     */
    private String precision;
    /*
    指标描述
     */
    private String description;
    /*
    目标值
     */
    private String target;
    /*
    预警值
     */
    private String warningStage;
    /*
    当责者
     */
    private List<String> personInCharge;
    /*
    是否启用
     */
    private Boolean enabled;
    /*
    指标值
     */
    private String value;
    /*
    指标类型对应的code
     */
    private String code;
    /*
    指标类型topic,application,paradigm,business,usertrack
     */
    private String type;
    /*
    父节点nodeId,无法通过平台内置结构推断层次时使用
     */
    private String parentNodeId;

}
