package com.digiwin.athena.knowledgegraph.enums;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.google.common.collect.Lists;
import lombok.Getter;

import java.util.Arrays;
import java.util.List;

@Getter
@JsonFormat(shape = JsonFormat.Shape.OBJECT)
public enum WeekDaysEnum implements IOption<String> {
    Mon(1, Lists.newArrayList("一")),
    Tus(2, Lists.newArrayList("二")),
    Wen(3, Lists.newArrayList("三")),
    Thu(4, Lists.newArrayList("四")),
    Fri(5, Lists.newArrayList("五")),
    Sat(6, Lists.newArrayList("六")),
    sun(7, Lists.newArrayList("日"));

    private final int code;
    private final List<String> desc;

    WeekDaysEnum(int code, List<String> desc) {
        this.code = code;
        this.desc = desc;
    }

    public static WeekDaysEnum byDesc(String value) {
        return Arrays.stream(values()).filter(v -> v.desc.contains(value)).findFirst().orElse(null);
    }

    @Override
    public String getValue() {
        return name();
    }
}