package com.digiwin.athena.knowledgegraph.mechanism;

import com.alibaba.fastjson.JSON;

import com.digiwin.athena.mechanism.common.MechanismVariable;
import com.digiwin.athena.mechanism.pre.MechanismPart;
import com.digiwin.athena.mechanism.pre.parts.ActionStartTaskPart;
import com.digiwin.athena.mechanism.widgets.ActivityWidget;
import com.digiwin.athena.mechanism.widgets.Widget;
import com.digiwin.athena.mechanism.widgets.activity.TaskInitiateActivityWidget;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.UUID;

/**
 * @program: codes
 * @description: 描述
 * @author: Tuo
 * @create: 2023-03-09 10:20
 **/

public abstract class AbstractMechanismPartParser implements MechanismPartParser{



    @Autowired
    ObjectMapper objectMapper;

    public <T> T convert(Object obj,Class<T> c){
        T t = objectMapper.convertValue(obj,c);
        return t;
    }

    public String uid(){
        return UUID.randomUUID().toString().replaceAll("-","");
    }

    public void generateCypherSimple(MechanismParseContext context, Widget widget, String parentNode) {
        if(null!=widget){
            String nodeId = "widget_"+ UUID.randomUUID().toString().replaceAll("-","");
            context.getCypherSb().append("create(").append(nodeId).append(":MechanismWidget:MechanismComponent{")
                    .append("code").append(":'").append(widget.getCode()).append("',")
                    .append("name").append(":'").append(widget.getName()==null?"Widget_"+widget.getType():widget.getName()).append("',")
                    .append("type").append(":'").append(widget.getType()).append("',")
                    .append("pluginId").append(":'").append(context.getPluginId()).append("'")
                    .append("})\r\n")
            ;
            context.getCypherSb().append("create(").append(parentNode).append(")-[:WIDGET]->(").append(nodeId).append(")\r\n");
        }
    }

    public void generateCypherActivity(MechanismParseContext context, ActivityWidget widget, String parentNode) {
        if(null!=widget){
            String nodeId = "widget_"+ UUID.randomUUID().toString().replaceAll("-","");
            context.getCypherSb().append("create(").append(nodeId).append(":MechanismWidget:MechanismComponent{")
                    .append("code").append(":'").append(widget.getCode()).append("',")
                    .append("name").append(":'").append(widget.getName()==null?"Widget_"+widget.getType():widget.getName()).append("',")
                    .append("type").append(":'").append(widget.getType()).append("',")
                    .append("config").append(":'").append(JSON.toJSONString(widget.getConfig())).append("',")
                    .append("pluginId").append(":'").append(context.getPluginId()).append("'")
                    .append("})\r\n")
            ;
            context.getCypherSb().append("create(").append(parentNode).append(")-[:WIDGET]->(").append(nodeId).append(")\r\n");
        }
    }




}
