package com.digiwin.athena.knowledgegraph.mechanism;

import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.athena.domain.component.ComponentTypeEnum;
import com.digiwin.athena.mechanism.bo.AssignAbilityBo;
import com.digiwin.athena.mechanism.bo.ControlAbilityBO;
import com.digiwin.athena.mechanism.common.MechanismAbility;
import com.digiwin.athena.mechanism.pre.MechanismCapacity;
import org.springframework.stereotype.Service;

/**
 * @author tang jie cheng
 * @date 2023-03-27 13:13
 */
@Service
public class MechanismCapacityAssignParser extends AbstractMechanismCapacityParser{

    @Override
    public boolean accept(MechanismCapacity capacity) {
        return ComponentTypeEnum.MechanismAssign.name().equals(capacity.getType());
    }

    @Override
    public void parse(MechanismParseContext context, MechanismCapacity capacity) throws DWBusinessException {

        MechanismAbility logic = new AssignAbilityBo();
        context.setLogic(logic);



        //指派的任务
        super.parsePart(context, capacity.getSource());
        //指派人员规则
        super.parsePart(context, capacity.getAction());

    }

    @Override
    public void generateCypher(MechanismParseContext context, MechanismCapacity capacity, String parentNode) throws DWBusinessException {

//        super.generateCypherPart(context, capacity.getAssignSource(), parentNode);
//        super.generateCypherPart(context, capacity.getAssignRule(), parentNode);

        String sourceNode =super.doGenerateCypherPart(context, capacity.getSource());
        String actionNode =super.doGenerateCypherPart(context, capacity.getAction());
        super.doGenerateCypherPartRelation(context, sourceNode, actionNode,"ACTION");
    }
}
