package com.digiwin.athena.knowledgegraph.mechanism;

import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.athena.domain.component.ComponentTypeEnum;
import com.digiwin.athena.mechanism.bo.ControlAbilityBO;
import com.digiwin.athena.mechanism.bo.DecisionAbilityBO;
import com.digiwin.athena.mechanism.common.DecisionSubType;
import com.digiwin.athena.mechanism.common.MechanismAbility;
import com.digiwin.athena.mechanism.pre.MechanismCapacity;
import org.springframework.stereotype.Service;

/**
 * @program: codes
 * @description: 描述
 * @author: Tuo
 * @create: 2023-03-29 16:17
 **/
@Service
public class MechanismCapacityDecisionParser extends AbstractMechanismCapacityParser{
    @Override
    public boolean accept(MechanismCapacity capacity) {
        return ComponentTypeEnum.MechanismDecision.name().equals(capacity.getType());
    }

    @Override
    public void parse(MechanismParseContext context, MechanismCapacity capacity) throws DWBusinessException {
        DecisionAbilityBO logic = new DecisionAbilityBO();

        context.setLogic(logic);

        super.parsePart(context, capacity.getSource());

        super.parsePart(context, capacity.getAction());
    }

    @Override
    public void generateCypher(MechanismParseContext context, MechanismCapacity capacity, String parentNode) throws DWBusinessException {

        String sourceNode =super.doGenerateCypherPart(context, capacity.getSource());
        String actionNode =super.doGenerateCypherPart(context, capacity.getAction());
        super.doGenerateCypherPartRelation(context, sourceNode, actionNode,"ACTION");

    }
}
