package com.digiwin.athena.knowledgegraph.mechanism.partparsers;

import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.athena.knowledgegraph.mechanism.AbstractMechanismPartParser;
import com.digiwin.athena.knowledgegraph.mechanism.MechanismParseContext;
import com.digiwin.athena.mechanism.bo.ControlAbilityBO;
import com.digiwin.athena.mechanism.bo.DriveAbilityBo;
import com.digiwin.athena.mechanism.common.MechanismAbility;
import com.digiwin.athena.mechanism.pre.MechanismCapacityCodes;
import com.digiwin.athena.mechanism.pre.MechanismPart;
import com.digiwin.athena.mechanism.pre.parts.ActionWarnMessagePart;
import com.digiwin.athena.mechanism.widgets.ActivityWidget;
import com.digiwin.athena.mechanism.widgets.CheckWidget;
import com.digiwin.athena.mechanism.widgets.activity.IMActivityWidget;
import com.digiwin.athena.mechanism.widgets.choose.SingleStrategyWidget;
import com.digiwin.athena.mechanism.widgets.plan.ActivityPlanWidget;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;

/**
 * @program: codes
 * @description: 描述
 * @author: Tuo
 * @create: 2023-03-09 20:03
 **/
@Service
public class ActionWarnMessageParser extends AbstractMechanismPartParser {
    @Override
    public boolean accept(MechanismPart part) {
        return MechanismCapacityCodes.actionWarnMessage.equals(part.getCode());
    }

    @Override
    public void parse(MechanismParseContext context, MechanismPart part) throws DWBusinessException {
        ActionWarnMessagePart messagePart = (ActionWarnMessagePart) part;
        List<ActivityWidget> activityWidget = new ArrayList<>();
        if("im".equalsIgnoreCase(messagePart.getType())){
            List<IMActivityWidget> imWidgets = messagePart.getImWidget();
            if (CollectionUtils.isNotEmpty(imWidgets)) {
                for (IMActivityWidget imWidget : imWidgets) {
                    // 当责者
                    if ("personInCharge".equalsIgnoreCase(imWidget.getPerformerType())) {
                        imWidget.setUserId((String) context.getNamedParams().get(MechanismParseContext.Names.im_userId));
                        imWidget.setPerformerValue((String) context.getNamedParams().get(MechanismParseContext.Names.im_userId));
                    }
                    // 执行人
                    else if ("performerId".equalsIgnoreCase(imWidget.getPerformerType())) {
                        imWidget.setUserId("$(list)[*].performerId");
                        imWidget.setPerformerValue("$(performerId)");
                    }
                    // 人员
                    else if ("user".equalsIgnoreCase(imWidget.getPerformerType())) {

                    }
                    // 职能
                    else if ("duty".equalsIgnoreCase(imWidget.getPerformerType())) {

                    }
                    // 部门主管
                    else if ("deptDirector".equalsIgnoreCase(imWidget.getPerformerType())) {

                    }
                    // 部门人员
                    else if ("deptUser".equalsIgnoreCase(imWidget.getPerformerType())) {


                    }
                    // 机制参数
                    else if ("MECHANISM_PARAMETER".equalsIgnoreCase(imWidget.getPerformerType())) {


                    } else if ("businessField".equals(imWidget.getPerformerType())) {
                        imWidget.setUserId((String) context.getNamedParams().get(MechanismParseContext.Names.im_userId));
                    }
                    // 下个任务的执行人
                    else if ("taskExecutor".equalsIgnoreCase(imWidget.getPerformerType())) {
                        imWidget.setPerformerValue((String) context.getNamedParams().get(MechanismParseContext.Names.im_performerId));
                    } else {
                        continue;
                    }
                    activityWidget.add(imWidget);
                }
            }

        }else if("email".equalsIgnoreCase(messagePart.getType())){

        }else{
            throw new DWBusinessException("type not support:"+part.getType());
        }


        SingleStrategyWidget choose = new SingleStrategyWidget();
        ActivityPlanWidget activityPlanWidget = new ActivityPlanWidget();
        activityPlanWidget.setActivityWidget(activityWidget);
        activityPlanWidget.setType("activityPlan");
        choose.setPositiveTarget(activityPlanWidget);
        choose.setType("singleChoose");
        Object checkCondition = context.getNamedParams().get(MechanismParseContext.Names.checkCondition);
        if(null!=checkCondition){
            choose.setCondition((CheckWidget) checkCondition);
        }
        MechanismAbility logic = context.getLogic();
        if(logic instanceof DriveAbilityBo){
            DriveAbilityBo bo = (DriveAbilityBo) logic;
            bo.setChoose(choose);
        }else if(logic instanceof ControlAbilityBO){
            ControlAbilityBO bo = (ControlAbilityBO) logic;
            bo.setChoose(choose);
        }


    }

    @Override
    public void generateCypher(MechanismParseContext context, MechanismPart part, String parentNode) {
        ActionWarnMessagePart messagePart = (ActionWarnMessagePart) part;
        if("im".equalsIgnoreCase(messagePart.getType())){
            List<IMActivityWidget> imWidgets = messagePart.getImWidget();
            if (CollectionUtils.isNotEmpty(imWidgets)) {
                for (IMActivityWidget imWidget : imWidgets) {
                    String nodeId = "widget_"+ UUID.randomUUID().toString().replaceAll("-","");
                    context.getCypherSb().append("create(").append(nodeId).append(":MechanismWidget:MechanismComponent{")
                            .append("code").append(":'").append(imWidget.getCode()).append("',")
                            .append("name").append(":'").append(imWidget.getName()==null?"Widget_"+imWidget.getType():imWidget.getName()).append("',")
                            .append("type").append(":'").append(imWidget.getType()).append("',")
                            .append("title").append(":'").append(imWidget.getTitle()).append("',")
                            .append("message").append(":'").append(imWidget.getMessage()).append("',")
                            .append("userId").append(":'").append(imWidget.getUserId()).append("',")
                            .append("pluginId").append(":'").append(context.getPluginId()).append("'")
                            .append("})\r\n")
                    ;
                    context.getCypherSb().append("create(").append(parentNode).append(")-[:WIDGET]->(").append(nodeId).append(")\r\n");
                }
            }
        }else if("email".equalsIgnoreCase(messagePart.getType())){

        }
    }
}
