package com.digiwin.athena.knowledgegraph.mechanism.partparsers;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.athena.domain.definition.Identity;
import com.digiwin.athena.domain.definition.UserDefinition;
import com.digiwin.athena.knowledgegraph.mechanism.AbstractMechanismPartParser;
import com.digiwin.athena.knowledgegraph.mechanism.MechanismParseContext;
import com.digiwin.athena.knowledgegraph.service.impl.TaskService;
import com.digiwin.athena.mechanism.bo.AssignAbilityBo;
import com.digiwin.athena.mechanism.common.MechanismAbility;
import com.digiwin.athena.mechanism.pre.MechanismCapacity;
import com.digiwin.athena.mechanism.pre.MechanismCapacityCodes;
import com.digiwin.athena.mechanism.pre.MechanismPart;
import com.digiwin.athena.mechanism.pre.parts.AdvancedAssignRulePart;
import com.digiwin.athena.mechanism.pre.parts.AssignRulePart;
import com.digiwin.athena.mechanism.pre.parts.SourceAssignPart;
import com.digiwin.athena.mechanism.vo.FieldVO;
import com.digiwin.athena.mechanism.vo.SourceFieldVO;
import com.digiwin.athena.mechanism.vo.TargetFieldVO;
import com.digiwin.athena.mechanism.widgets.ActivityWidget;
import com.digiwin.athena.mechanism.widgets.activity.EspActivityWidget;
import com.digiwin.athena.mechanism.widgets.assign.AdvancedUserDefinitionWidget;
import io.seata.common.util.StringUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.*;

@Slf4j
@Service
public class AdvancedAssignDefinitionParser extends AbstractMechanismPartParser {

    public static final String MECHANISM_TASK_DATA = "_mechanism_taskData_";
    public static final String MECHANISM_BASIC_DATA = "_mechanism_basicData_";
    public static final String MECHANISM_EXECUTOR = "_executorByMechanism_";
    public static final String TYPE_TASK = "task";
    public static final String TYPE_BASIC_DATA = "basicData";

    @Autowired
    private TaskService taskService;

    @Override
    public boolean accept(MechanismPart part) {
        return MechanismCapacityCodes.advancedAssignDefinition.equals(part.getCode());
    }

    @Override
    public void parse(MechanismParseContext context, MechanismPart part) throws DWBusinessException {
        AdvancedAssignRulePart assignRulePart = (AdvancedAssignRulePart) part;
        String type = assignRulePart.getType();

        MechanismAbility logic = context.getLogic();
        AssignAbilityBo bo = (AssignAbilityBo) logic;
//        //特定人员 simple , 高级规则 advanced
//        if ("simple".equalsIgnoreCase(type)) {
//            bo.setAssignTo(assignRulePart.getUserDefinitionWidget());
//        } else if ("advanced".equalsIgnoreCase(type)) {
            String capacityCode = context.getCapacity().getCode();
            AdvancedUserDefinitionWidget advancedUserDefinitionWidget = assignRulePart.getAdvancedUserDefinitionWidget();
            bo.setAdvancedUserDefinitionWidget(advancedUserDefinitionWidget);

            //PerformerValue 是个动态的值，在activity中会构造对应的值放入DTD全局变量
            bo.setAssignTo(this.generateUserDefinition(capacityCode));
//        }
    }

    @Override
    public void generateCypher(MechanismParseContext context, MechanismPart part, String parentNode) {


    }

    private UserDefinition generateUserDefinition(String capacityCode){
        UserDefinition userDefinition = new UserDefinition();
        userDefinition.setChoosePolicy("all");
        userDefinition.setProcessType("signOr");

        Identity identity = new Identity();
        identity.setPerformerType("user");
        // 类似"$(personInCharge)"
        identity.setPerformerValue("$("+ MECHANISM_EXECUTOR + capacityCode + ")");
        userDefinition.setIdentities(Arrays.asList(identity));

        return userDefinition;
    }

    // TODO 由于机制封装工具阶段不包含真是租户信息，所以该逻辑现在在二次编译时期调用
    public List<ActivityWidget> generatePreActivities(AdvancedUserDefinitionWidget advancedUserDefinitionWidget, MechanismCapacity mechanismCapacity)  throws DWBusinessException{
        List<ActivityWidget> activityWidgets = new ArrayList<>();
        String capacityCode = mechanismCapacity.getCode();
        SourceFieldVO sourceField = advancedUserDefinitionWidget.getSourceField();
        //生成获取task数据espActivity
        MechanismPart assignSource = mechanismCapacity.getSource();
        SourceAssignPart sourcePart = (SourceAssignPart) assignSource;
        String taskCode = sourcePart.getTargetSource().getTarget();
        EspActivityWidget taskEspActivityWidget = this.generateEspActivityWidget(sourceField.getTaskField(), taskCode , TYPE_TASK, capacityCode);
        activityWidgets.add(taskEspActivityWidget);
        //生成获取基础资料数据espActivity
        EspActivityWidget basicDataEspActivityWidget = this.generateEspActivityWidget(sourceField.getTaskField(), sourceField.getBasicDataCode() , TYPE_BASIC_DATA, capacityCode);
        activityWidgets.add(basicDataEspActivityWidget);
        //生成根据规则获取对应执行者的script类型的Activity
        ActivityWidget activityWidget = this.generateScriptActivityWidget(advancedUserDefinitionWidget, capacityCode);
        activityWidgets.add(activityWidget);

        return activityWidgets;
    }

    private ActivityWidget generateScriptActivityWidget(AdvancedUserDefinitionWidget advancedUserDefinitionWidget, String capacityCode)  throws DWBusinessException{
        ActivityWidget activityWidget = new ActivityWidget();
        activityWidget.setCode(UUID.randomUUID().toString());
        activityWidget.setType("script");

        SourceFieldVO sourceField = advancedUserDefinitionWidget.getSourceField();
        TargetFieldVO targetField = advancedUserDefinitionWidget.getTargetField();

        String taskDataVariableKey = MECHANISM_TASK_DATA +capacityCode;
        String basicDataVariableKey = MECHANISM_BASIC_DATA +capacityCode;

        StringBuilder response = new StringBuilder();
        response.append("var taskData = $("+ taskDataVariableKey + ");\n")
                .append("var basicData = $("+ basicDataVariableKey + ");\n")
                .append("var sourceTaskFieldVal = taskData[0]." + sourceField.getTaskField().getData_name() + ";\n")
                .append("var executorByMechanism; \n")
                .append("for(var i = 0; i < basicData.length; i++) {\n")
                .append(" var sourceBasicFieldVal = basicData[i]." + sourceField.getBasicDataField().getData_name() + ";\n")
                .append(" if(sourceBasicFieldVal === sourceTaskFieldVal){\n")
                .append(" executorByMechanism = basicData[i]." + targetField.getBasicDataField().getData_name() + ";\n")
                .append(" break; \n")
                .append(" } \n")
                .append("} \n")
                .append("return {\n")
                .append("'success': true,\n")
                .append("'processVariable': {\n")
                .append("'").append(MECHANISM_EXECUTOR + capacityCode).append("': executorByMechanism \n")
                .append(" },\n")
                .append("'errorMessage': '' \n")
                .append("};");




        Map<String, Object> config = new HashMap<>();
        config.put("executionMode", "script");
        Map<String, Object> scriptModeMap = new HashMap<>();
        scriptModeMap.put("responseScript", response.toString());


        config.put("scriptMode", scriptModeMap);

        activityWidget.setConfig(config);
        return activityWidget;
    }

    private EspActivityWidget generateEspActivityWidget(FieldVO fieldVO, String code, String type, String capacityCode)  throws DWBusinessException{
        EspActivityWidget espActivityWidget = new EspActivityWidget();
        espActivityWidget.setCode(UUID.randomUUID().toString());
        espActivityWidget.setType("esp");


        Map<String, Object> config = null;
        try {
            config = this.generateConfig(fieldVO, code, type, capacityCode);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            throw new DWBusinessException(e.getMessage());
        }
        espActivityWidget.setConfig(config);

        return espActivityWidget;
    }


    private Map<String, Object> generateConfig(FieldVO fieldVO, String code, String type, String capacityCode) throws Exception {
        Object activityDefinition = null;
        if (TYPE_TASK.equalsIgnoreCase(type)) {
            activityDefinition = this.taskService.getActivityDefinition(code, "task-detail");
        } else {
            activityDefinition = this.taskService.getActivityDefinition(code, "basic-data");
        }

        if (activityDefinition == null) {
            throw new DWBusinessException("not found " + type + " Definition ,code:" + code);
        }


        JSONObject jsonObject = JSON.parseObject(JSON.toJSONString(activityDefinition));
        JSONObject dataSources = jsonObject.getJSONObject("dataSources");
        JSONObject pages = jsonObject.getJSONObject("pages");
        JSONArray dataStates = pages.getJSONArray("dataStates");
        String schema = null;
        if(dataStates != null){
            JSONObject submitType = dataStates.getJSONObject(0).getJSONObject("submitType");
            schema = submitType == null ? null : submitType.getString("schema");
        }

        JSONObject dataSourceJson = null;
        if (schema != null) {
            dataSourceJson = dataSources.getJSONObject(schema);
        }

        if (dataSourceJson == null) {
            schema = String.valueOf(dataSources.keySet().toArray()[0]);
            dataSourceJson = dataSources.getJSONObject(schema);
        }

        String serviceName = dataSourceJson.getString("serviceName");
        JSONArray actionParams = dataSourceJson.getJSONArray("actionParams");
        StringBuilder requestParam = new StringBuilder();
        StringBuilder variableParam = new StringBuilder(); //'$(eoc_company_id)'
        if (CollectionUtils.isNotEmpty(actionParams)) {
            for (int i = 0; i < actionParams.size(); i++) {
                JSONObject jsonObject1 = actionParams.getJSONObject(i);
                String type1 = jsonObject1.getString("type");
                String name = jsonObject1.getString("name");
                String typeConverter = jsonObject1.getString("typeConverter");
                Object value = jsonObject1.get("value");
                if ("PROCESS_VARIABLE".equals(type1)) {
                    requestParam.append("'").append(name).append("':").append(value).append(",\n");
                    variableParam.append("var ").append(value).append(" = $(").append(value).append(");\n");
                } else {
                    if (StringUtils.isEmpty(typeConverter)) { //没有typeConverter 默认值为string
                        requestParam.append("'").append(name).append("':").append("'").append(value).append("',\n");
                    } else {
                        requestParam.append("'").append(name).append("':").append(value).append(",\n");
                    }
                }
            }
        }

        StringBuilder request = new StringBuilder();
        request.append(variableParam.toString()).append("return {\n std_data: {\n parameter: {\n")
                .append(requestParam.toString())
                .append("\n} \n} \n};");


        StringBuilder response = new StringBuilder();
        response.append("var response = $(response);\n")
                .append("var tSuccess = true;\n")
                .append("var tErrorMessage = '';\n")
                .append("if (Object.keys(response).length===0){tErrorMessage='Success';var ").append(schema).append("=''}\n")
                .append("else if (response['std_data']['execution']['code'] == '0') { \n")
                .append("tErrorMessage = 'Success';\n")
                .append("var ").append(schema).append("= response['std_data']['parameter']['").append(schema).append("'];\n")
                .append("} else {\n")
                .append("tSuccess = false;\n")
                .append("tErrorMessage = response['std_data']['execution']['description'];}\n")
                .append("return {\n")
                .append("'success': tSuccess,\n")
                .append("'processVariable': {\n")
                .append("'").append(this.getProcessVariableKey(type, capacityCode)).append("': ").append(schema).append("\n")
                .append(" },\n")
                .append("'errorMessage': tErrorMessage \n")
                .append("};");


        Map<String, Object> config = new HashMap<>();
        config.put("serviceName", serviceName);
        config.put("product", null);
        config.put("executionMode", "script");
        config.put("async", "false");

        Map<String, Object> headerMap = new HashMap<>();
        headerMap.put("security-token", "$(_ActLatelySecurityToken)");
        config.put("headers", headerMap);

        Map<String, Object> scriptModeMap = new HashMap<>();
        scriptModeMap.put("responseScript", response.toString());
        scriptModeMap.put("requestScript", request.toString());

        config.put("scriptMode", scriptModeMap);

        return config;
    }

    private String getProcessVariableKey(String type, String capacityCode){
         if(TYPE_TASK.equals(type)){
             return MECHANISM_TASK_DATA + capacityCode;
         }else{
             return MECHANISM_BASIC_DATA + capacityCode;
         }
    }

    public static void main(String[] args) {
        StringBuilder requestParam = new StringBuilder();
        StringBuilder variableParam = new StringBuilder(); //'$(eoc_company_id)'

        StringBuilder request = new StringBuilder();
        request.append(variableParam.toString()).append("return {\n std_data: {\n parameter: {\n")
                .append(requestParam.toString())
                .append("\n}, \n}, \n};");

        System.out.println(request.toString());
        System.out.println("============");

        String schema = "task_info";

        StringBuilder response = new StringBuilder();
        response.append("var response = $(response);\n")
                .append("var tSuccess = true;\n")
                .append("var tErrorMessage = '';\n")
                .append("if (response['std_data']['execution']['code'] == '0') { \n")
                .append("tErrorMessage = 'Success';\n")
                .append("var ").append(schema).append("= response['std_data']['parameter']['").append(schema).append("'];\n")
                .append("} else {\n")
                .append("tSuccess = false;\n")
                .append("tErrorMessage = response['std_data']['execution']['description'];\n")
                .append("return {\n")
                .append("'success': tSuccess,\n")
                .append("'processVariable': {\n")
                .append("'").append(MECHANISM_TASK_DATA).append("': ").append(schema).append("\n")
                .append(" },\n")
                .append("'errorMessage': tErrorMessage \n")
                .append("};");


        System.out.println(response.toString());
        System.out.println("============");

        String capacityCode = "capacityCode";
        String taskDataVariableKey = MECHANISM_TASK_DATA +capacityCode;
        String basicDataVariableKey = MECHANISM_BASIC_DATA +capacityCode;

        SourceFieldVO sourceField = new SourceFieldVO();
        FieldVO fieldVO = new FieldVO();
        fieldVO.setData_name("errorType");
        sourceField.setTaskField(fieldVO);
        sourceField.setBasicDataField(fieldVO);

        SourceFieldVO targetField = new SourceFieldVO();
        FieldVO fieldVO2 = new FieldVO();
        fieldVO2.setData_name("errorExecutor");
        targetField.setBasicDataField(fieldVO2);

        StringBuilder response2 = new StringBuilder();
        response2.append("var taskData = $("+ taskDataVariableKey + ");\n")
                .append("var basicData = $("+ basicDataVariableKey + ");\n")
                .append("var sourceTaskFieldVal = taskData[0]." + sourceField.getTaskField().getData_name() + ";\n")
                .append("var executorByMechanism; \n")
                .append("for(var i = 0; i < basicData.length; i++) {\n")
                .append(" var sourceBasicFieldVal = basicData[i]." + sourceField.getBasicDataField().getData_name() + ";\n")
                .append(" if(sourceBasicFieldVal === sourceTaskFieldVal){\n")
                .append(" executorByMechanism = basicData[i]." + targetField.getBasicDataField().getData_name() + ";\n")
                .append(" } \n")
                .append("} \n")
                .append("return {\n")
                .append("'success': true,\n")
                .append("'processVariable': {\n")
                .append("'").append(MECHANISM_EXECUTOR + capacityCode).append("': executorByMechanism \n")
                .append(" },\n")
                .append("'errorMessage': '' \n")
                .append("};");

        System.out.println(response2.toString());

    }
}
