package com.digiwin.athena.knowledgegraph.mechanism.partparsers;

import com.alibaba.fastjson.JSON;
import com.digiwin.athena.knowledgegraph.mechanism.AbstractMechanismPartParser;
import com.digiwin.athena.knowledgegraph.mechanism.MechanismParseContext;
import com.digiwin.athena.mechanism.bo.LimitAbilityBo;
import com.digiwin.athena.mechanism.common.MechanismEnum;
import com.digiwin.athena.mechanism.common.MechanismPlanType;
import com.digiwin.athena.mechanism.common.MechanismVariable;
import com.digiwin.athena.mechanism.pre.MechanismCapacityCodes;
import com.digiwin.athena.mechanism.pre.MechanismPart;
import com.digiwin.athena.mechanism.pre.parts.LimitTaskActionPart;
import com.digiwin.athena.mechanism.widgets.action.Reminder;
import com.digiwin.athena.mechanism.widgets.choose.SingleStrategyWidget;
import com.digiwin.athena.mechanism.widgets.plan.ReminderPlan;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 限制能力  提示消息
 *
 * @author tang jie cheng
 * @date 2023-03-27 13:25
 */
@Service
@Slf4j
public class ReminderParser extends AbstractMechanismPartParser {

    @Override
    public boolean accept(MechanismPart part) {
        return MechanismCapacityCodes.reminder.equals(part.getCode());
    }

    @Override
    public void parse(MechanismParseContext context, MechanismPart part) {
        LimitTaskActionPart limitTaskActionPart = (LimitTaskActionPart) part;
        Reminder reminder = limitTaskActionPart.getReminder();
        Object message = reminder.getMessage();
        List<MechanismVariable> variables = reminder.getVariables();
        LimitAbilityBo logic = (LimitAbilityBo) context.getLogic();
        for (SingleStrategyWidget strategy : logic.getStrategies()) {
            strategy.setCode(MechanismPlanType.reminderPlan.name());
            // 设置hook类型为赋值形式
            strategy.setActionHookType(MechanismEnum.ComponentType.ASSIGNMENT.getCode());
            ReminderPlan positiveTarget = JSON.parseObject(JSON.toJSONString(strategy.getPositiveTarget()),
                    ReminderPlan.class);
            positiveTarget.setType(MechanismPlanType.reminderPlan.name());
            positiveTarget.setActionType(MechanismEnum.LimitActionType.REMINDER.getCode());
            positiveTarget.setMessage(message);
            positiveTarget.setMessageType(reminder.getMessageType());
            positiveTarget.setLang(reminder.getLang());
            positiveTarget.setVariables(variables);
            strategy.setPositiveTarget(positiveTarget);
        }
        limitTaskActionPart.setStrategies(logic.getStrategies());
    }

    @Override
    public void generateCypher(MechanismParseContext context, MechanismPart part, String parentNode) {
        LimitTaskActionPart limitTaskActionPart = (LimitTaskActionPart) part;
        List<SingleStrategyWidget> strategies = limitTaskActionPart.getStrategies();
        for (SingleStrategyWidget strategy : strategies) {
            super.generateCypherSimple(context, strategy, parentNode);
        }
    }
}
