package com.digiwin.athena.knowledgegraph.mechanism.partparsers;

import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.athena.knowledgegraph.mechanism.AbstractMechanismPartParser;
import com.digiwin.athena.knowledgegraph.mechanism.MechanismParseContext;
import com.digiwin.athena.mechanism.pre.MechanismCapacityCodes;
import com.digiwin.athena.mechanism.pre.MechanismPart;
import com.digiwin.athena.mechanism.pre.parts.SourceAssignPart;
import com.digiwin.athena.mechanism.widgets.SourceWidget;
import org.springframework.stereotype.Service;


@Service
public class SourceAssignParser extends AbstractMechanismPartParser {
    @Override
    public boolean accept(MechanismPart part) {
        return MechanismCapacityCodes.sourceAssign.equals(part.getCode());
    }

    @Override
    public void parse(MechanismParseContext context, MechanismPart part) throws DWBusinessException {
        SourceAssignPart sourcePart = (SourceAssignPart) part;
        SourceWidget targetSource = sourcePart.getTargetSource();
        if(null!=context.getLogic()){
            context.getLogic().setCheckSource(targetSource);
        }

    }

    @Override
    public void generateCypher(MechanismParseContext context, MechanismPart part, String parentNode) {
        SourceAssignPart sourcePart = (SourceAssignPart) part;
        SourceWidget targetSource = sourcePart.getTargetSource();
        super.generateCypherSimple(context,targetSource,parentNode);

    }
}
