package com.digiwin.athena.knowledgegraph.mq;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.kmservice.neo4j.Neo4j1Config;
import com.digiwin.athena.kmservice.neo4j.Neo4j2Config;
import com.digiwin.athena.dto.ApiDataFieldMetadataDTO;
import com.digiwin.athena.knowledgegraph.constant.ComponentConstants;
import com.digiwin.athena.knowledgegraph.domain.tenant.TenantInitRouterKey;
import com.digiwin.athena.repository.neo4j.ActionRepository;
import com.digiwin.athena.knowledgegraph.service.KgService;
import com.digiwin.athena.knowledgegraph.service.RedisLock;
import com.rabbitmq.client.Channel;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.neo4j.ogm.session.Session;
import org.neo4j.ogm.session.SessionFactory;
import org.neo4j.ogm.transaction.Transaction;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.nio.charset.StandardCharsets;
import java.util.*;


@Component
@Slf4j
@ConditionalOnProperty("rabbitMQEnabled")
public class MQListenerService {

    // 分布式锁key增加redis规范appId前缀
    public static final String kgMdcMessageListenerLockName = ComponentConstants.REDIS_KNOWLEDGE_GRAPH + ":mdc:messageListenerLockName_";

    @Autowired
    SessionFactory sessionFactory;

    @Autowired(required=false)
    @Qualifier(Neo4j1Config.SESSION_FACTORY)
    SessionFactory sessionFactoryDomain1;

    @Autowired(required=false)
    @Qualifier(Neo4j2Config.SESSION_FACTORY)
    SessionFactory sessionFactoryDomain2;

    @Autowired
    ActionRepository actionRepository;

    @Autowired
    RedisLock redisLock;

    @Autowired
    KgService kgService;

    @Autowired
    @Qualifier("knowledgegraphSystem")
    MongoTemplate mongoTemplate;

    private static final String SERVICE_NAME = "Action/AddMdcApiMetadataToNeo4j";
    //    @RabbitListener(bindings = @QueueBinding(
//            value = @Queue(value = "mdc_api_metadata_to_km",
//                    durable = "true"),
//            exchange = @Exchange(value = "mdc.topic"),
//            key = "mdc.api.metadata"
//    ),  containerFactory = "mdcContainerFactory")
    @RabbitListener(containerFactory = "mdcMessageListenerContainer", queues = "mdc_api_metadata_to_km")
    public void mdcMetadataListener(Message message, Channel channel) throws Exception {
        String messageStr = new String(message.getBody(), StandardCharsets.UTF_8);
        String kgMdcMessageListenerContainerLock = null;
        String lockName = null;
        try {
            log.info("receiveMdcApiMetadata:{}", messageStr);
            /*messageStr = messageStr.replaceAll("[\\r\\n]+", "")
                .replaceAll("\\n+", "")
                .replaceAll("\\\\r|\\\\n", "")
                .replaceAll("\\\\b", "")
                .replaceAll("\\\\t", "")
                .replaceAll("\\\\f", "")
                .replaceAll("\\\\\\\\", "");
            log.info("receiveMdcApiMetadata remove huanhang:{}", messageStr);*/
            JSONObject jsonObject = JSON.parseObject(messageStr);
            String action = jsonObject.getString("action");
            String api_name = jsonObject.getString("api_name");
            String timestamp = jsonObject.getString("timestamp");

            lockName = kgMdcMessageListenerLockName + api_name;
            do {
                kgMdcMessageListenerContainerLock = redisLock.tryLock(lockName, 5 * 60 * 1000);
                log.info("{}:{}",lockName, kgMdcMessageListenerContainerLock);
            }while(kgMdcMessageListenerContainerLock == null);

            if(StringUtils.equalsIgnoreCase(action, "add")){ // 新增或者更新
                this.addMdcApiMetadataToNeo4j(messageStr);
            }
            /*else if(StringUtils.equalsIgnoreCase(action, "delete")){
                this.deteleMdcApiMetadataToNeo4j(messageStr);
            }*/
        } catch (Exception e) {
            log.error("MdcApiMetadataError error:{} , message:{} , ", e, messageStr);
        } finally {
            if(kgMdcMessageListenerContainerLock != null){
                log.info("释放锁{}：{}", lockName, kgMdcMessageListenerContainerLock);
                redisLock.unlock(lockName, kgMdcMessageListenerContainerLock);
            }
            channel.basicAck(message.getMessageProperties().getDeliveryTag(), true);
        }

    }

    private void deteleMdcApiMetadataToNeo4j(String messageStr){
        JSONObject jsonObject = JSON.parseObject(messageStr);
        String apiName = jsonObject.getString("api_name");
        String actionId = "esp_" + apiName;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("match (espAction:Action{")
                .append("actionId:'")
                .append(actionId)
                .append("'}) detach delete espAction");

        List<String> executeNeo4jScripts = new ArrayList<>();
        executeNeo4jScripts.add(stringBuffer.toString());

        executeNeo4jScript(executeNeo4jScripts, sessionFactoryDomain1);
        executeNeo4jScript(executeNeo4jScripts, sessionFactoryDomain2);
    }

    public String getTenantInitRouterKey(){
        Query query = new Query();
        Criteria criteria = Criteria.where("status").is(1);
        query.addCriteria(criteria);
        TenantInitRouterKey one = this.mongoTemplate.findOne(query, TenantInitRouterKey.class);

        return one == null ? null : one.getRouterKey();
    }


    public void addMdcApiMetadataToNeo4j(String messageStr){
        Map<String,Object> param = new HashMap<>();
        param.put("messageStr",messageStr);

        kgService.requestKg(SERVICE_NAME,"post",param);
        String tenantInitRouterKey = this.getTenantInitRouterKey();
        if(StringUtils.isNotEmpty(tenantInitRouterKey)){
            kgService.requestKg(SERVICE_NAME,"post",param,tenantInitRouterKey);
        }

        /*ApiMetadataDataDTO espApiMetadata = JSON.parseObject(messageStr, ApiMetadataDataDTO.class);
        String apiName = espApiMetadata.getApi_name();
        String apiVersion = espApiMetadata.getApi_version();
        String remark_cn = espApiMetadata.getRemark().getZh_CN();
        String remark_tw = espApiMetadata.getRemark().getZh_TW();
        remark_cn = remark_cn.replaceAll("'", "\\\\'");
        remark_tw = remark_tw.replaceAll("'", "\\\\'");
        String desc_cn = espApiMetadata.getDescription().getZh_CN();
        String desc_tw = espApiMetadata.getDescription().getZh_TW();
        String url = espApiMetadata.getUrl() == null ? "" : espApiMetadata.getUrl();
        String invokeType = espApiMetadata.getType();
        Boolean idempotency = espApiMetadata.getIdempotency();
        String actionId = "esp_" + apiName;

        ApiDataMetadataDTO dataMetadata = espApiMetadata.getData_metadata();
        List<ApiDataFieldMetadataDTO> fieldsOfParameter = new ArrayList<>();
        if (dataMetadata.getRequest().getBody().getField() != null && dataMetadata.getRequest().getBody().getField().get(0).getField() != null) {
            fieldsOfParameter = dataMetadata.getRequest().getBody().getField().get(0).getField();
        }
        List<ApiDataFieldMetadataDTO> fieldRequestObjects = new ArrayList<>();
        for (ApiDataFieldMetadataDTO fieldOfParameter : fieldsOfParameter) {
            if (!fieldOfParameter.getData_name().equals("enterprise_no")
                    && !fieldOfParameter.getData_name().equals("site_no")
                    && !fieldOfParameter.getData_name().equals("call_id")) {
                fieldRequestObjects.add(fieldOfParameter);
            }
        }

        Action oneByActionId = null;
        List<Action> actions = actionRepository.findByActionId(actionId);
        if(!CollectionUtils.isEmpty(actions)){
            oneByActionId = actions.get(0);
        }

        //TODO 暂时从库里已有的EnumKey同步
        if (!ObjectUtils.isEmpty(oneByActionId)) {
            List<ApiDataFieldMetadataDTO> request_parameters = JSONArray.parseArray(oneByActionId.getRequest_parameters(), ApiDataFieldMetadataDTO.class);
            putEnumKey(fieldRequestObjects, request_parameters);
        }

        String request_str = JSON.toJSONString(fieldRequestObjects, SerializerFeature.NotWriteDefaultValue);
        List<ApiDataFieldMetadataDTO> fieldsOfResponse = dataMetadata.getResponse_success().getBody().getField();
        ApiDataFieldMetadataDTO fieldReponseObject = null;
        for (ApiDataFieldMetadataDTO fieldOfResponse : fieldsOfResponse) {
            if (fieldOfResponse.getData_name().equals("parameter")) {
                fieldReponseObject = fieldOfResponse;
                break;
            }
        }
        String response_str = "";
        if (fieldReponseObject != null && fieldReponseObject.getField().size() > 0) {
            Optional<ApiDataFieldMetadataDTO> findObject = fieldReponseObject.getField().stream().filter(field -> "object".equals(field.getData_type())).findFirst();
            if (findObject.isPresent()) {
                ApiDataFieldMetadataDTO apiDataFieldMetadataDTO = findObject.get();
                //TODO 暂时从库里已有的EnumKey同步
                if (!ObjectUtils.isEmpty(oneByActionId)) {
                    ApiDataFieldMetadataDTO response_object = JSONObject.parseObject(oneByActionId.getResponse_object(), ApiDataFieldMetadataDTO.class);
                    if (response_object != null) {
                        putEnumKey(apiDataFieldMetadataDTO, response_object);
                    }
                }
                response_str = JSON.toJSONString(apiDataFieldMetadataDTO, SerializerFeature.NotWriteDefaultValue);
            } else
                response_str = JSON.toJSONString(fieldReponseObject.getField().get(0), SerializerFeature.NotWriteDefaultValue);
        }

        String deployVersion = "1.0";
        List<String> executeNeo4jScripts = new ArrayList<>();
        if (ObjectUtils.isEmpty(oneByActionId)) {
            log.info("MdcApiMetadata Create：{}", actionId);
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Create (action:Action:EspAction {");
            stringBuffer.append("actionId:'");
            stringBuffer.append(actionId);
            stringBuffer.append("', url:'");
            stringBuffer.append(url);
            stringBuffer.append("', serviceName:'");
            stringBuffer.append(apiName);
            stringBuffer.append("', serviceVersion:'");
            stringBuffer.append(apiVersion);
            stringBuffer.append("', actionName:'");
            stringBuffer.append(desc_cn);
            stringBuffer.append("', actionName_tw:'");
            stringBuffer.append(desc_tw);
            stringBuffer.append("', desc:'");
            stringBuffer.append(remark_cn);
            stringBuffer.append("', desc_tw:'");
            stringBuffer.append(remark_tw);
            stringBuffer.append("', request_parameters:'");
            stringBuffer.append(request_str.replaceAll("'", "\\\\'"));
            stringBuffer.append("', response_object:'");
            stringBuffer.append(response_str.replaceAll("'", "\\\\'"));
            stringBuffer.append("', invokeType:'");
            stringBuffer.append(invokeType);
            //                stringBuffer.append("', lastUpdateTime:'");
            //                stringBuffer.append(espApiLastUpdateTime);
            stringBuffer.append("', idempotency:");
            stringBuffer.append(idempotency);
            stringBuffer.append(", version:'");
            stringBuffer.append(deployVersion);
            stringBuffer.append("', nameSpace:'");
            stringBuffer.append("espCommon");
            stringBuffer.append("'})");

            StringBuffer relationSb = new StringBuffer();
            relationSb.append("match (te:TenantEntity)")
                    .append(" match (espAction:Action{")
                    .append("actionId:'")
                    .append(actionId)
                    .append("'}) ")
                    .append(" merge (te)-[:ACTION]->(espAction)");

            executeNeo4jScripts.add(stringBuffer.toString());
            executeNeo4jScripts.add(relationSb.toString());
        } else {
            log.info("MdcApiMetadata Update：{}", actionId);
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Match (action:Action:EspAction {");
            stringBuffer.append("actionId:'");
            stringBuffer.append(actionId);
            stringBuffer.append("'})  where action.tenantId is null set action.url='");
            stringBuffer.append(url);
            stringBuffer.append("', action.serviceName='");
            stringBuffer.append(apiName);
            stringBuffer.append("', action.serviceVersion='");
            stringBuffer.append(apiVersion);
            stringBuffer.append("', action.actionName='");
            stringBuffer.append(desc_cn);
            stringBuffer.append("', action.actionName_tw='");
            stringBuffer.append(desc_tw);
            stringBuffer.append("', action.desc='");
            stringBuffer.append(remark_cn);
            stringBuffer.append("', action.desc_tw='");
            stringBuffer.append(remark_tw);
            stringBuffer.append("', action.request_parameters='");
            stringBuffer.append(request_str.replaceAll("'", "\\\\'"));
            stringBuffer.append("', action.response_object='");
            stringBuffer.append(response_str.replaceAll("'", "\\\\'"));
            stringBuffer.append("', action.invokeType='");
            stringBuffer.append(invokeType);
            //                stringBuffer.append("', action.lastUpdateTime='");
            //                stringBuffer.append(espApiLastUpdateTime);
            stringBuffer.append("', action.idempotency=");
            stringBuffer.append(idempotency);
            stringBuffer.append(", action.version='");
            stringBuffer.append(deployVersion);
            stringBuffer.append("', action.nameSpace='");
            stringBuffer.append("espCommon");
            stringBuffer.append("'");

            executeNeo4jScripts.add(stringBuffer.toString());
        }

        executeNeo4jScript(executeNeo4jScripts, sessionFactoryDomain1);
        executeNeo4jScript(executeNeo4jScripts, sessionFactoryDomain2);*/
    }

    private void executeNeo4jScript(List<String> executeNeo4jScripts, SessionFactory sessionFactory){
        if(CollectionUtils.isEmpty(executeNeo4jScripts)){
            return;
        }

        if(sessionFactory == null){
            return;
        }
        Session session = sessionFactory.openSession();

        try (Transaction transaction = session.beginTransaction()){
            for(String str : executeNeo4jScripts){
                session.query(str, new HashMap<>());
            }
            transaction.commit();
        }

        session.clear();
    }

    private void putEnumKey(ApiDataFieldMetadataDTO toApiDataFieldMeta, ApiDataFieldMetadataDTO fromApiDataFieldMeta) {
        if (toApiDataFieldMeta.getData_name().equals(fromApiDataFieldMeta.getData_name())) {
            if ("object".equals(toApiDataFieldMeta.getData_type()) && "object".equals(fromApiDataFieldMeta.getData_type())) {
                List<ApiDataFieldMetadataDTO> toApiSubDataFieldMeta = toApiDataFieldMeta.getField();
                List<ApiDataFieldMetadataDTO> fromApiSubDataFieldMeta = fromApiDataFieldMeta.getField();
                putEnumKey(toApiSubDataFieldMeta, fromApiSubDataFieldMeta);
            } else {
                toApiDataFieldMeta.setEnum_key(fromApiDataFieldMeta.getEnum_key());
            }
        }
    }

    private void putEnumKey(List<ApiDataFieldMetadataDTO> toApiDataFieldMetas, List<ApiDataFieldMetadataDTO> fromApiDataFieldMetas) {
        toApiDataFieldMetas.forEach(toApiDataFieldMetadata -> {
            Optional<ApiDataFieldMetadataDTO> fromApiDataFieldMeta = fromApiDataFieldMetas.stream().filter(fromApiDataFieldMetadata -> fromApiDataFieldMetadata.getData_name().equals(toApiDataFieldMetadata.getData_name())).findFirst();
            if (fromApiDataFieldMeta.isPresent())
                putEnumKey(toApiDataFieldMetadata, fromApiDataFieldMeta.get());
        });
    }

}
