package com.digiwin.athena.knowledgegraph.mq;

import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.athena.knowledgegraph.utils.I18nUtils;
import com.rabbitmq.client.*;
import lombok.extern.slf4j.Slf4j;
import org.springframework.amqp.AmqpException;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.core.MessagePostProcessor;
import org.springframework.amqp.rabbit.connection.CorrelationData;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

import java.io.IOException;
import java.net.URISyntaxException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.UUID;
import java.util.concurrent.TimeoutException;
@Component
@Slf4j
public class RabbitMQManager implements InitializingBean {
    private static String rabbitMQUri = "amqp://digiwin:digiwin@mq-test.digiwincloud.com.cn/athena";
    @Value("${rabbitMQExchangeName}")
    private  String exchangeName = "themeMap";
    @Value("${rabbitMQExchangeType}")
    private  String exchangeType = "direct";
    @Value("${rabbitMQPersistent}")
    private  Boolean persistent = true;
    @Value("${rabbitMQEnabled}")
    private  Boolean rabbitMQEnabled = true;

    private static RabbitMQManager rabbitMQManager = null;

    @Autowired(required = false)
    private org.springframework.amqp.rabbit.connection.ConnectionFactory connectionFactory;
    @Autowired(required = false)
    private RabbitTemplate rabbitTemplate;


//
//    static {
//        try {
//            rabbitMQManager = new RabbitMQManager();
//        } catch (NoSuchAlgorithmException e) {
//            e.printStackTrace();
//        } catch (KeyManagementException e) {
//            e.printStackTrace();
//        } catch (URISyntaxException e) {
//            e.printStackTrace();
//        } catch (IOException e) {
//            e.printStackTrace();
//        } catch (TimeoutException e) {
//            e.printStackTrace();
//        }
//    }

    public static RabbitMQManager getRabbitMQManager() throws DWBusinessException {
        if (rabbitMQManager == null) {
            throw new DWBusinessException(I18nUtils.getValue("knowledgegraph.mqCreateError"));
        }
        return rabbitMQManager;
    }

    //MQ连接共享 不需要每次重建
    private Connection connection = null;
//    private RabbitMQManager() throws NoSuchAlgorithmException, KeyManagementException, URISyntaxException, IOException, TimeoutException {
//        if (!UnitTestHelper.isUnitTest) {
//            rabbitMQUri = DWModuleConfigUtils.getCurrentModuleProperty("rabbitMQUri");
//            exchangeName = DWModuleConfigUtils.getCurrentModuleProperty("rabbitMQExchangeName");
//            exchangeType = DWModuleConfigUtils.getCurrentModuleProperty("rabbitMQExchangeType");
//            persistent = Boolean.parseBoolean(DWModuleConfigUtils.getCurrentModuleProperty("rabbitMQPersistent"));
//            rabbitMQEnabled = Boolean.parseBoolean(DWModuleConfigUtils.getCurrentModuleProperty("rabbitMQEnabled"));
//        }
//        if (rabbitMQEnabled && connection == null) {
//            ConnectionFactory factory = new ConnectionFactory();
//            factory.setUri(rabbitMQUri);
//            connection = factory.newConnection();//创建连接
//        }
//    }

    public boolean getEnabled() {
        return rabbitMQEnabled;
    }

    private Channel CreateChannel(String exchangeName, String exchangeType, boolean durable, String queueName, String routingKey) throws NoSuchAlgorithmException, KeyManagementException, URISyntaxException, IOException, TimeoutException {
        Channel channel = connection.createChannel();//创建信道
        channel.exchangeDeclare(exchangeName, exchangeType, durable);//声明交换器
        channel.queueDeclare(queueName, durable, false, false, null);//声明队列
        channel.queueBind(queueName, exchangeName, routingKey);//交换器采用direct模式 routingKey 等同于 bindingKey
        return channel;
    }

//    public boolean PublishMessage(String message, String queueName, String routingKey) throws URISyntaxException, IOException, TimeoutException, NoSuchAlgorithmException, KeyManagementException, DWArgumentException {
//        boolean re = false;
//        if (!rabbitMQEnabled) {
//            return re;
//        }
//
//        if (message == null || message.isEmpty()) {
//            throw new DWArgumentException("message", "message can't be empty");
//        }
//        if (queueName == null || queueName.isEmpty()) {
//            throw new DWArgumentException("queueName", "queueName can't be empty");
//        }
//        if (routingKey == null || routingKey.isEmpty()) {
//            throw new DWArgumentException("routingKey", "routingKey can't be empty");
//        }
//
//        Channel channel = CreateChannel(exchangeName, exchangeType, persistent, queueName, routingKey);
//        AMQP.BasicProperties.Builder builder = new AMQP.BasicProperties().builder();
//        builder.contentType("text/plain");
//        if (persistent) {
//            builder.deliveryMode(2);//1:消息不持久化 2:消息持久化
//        }
//
//        //考虑线程安全问题 目前采用每次发送时创建channel 启用事务机制确保发送成功
//        //由于是每次发送消息创建线程专用的channel 事务机制不会造成阻塞
//        //channel考虑是否做成共享 粒度可以是发送方同一用途 需要将事务机制转为发送方确认机制
//        try {
//            channel.txSelect();
//            channel.basicPublish(exchangeName, routingKey, builder.build(), message.getBytes());
//            channel.txCommit();
//            re = true;//提交后消息发送成功
//        } catch (Exception e) {
//            e.printStackTrace();
//            channel.txRollback();
//            re = false;//事务回滚消息发送失败
//        }
//
//        channel.close();
//        return re;
//    }

    public boolean PublishMessage(String message,  String routingKey)  {
        if (!rabbitMQEnabled) {
            return true;
        }
        log.info("sendMQMessage exchangeName:{}, routingKey:{}, message:{}", exchangeName, routingKey, message);
        this.rabbitTemplate.convertAndSend(exchangeName,routingKey,message);
        return true;
    }

    public boolean PublishMessage(String message, String queueName, String routingKey)  {
        if (!rabbitMQEnabled) {
            return false;
        }
        log.info("sendMQMessage exchangeName:{}, routingKey:{}, message:{}", exchangeName, routingKey, message);
        this.rabbitTemplate.convertAndSend(exchangeName,routingKey,message);
        return true;
    }

    public boolean PublishMessage(String message, String exchange, String routingKey, String expiration)  {
        if (!rabbitMQEnabled) {
            return true;
        }
        this.rabbitTemplate.convertAndSend(exchange,routingKey,message,new MessagePostProcessor() {
            @Override
            public Message postProcessMessage(Message message) throws AmqpException {
                message.getMessageProperties().setExpiration(expiration);
                return message;
            }
        },new CorrelationData(UUID.randomUUID().toString()));

        return true;
    }

    //消费消息 拉模式 单元测试用
    public String GetMessage(String queueName, String routingKey) throws URISyntaxException, IOException, TimeoutException, NoSuchAlgorithmException, KeyManagementException {
        String re = null;
        if (!rabbitMQEnabled) {
            return re;
        }

        Channel channel = CreateChannel(exchangeName, exchangeType, persistent, queueName, routingKey);//创建信道
        GetResponse resp = channel.basicGet(queueName, false);
        if (resp != null) {
            re = new String(resp.getBody());
        }
        if (null != resp && null != resp.getEnvelope()) {
            channel.basicAck(resp.getEnvelope().getDeliveryTag(), false);
        }
        channel.close();
        return re;
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        rabbitMQManager = this;
        if(null!=connectionFactory){
            try {
                connection = connectionFactory.createConnection().createChannel(false).getConnection();
            }catch (Exception e) {
                log.error("afterPropertiesSet connectionFactory createConnection fail, e:{} ",e);
            }
        }
     }
}