package com.digiwin.athena.knowledgegraph.pullingMap.model;

import com.alibaba.fastjson.JSON;
import com.digiwin.athena.dto.ApiDataFieldMetadataDTO;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;
import java.util.UUID;

@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class DataPullingActionDO {
    private String actionId;
    private String name;
    private List<ApiDataFieldMetadataDTO> request;
    private ApiDataFieldMetadataDTO response;
    private String sceneNodeType;

    public String GeneratePullDataCreateScript(String nameSpace) {
        String uid = UUID.randomUUID().toString().toLowerCase().replaceAll("-", "");
        return String.format("create (process:DataPullingAction:Action {id:'%1$s',actionId:'%2$s',version:'2.0', name:'%3$s', type:'DATA_PULLING', request_parameters:'%4$s', response_object:'%5$s', nameSpace:'%6$s',sceneNodeType:'%7$s'})",
                uid, this.actionId, this.name, JSON.toJSONString(this.request), this.response == null ? "" : JSON.toJSONString(response), nameSpace,this.sceneNodeType);
    }

    public String GenerateBmdCreateScript(String nameSpace,String querySchema) {
        String uid = UUID.randomUUID().toString().toLowerCase().replaceAll("-", "");
        return String.format("create (process:BmdGeneralAction:Action {id:'%1$s',actionId:'%2$s', name:'%3$s', type:'BMD_GENERAL',version:'2.0',queryMethod:'querySchema', request_parameters:'%4$s', response_object:'%5$s', nameSpace:'%6$s',querySchema : '%7$s'})",
                uid, this.actionId, this.name, JSON.toJSONString(this.request), this.response == null ? "" : JSON.toJSONString(response), nameSpace,querySchema);
    }

    public String GenerateMicroTransCreateScript(String nameSpace,String microTrans) {
        String uid = UUID.randomUUID().toString().toLowerCase().replaceAll("-", "");
        return String.format("create (process:MicroTransformAction:Action {id:'%1$s',actionId:'%2$s', version:'2.0',ruleId:'%3$s',name:'%4$s', type:'MICRO_TRANS', request_parameters:'%5$s', response_object:'%6$s', nameSpace:'%7$s',microTrans:'%8$s'})",
                uid, this.actionId, "", this.name, JSON.toJSONString(this.request), this.response == null ? "" : JSON.toJSONString(response),nameSpace,microTrans);
    }

    public String GenerateBmdNewCreateScript(String nameSpace,String spName) {
        String uid = UUID.randomUUID().toString().toLowerCase().replaceAll("-", "");
        return String.format("create (process:BmdAction:Action {id:'%1$s',actionId:'%2$s', name:'%3$s', type:'BMD',version:'2.0',queryMethod:'querySchema', request_parameters:'%4$s', response_object:'%5$s', nameSpace:'%6$s',spName : '%7$s',sceneNodeType:'%8$s'})",
                uid, this.actionId, this.name, JSON.toJSONString(this.request), this.response == null ? "" : JSON.toJSONString(response), nameSpace,spName,this.sceneNodeType);
    }
}
