package com.digiwin.athena.knowledgegraph.rule;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.app.container.exceptions.DWArgumentException;
import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.app.container.exceptions.DWException;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.athena.kg.domain.OperationUnitV2;
import com.digiwin.athena.kg.monitorRule.*;
import com.digiwin.athena.kmservice.action.execution.ProductNameResolver;
import com.digiwin.athena.kmservice.utils.EocUtils;
import com.digiwin.athena.kmservice.utils.IAMUtils;
import com.digiwin.athena.kmservice.aspect.MyExceptionHandler;
import com.digiwin.athena.knowledgegraph.clients.ESPUtils;
import com.digiwin.athena.knowledgegraph.clients.EocService;
import com.digiwin.athena.knowledgegraph.data.MongoDBManager;
import com.digiwin.athena.knowledgegraph.domain.MonitorRule;
import com.digiwin.athena.knowledgegraph.domain.TenantEntity;
import com.digiwin.athena.knowledgegraph.domain.common.OperationUnit;
import com.digiwin.athena.knowledgegraph.domain.rule.MonitorRuleConfig;
import com.digiwin.athena.knowledgegraph.mq.RabbitMQManager;
import com.digiwin.athena.repository.neo4j.MonitorRuleRepository;
import com.digiwin.athena.knowledgegraph.rule.model.MonitorRuleCategoryEnum;
import com.digiwin.athena.kg.monitorRule.product.FieldMappingConfigDO;
import com.digiwin.athena.kg.monitorRule.tenant.TenantDynamicConditionDO;
import com.digiwin.athena.knowledgegraph.service.IMonitorRuleConfigService;
import com.digiwin.athena.knowledgegraph.service.KgInnerService;
import com.digiwin.athena.knowledgegraph.service.OperationUnitService;
import com.digiwin.athena.knowledgegraph.service.impl.ConfigChangeTypeEnum;
import com.digiwin.athena.knowledgegraph.service.impl.ProductService;
import com.digiwin.athena.knowledgegraph.service.impl.TenantService;
import com.digiwin.athena.knowledgegraph.service.inner.DataPickService;
import com.digiwin.athena.knowledgegraph.service.model.MonitorRuleConfigDTO;
import com.digiwin.athena.knowledgegraph.service.model.MonitorRuleSyncResult;
import com.digiwin.athena.knowledgegraph.utils.AthenaUtils;
import com.digiwin.athena.knowledgegraph.utils.I18nUtils;
import com.digiwin.athena.knowledgegraph.utils.MonitorRuleUtil;
import com.digiwin.athena.knowledgegraph.vo.MonitorEocChangeVO;
import com.digiwin.athena.kmservice.povo.productOperation.OrgTypeCompany;
import com.digiwin.athena.kmservice.povo.productOperation.OrgTypeSite;
import com.digiwin.athena.kmservice.povo.productOperation.ProdEocMapping;
import com.digiwin.athena.kmservice.povo.productOperation.ProductOperationResult;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.result.UpdateResult;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bson.Document;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

import java.util.*;
import java.util.stream.Collectors;

import static com.mongodb.client.model.Filters.eq;

@MyExceptionHandler
@Service
public class MonitorRuleConfigService implements IMonitorRuleConfigService {
    private static String monitorRuleConfigColName = "monitorRuleTenantConfig";
    private static String monitorRuleConfigKeyName = "configId";

//    private static String rabbitQueueName = "utMonitorRuleConfigQueue";
//    private static String rabbitRoutingKey = "utMonitorRuleConfig";
//    private static String monitorCrossLevelRoutingKey = "monitorCrossLevelRoutingKey";

    private static Log log = LogFactory.getLog(MonitorRuleConfigService.class);

    @Value("${monitorRuleConfigQueueName}")
    private  String rabbitQueueName = "MonitorRuleConfigQueue";
    @Value("${monitorRuleConfigRoutingKey}")
    private  String rabbitRoutingKey = "MonitorRuleConfig";
    @Value("${monitorCrossLevelRoutingKey}")
    private  String monitorCrossLevelRoutingKey = "routingKey.monitor.crossLevel";

    // 用于推送侦测信息
    @Value("${monitorRuleConfigCDCRoutingKey}")
    private String monitorRuleConfigCDCRoutingKey;
    @Value("${monitorRuleConfigCDCQueueName}")
    private String monitorRuleConfigCDCQueueName;
    // 用于推送eoc变更信息
    @Value("${monitorCrossLevelCDCRoutingKey}")
    private String monitorCrossLevelCDCRoutingKey;
    @Value("${monitorCrossLevelCDCQueueName}")
    private String monitorCrossLevelCDCQueueName;

    @Autowired
    @Qualifier("knowledgegraphTenant")
    private MongoTemplate mongoTemplate;

    @Autowired
    @Qualifier("knowledgegraphSystem")
    private MongoTemplate mongoTemplateSystem;
    @Autowired
    private MonitorRuleRepository monitorRuleRepository;
    @Autowired
    private OperationUnitService operationUnitService;
    @Autowired
    TenantService tenantService;
    @Autowired
    private ProductNameResolver productNameResolver;
    @Autowired
    private MonitorRuleManager monitorRuleManager;
    @Autowired
    private ProductService productService;

    @Autowired
    KgInnerService kgInnerService;

    @Autowired
    private ESPUtils espUtils;

    @Autowired
    private EocService eocService;

    @Autowired
    DataPickService dataPickService;

    @Autowired
    EocUtils eocUtils;

    @Autowired
    IAMUtils iamUtils;
//    static {
//        if (!UnitTestHelper.isUnitTest) {
//            //必须通过 DWModuleConfigUtils.getProperty 方法来获取参数
//            //使用DWModuleConfigUtils.getCurrentModuleProperty部署到云端的情况会取不到当前模块 无法获取参数
//            rabbitQueueName = DWModuleConfigUtils.getProperty("knowledgegraph","monitorRuleConfigQueueName");
//            rabbitRoutingKey = DWModuleConfigUtils.getProperty("knowledgegraph","monitorRuleConfigRoutingKey");
//            monitorCrossLevelRoutingKey = DWModuleConfigUtils.getProperty("knowledgegraph","monitorCrossLevelRoutingKey");
//        }
//    }

    private void sendMessage(String tenantId, String ruleId, EocMapDTO eocMap, ConfigChangeTypeEnum changeType) throws Exception {
        this.sendMessage(tenantId, ruleId, eocMap, changeType, null, null, null, null);
    }

    private void sendMessage(String tenantId, String ruleId, ConfigChangeTypeEnum changeType) throws Exception {
        this.sendMessage(tenantId, ruleId, null, changeType, null, null,null,null);
    }

    private String sendMessage(String tenantId, String ruleId, EocMapDTO eocMap, ConfigChangeTypeEnum changeType, Boolean enableStatus, String sendWay, String transactionId) throws Exception {
        return this.sendMessage(tenantId, ruleId, eocMap, changeType, enableStatus, null, sendWay,transactionId);
    }

    public String sendMessage(String tenantId, String ruleId, EocMapDTO eocMap, ConfigChangeTypeEnum changeType, Boolean enableStatus, String backtrackDate, String sendWay, String transactionId) throws Exception {
        RabbitMQManager mqManager = RabbitMQManager.getRabbitMQManager();

        String strEnable = "";
        if (enableStatus != null) {
            if (enableStatus) {
                strEnable = ",\"enableStatus\":\"Y\"";
            } else {
                strEnable = ",\"enableStatus\":\"N\"";
            }
        }
        String strBacktrackDate = "";
        if (StringUtils.isNotEmpty(backtrackDate)) {
            strBacktrackDate = String.format(",\"backtrackDate\":\"%s\"", backtrackDate);
        }
        String curTransationId = "";
        if (StringUtils.isNotEmpty(transactionId)) {
            curTransationId = String.format(",\"transactionId\":\"%s\"", transactionId);
        }

        String msg = String.format("{\"tenantId\":\"%s\",\"ruleId\":\"%s\",\"changeType\":\"%s\",\"eocMap\":%s%s%s%s}", tenantId, ruleId, changeType, eocMap != null ? JSONObject.toJSONString(eocMap):"{}", strEnable, strBacktrackDate,curTransationId);
        log.info("sendMsg:" + msg);
        if(StringUtils.equalsIgnoreCase("HTTP", sendWay)){
            return msg;
        }else{
            if (mqManager.getEnabled()) {

                try {
                    boolean sendSuccess;
                    String tenantVersion = kgInnerService.getTenantVersion(tenantId);
                    MonitorRule monitorRule = this.monitorRuleManager.queryMonitorRule(ruleId, tenantId, tenantVersion);
                    String category = monitorRule.getCategory();
                    log.info("RabbitMQ message begin，ruleId:" + ruleId +",tenantId:" + tenantId + ",category:" + category);
                    //CDC和MQTT的都发送给CDME
                    if (MonitorRuleUtil.Category.CATEGORYS.contains(category)) {
                        sendSuccess = mqManager.PublishMessage(msg, monitorRuleConfigCDCQueueName, monitorRuleConfigCDCRoutingKey);
                    } else {
                        sendSuccess = mqManager.PublishMessage(msg, rabbitQueueName, rabbitRoutingKey);
                    }

                    if (!sendSuccess) {//发送失败 记录日志
                        log.info("RabbitMQ message not send");
                        return null;
                    }
                    return msg;
                } catch (Exception e) {
                    // 如果是删除，可能是monitorRule没有从neo4j中获取到的异常，直接发送消息到MQ
                    if (Objects.equals(changeType.toString(),ConfigChangeTypeEnum.DELETED.toString())) {
                        boolean sendSuccessCdc = mqManager.PublishMessage(msg, monitorRuleConfigCDCQueueName, monitorRuleConfigCDCRoutingKey);
                        boolean sendSuccessNotCdc = mqManager.PublishMessage(msg, rabbitQueueName, rabbitRoutingKey);
                        log.info("RabbitMQ message send sendSuccessCdc :"+ sendSuccessCdc + ",sendSuccessNotCdc:"+sendSuccessNotCdc);
                        if (!(sendSuccessCdc && sendSuccessNotCdc)) {//发送失败 记录日志
                            log.info("RabbitMQ message not send");
                            return null;
                        }
                        return msg;
                    }else{
                        log.info("RabbitMQ message was sent failed");
                        throw new DWBusinessException(e.getLocalizedMessage());
                    }
                }
            }
            return null;
        }
    }


    private void sendMessage(String message, String rabbitRoutingKey) throws Exception {
        RabbitMQManager mqManager = RabbitMQManager.getRabbitMQManager();
        if (mqManager.getEnabled()) {
            try {
                JSONObject jsonObject = JSON.parseObject(message);
                String tenantId = (String)jsonObject.get("tenantId");
                String ruleId = (String)jsonObject.get("ruleId");
                String tenantVersion = kgInnerService.getTenantVersion(tenantId);
                MonitorRule monitorRule = this.monitorRuleManager.queryMonitorRule(ruleId, tenantId, tenantVersion);
                String category = monitorRule.getCategory();
                log.info("RabbitMQ message begin，ruleId:" + ruleId +",tenantId:" + tenantId + ",tenantId:" + category);
                if (Objects.equals(category,MonitorRuleCategoryEnum.CDC.toString())) {
                    rabbitRoutingKey = monitorCrossLevelCDCRoutingKey;
                }
                log.info("rabbitRoutingKey:" + rabbitRoutingKey);
                boolean sendSuccess = mqManager.PublishMessage(message, rabbitRoutingKey);
                if (!sendSuccess) {//发送失败 记录日志
                    log.info("RabbitMQ message was sent failed, msg:{}" + message);
                }
            }
            catch (Exception e) {
                log.info("RabbitMQ message was sent failed, msg:{}" + message);
                throw new DWBusinessException(e.getLocalizedMessage());
            }
        }
    }

    @Override
    public Object put(MonitorRuleConfigDTO config) throws Exception {
        String configId = config.getConfigId();
        if (configId == null || configId.isEmpty()) {
            throw new DWArgumentException("config", I18nUtils.getValue("knowledgegraph.config.configIdEmpty"));
        }
        String tenantId = config.getTenantId();
        if (tenantId == null || tenantId.isEmpty()) {
            throw new DWArgumentException("config", I18nUtils.getValue("knowledgegraph.config.tenantIdEmpty"));
        }
        String ruleId = config.getMonitorRuleId();
        if (ruleId == null || ruleId.isEmpty()) {
            throw new DWArgumentException("config", I18nUtils.getValue("knowledgegraph.config.ruleIdEmpty"));
        }


        Map<String, Object> configMap = new HashMap<>();
        configMap.put(monitorRuleConfigKeyName, config.getConfigId());
        configMap.put("tenantId", tenantId);
        configMap.put("monitorRuleId", ruleId);
        configMap.put("productName", config.getProductName());
        if (config.getStatus() != null) {
            configMap.put("status", config.getStatus());
        } else {//默认为启用
            configMap.put("status", 1);
        }
        if (config.getEocMap() != null) {
            configMap.put("eocMap", config.getEocMap());
        }
        if (config.getStandardPollingRule() != null) {
            configMap.put("standardPollingRule", config.getStandardPollingRule());
        }
        if (config.getStandardPollingRules() != null) {
            configMap.put("standardPollingRules", config.getStandardPollingRules());
        }

        try {
//            MongoCollection<Document> col = MongoDBManager.getMongoDBManager().getCollection(monitorRuleConfigColName, monitorRuleConfigKeyName);
//            col.insertOne(new Document(configMap));
            this.mongoTemplate.insert(configMap, monitorRuleConfigColName);

            this.sendMessage(tenantId, ruleId, config.getEocMap(), ConfigChangeTypeEnum.CREATED, null, config.getBacktrackDate(), "MQ", UUID.randomUUID().toString());
        } catch (Exception e) {
            throw new DWBusinessException(e.getLocalizedMessage());
        }

      //  return DWServiceResultBuilder.build(true, null);
        return null;
    }

    @Override
    public Object delete(String tenantId, String ruleId) throws Exception {
//        Document doc = this.get(configId);
//
//        if (doc != null) {
//            MongoCollection<Document> col = MongoDBManager.getMongoDBManager().getCollection(monitorRuleConfigColName, monitorRuleConfigKeyName);
//            col.deleteOne(eq(monitorRuleConfigKeyName, configId));
//
//            //保存时 tennantId ruleId 判断不可为空 这里获取到的数据不应该为空 不做空值判断
//            SendMessage((String) doc.get("tenantId"), (String) doc.get("ruleId"), ConfigChangeTypeEnum.DELETED);
//        }
        Query query = new Query();
        Criteria criteria1 = Criteria.where("tenantId").is(tenantId);
        Criteria criteria2 = Criteria.where("monitorRuleId").is(ruleId);
        query.addCriteria(new Criteria().andOperator(criteria1, criteria2));

        try {
            this.mongoTemplate.remove(query, MonitorRuleTenantConfig.class);

            this.sendMessage(tenantId, ruleId, ConfigChangeTypeEnum.DELETED);
        } catch (Exception e) {
            throw new DWBusinessException(e.getLocalizedMessage());
        }

     //   return DWServiceResultBuilder.build(true, null);
        return null;
    }

    private Document get(String configId) throws Exception {
        MongoCollection<Document> col = MongoDBManager.getMongoDBManager().getCollection(monitorRuleConfigColName, monitorRuleConfigKeyName);
        Document doc = col.find(eq("configId", configId)).first();
        return doc;
    }

//    @Async
    public void saveTenantMonitorRule(MonitorRuleConfigDTO config) throws Exception {
        try {
            Map<String, Object> profile = new HashMap<>();
            profile.put("tenantId", config.getTenantId());//athenaPaasW AthenaWFPASS E10ATHENApass athenaTestW
            DWServiceContext.getContext().setProfile(profile);
            List<String> productNames = productNameResolver.getCloudProductNamesAfterEocSet(config.getTenantId());
            if (!CollectionUtils.isEmpty(productNames) && (productNames.contains("E10") || productNames.contains("e10"))) {
                this.post(config);
            }
        }catch(Exception e) {
            log.error("call saveTenantMonitorRule error : {}",e);
        }
    }

    @Override
    public Object post(MonitorRuleConfigDTO config) throws Exception {
        String tenantId = StringUtils.isNotEmpty(config.getTenantId()) ? config.getTenantId() : AthenaUtils.getTenantId();
        String tenantVersion = kgInnerService.getTenantVersion(tenantId);
//        if (StringUtils.isEmpty(config.getProductName())) {
//            throw new DWBusinessException("侦测对应的产品不能为空");
//        }
        //对数据库中不同层级的侦测进行处理
        String isEocChange = this.checkIsEocChange(config);  //add by srj 20220609 检查eoc层级是否改变
        log.info("isEocChange:" + isEocChange);
        MonitorRule monitorRule = this.monitorRuleManager.queryMonitorRule(config.getMonitorRuleId(), tenantId, tenantVersion);
        if (StringUtils.isNotEmpty(isEocChange)) {
//        boolean isCropToEoc = this.checkIsCropToEoc(config);
//        if(isCropToEoc){ //如果侦测是从集团变为运营单元，则进行降级的操作
            String curTransactionId = UUID.randomUUID().toString();
            String o = this.handleCropToEoc(config, curTransactionId, isEocChange);

            Map<String, String> result = new HashMap<>();
            result.put("transactionId", curTransactionId);
            result.put("sendMessage", o);
            result.put("isCropToEoc", "Y");
            result.put("category", monitorRule.getCategory());
            return result;
        }

        Query query = new Query();
        Criteria criteria1 = Criteria.where("tenantId").is(config.getTenantId());
        Criteria criteria2 = Criteria.where("monitorRuleId").is(config.getMonitorRuleId());
        Criteria criteria = new Criteria().andOperator(criteria1, criteria2);
        EocMapDTO eocMap = config.getEocMap();
        if (eocMap != null) {
            boolean check = this.validateEocLevel(config.getMonitorRuleId(), config.getProductName(), eocMap);
            if (!check) {
                throw new DWBusinessException("P.KG.500.0031", I18nUtils.getValue("knowledgegraph.ruleError") + config.getMonitorRuleId());
            }
            criteria = addOperationUnitCondition(criteria, eocMap);
        }
        query.addCriteria(criteria);

        //判断是否是立即执行发起 如果是立即执行 则不需要判断脏数据状态
        MonitorRuleTenantConfig one = this.mongoTemplate.findOne(query, MonitorRuleTenantConfig.class);
        if ((config.getDirectExecution() == null || !config.getDirectExecution()) && !config.isHasMechanismOrCustomParam()) {
            //modify by shirj 未生效的侦测，也创建下通知sd创建排程，并保存数据
//            if (one == null && (config.getStatus() == null || config.getStatus() == 0)) {
//                return new HashMap<>();
//            }

            //判断已存在的数据是否与要保存的数据相同 若相同则不再保存 和 推送MQ
            if (one != null) {
                //目前只判断 StandardPollingRule Status productName是否一致; 未加入条件判断
                if (Objects.equals(one.getStatus(), config.getStatus()) && StringUtils.equals(one.getProductName(), config.getProductName())) {
//                    TriggerDTO oldTrigger = (TriggerDTO) one.getStandardPollingRule();
//                    TriggerDTO oldTrigger = JSON.parse()
                    if (!this.checkStandardPollingRuleHasChange(one, config) && ObjectUtils.isEmpty(config.getTenantDynamicCondition()) && ObjectUtils.isEmpty(one.getDynamicCondition())) { //当动态条件没值时 不存在多个排程时间时
                        return new HashMap<>();//待更新数据与数据库中旧数据一致 则不更新数据 不推送MQ
                    }
                }
            }
        }
        String curTransactionId = UUID.randomUUID().toString();
        String sendMessage = null;
        Update update = new Update();
        update.set("standardPollingRule", config.getStandardPollingRule());//更新侦测规则
        update.set("standardPollingRules", config.getStandardPollingRules());//更新侦测规则
        update.set("productName", config.getProductName());//更新产品信息
        if (config.getStatus() != null) {
            update.set("status", config.getStatus());//更新状态
        }
//        if(!ObjectUtils.isEmpty(config.getTenantDynamicCondition())){
        update.set("dynamicCondition", config.getTenantDynamicCondition());
//        }
//        update.set("backtrackDate", config.getBacktrackDate());//增加回溯时间
        update.set("transactionId", curTransactionId);

        //设置回溯时间
        String backtrackDate = this.getBacktrackDate(config, one, monitorRule, config.getDirectExecution());
        config.setBacktrackDate(backtrackDate);

        if(Objects.equals(monitorRule.getCategory(),MonitorRuleCategoryEnum.SQL_SCRIPT.toString())) {
            // 调用esp接口，获取租户的产品信息
            List<String> tenantProductList = handleEspTenantProduct(tenantId);
            // 根据产品信息判断稳态或敏态，更新script
            String script = handleScript(config.getMonitorRuleId(),config.getProductName(),tenantProductList,tenantVersion);
            if (StringUtils.isNotEmpty(script)) {
                update.set("script",script);
            }
        }

        try {
            UpdateResult re = this.mongoTemplate.upsert(query, update, MonitorRuleTenantConfig.class);
            if (monitorRule.isDataCheck()) { // 当是数据比對，不需要通知sd創建排程，直接返回
                Map<String, String> result = new HashMap<>();
                result.put("transactionId", curTransactionId);
                result.put("sendMessage", null);
                result.put("category", monitorRule.getCategory());

                return result;
            }
            if (re.getUpsertedId() == null || re.getUpsertedId().isNull()) {//非insert
                //修改侦测
                if (config.getStatus() != null) {
                    //修改侦测可以同时带启用禁用状态
                    if (config.getStatus() == 1) {
                        sendMessage = this.sendMessage(config.getTenantId(), config.getMonitorRuleId(), config.getEocMap(), ConfigChangeTypeEnum.MODIFIED, true, config.getBacktrackDate(), config.getSendWay(), curTransactionId);//增加回溯时间
                    } else if (config.getStatus() == 0) {
                        sendMessage = this.sendMessage(config.getTenantId(), config.getMonitorRuleId(), config.getEocMap(), ConfigChangeTypeEnum.MODIFIED, false, config.getBacktrackDate(), config.getSendWay(), curTransactionId);
                    }
                } else {
                    if (one != null && one.getStatus() == 1) {
                        sendMessage = this.sendMessage(config.getTenantId(), config.getMonitorRuleId(), config.getEocMap(), ConfigChangeTypeEnum.MODIFIED, true, config.getBacktrackDate(), config.getSendWay(), curTransactionId);//增加回溯时间
                    }
                }
            } else {//insert 新建状态的侦测直接是启用状态
//                if(StringUtils.isEmpty(config.getBacktrackDate())){ //当报文中的回溯时间为空的时候，检查下侦测定义中是否设置回溯时间
//                    MonitorRule monitorRule = this.monitorRuleManager.queryMonitorRule(config.getMonitorRuleId(), tenantId, tenantVersion);
//                    config.setBacktrackDate(monitorRule.getBacktrackDate());
//                }
                //创建侦测的时候，如果status是未生效，则创建一个未开启的侦测
                sendMessage = this.sendMessage(config.getTenantId(), config.getMonitorRuleId(), config.getEocMap(), ConfigChangeTypeEnum.CREATED, 0 == config.getStatus() ? false : true,
                        config.getBacktrackDate(), config.getSendWay(), curTransactionId);//增加回溯时间
                //判断立即执行的 flag && status 0 发MQ modify + false
                // 立即执行不用额外调用一下modify，直接通过create的时候传递状态
//                if (config.getDirectExecution() != null && config.getDirectExecution()) {
//                    if (config.getStatus() != null && config.getStatus() == 0) {
//                        sendMessage = this.sendMessage(config.getTenantId(), config.getMonitorRuleId(), config.getEocMap(), ConfigChangeTypeEnum.MODIFIED, false, config.getSendWay(), curTransactionId);
//                    }
//                }
            }

        } catch (Exception e) {
            throw new DWBusinessException("P.KG.500.0032", e.getLocalizedMessage());
        }
        // return DWServiceResultBuilder.build(true, null);

        this.recordPreMonitorRuleTenantConfig(curTransactionId, config.getSendWay(), sendMessage, false, one, config.getMonitorRuleId());

        Map<String, String> result = new HashMap<>();
        result.put("transactionId", curTransactionId);
        result.put("sendMessage", sendMessage);
        result.put("category", monitorRule.getCategory());

        return result;
    }

    //
    private String getBacktrackDate(MonitorRuleConfigDTO config, MonitorRuleTenantConfig tenantConfig, MonitorRule monitorRule, Boolean directExecution){
        if(StringUtils.isNotEmpty(config.getBacktrackDate())){
            return config.getBacktrackDate();
        }
        if(monitorRule == null){
            return null;
        }
        if(Boolean.TRUE.equals(monitorRule.getBacktrackDateEqualsStartTime())){ //回溯时间需要和开始时间关联
            String newStartTime = this.getStartTime(config.getStandardPollingRule(), config.getStandardPollingRules());
            String oldStartTime = null;
            if (tenantConfig != null) {
                oldStartTime = this.getStartTime(tenantConfig.getStandardPollingRule(), tenantConfig.getStandardPollingRules());
            }
            if(null == newStartTime || newStartTime.isEmpty()){
                return null;
            }
            if(null == oldStartTime || oldStartTime.isEmpty()){
                String newStartDate = newStartTime.split(" ")[0];
                return newStartDate + " 00:00:00";
            }
            if(tenantConfig != null && tenantConfig.getStatus() == 1 && config.getStatus() == 0){ //开改为关的时候，回溯时间不变
                return null;
            }
            String newStartDate = newStartTime.split(" ")[0];
            String oldStartDate = oldStartTime.split(" ")[0];
            if(StringUtils.equals(newStartDate,oldStartDate)){  //没修改过侦测开始时间
                return null;
            }else{
                return newStartDate + " 00:00:00";
            }


        }else{
            if(tenantConfig == null && StringUtils.isNotEmpty(monitorRule.getBacktrackDate())){
                return monitorRule.getBacktrackDate();
            }
        }
        return null;
    }

    private String getStartTime(Object standardPollingRule, Object standardPollingRules){
        List<TriggerDTO> triggerDTOS = null;
        TriggerDTO triggerDTO = null;
        if(standardPollingRules != null){
            triggerDTOS = JSON.parseArray(JSON.toJSONString(standardPollingRules), TriggerDTO.class);
        }
        if(standardPollingRule != null){
            triggerDTO = JSON.parseObject(JSON.toJSONString(standardPollingRule), TriggerDTO.class);
        }
        return getStartTime(triggerDTO, triggerDTOS);
    }

    private String getStartTime(TriggerDTO standardPollingRule, List<TriggerDTO> standardPollingRules){
        if(null == standardPollingRules || standardPollingRules.isEmpty()){
            return standardPollingRule == null ? null : standardPollingRule.getStart_time();
        }else{
          return  standardPollingRules.get(0).getStart_time();
        }
    }

    private boolean checkStandardPollingRuleHasChange(MonitorRuleTenantConfig tenantConfig, MonitorRuleConfigDTO configDTO){
        TriggerDTO standardPollingRule = configDTO.getStandardPollingRule();
        if(standardPollingRule != null){
            Object tenantConfigStandardPollingRule = tenantConfig.getStandardPollingRule();
            if(tenantConfigStandardPollingRule == null){
                return true;
            }
            String s = JSON.toJSONString(tenantConfigStandardPollingRule);
            String s1 = JSON.toJSONString(standardPollingRule);
            if(!StringUtils.equals(s, s1)){
                return true;
            }
        }
        List<TriggerDTO> standardPollingRules = configDTO.getStandardPollingRules();
        if(!CollectionUtils.isEmpty(standardPollingRules)){
            Object standardPollingRules1 = tenantConfig.getStandardPollingRules();
            if(standardPollingRules1 == null){
                return true;
            }
            String s = JSON.toJSONString(standardPollingRules);
            String s1 = JSON.toJSONString(standardPollingRules1);
            if(!StringUtils.equals(s, s1)){
                return true;
            }
        }
        return false;
    }

    private void handleEocHighToLow(MonitorRuleConfigDTO config, Map<String, String> oldEocMap) throws Exception{
        if(oldEocMap == null){
            return;
        }
        //判断产品表的eocLevel是否和最新运营单元层级一致,如果不一致则需要报错
        boolean check = this.validateEocLevel(config.getMonitorRuleId(), config.getProductName(), config.getEocMap());
        if (!check) {
            throw new DWBusinessException(I18nUtils.getValue("knowledgegraph.ruleError")+config.getMonitorRuleId());
        }
        //根据原先层级的运营单元，进行数据的更新操作
        Query query = new Query();
        Criteria criteria1 = Criteria.where("tenantId").is(config.getTenantId()).and("monitorRuleId").is(config.getMonitorRuleId());
        OperationUnit operationUnit = this.operationUnitService.transToOperationUnit(oldEocMap);
        criteria1 = this.operationUnitService.addEocMapToCriteria(operationUnit, criteria1);
        query.addCriteria(criteria1);

        MonitorRuleTenantConfig monitorRuleTenantConfig = new MonitorRuleTenantConfig();
        monitorRuleTenantConfig.setTenantId(config.getTenantId());
        monitorRuleTenantConfig.setMonitorRuleId(config.getMonitorRuleId());
        monitorRuleTenantConfig.setProductName(config.getProductName());
        monitorRuleTenantConfig.setStandardPollingRule(config.getStandardPollingRule());
        monitorRuleTenantConfig.setStatus(config.getStatus() == null ? 1 : config.getStatus());
        monitorRuleTenantConfig.setEocMap(config.getEocMap());
        if(!ObjectUtils.isEmpty(config.getTenantDynamicCondition())) {
            monitorRuleTenantConfig.setDynamicCondition(JSON.parseObject(JSON.toJSONString(config.getTenantDynamicCondition()), TenantDynamicConditionDO.class));
        }

        this.mongoTemplate.remove(query, MonitorRuleTenantConfig.class);
        this.mongoTemplate.save(monitorRuleTenantConfig, "monitorRuleTenantConfig");

        //通知sd侦测降级
        this.postEocChangeFromHighToLow(config.getTenantId(), Arrays.asList(config.getMonitorRuleId()), oldEocMap, JSON.parseObject(JSON.toJSONString(config.getEocMap())));
    }

    private String handleCropToEoc(MonitorRuleConfigDTO config, String curTransactionId, String beforeEocLevel) throws Exception{
        //判断产品表的eocLevel是否和最新运营单元层级一致,如果不一致则需要报错
        boolean check = this.validateEocLevel(config.getMonitorRuleId(), config.getProductName(), config.getEocMap());
        if (!check) {
            throw new DWBusinessException(I18nUtils.getValue("knowledgegraph.ruleError")+config.getMonitorRuleId());
        }
        String eocLevel = this.operationUnitService.getEocLevel(this.operationUnitService.transToOperationUnit(config.getEocMap()));

        List<EocMapDTO> eocMapList = this.getEocMap(eocLevel, config.getTenantId(), config.getProductName(), beforeEocLevel, config.getEocMap());
        if(CollectionUtils.isEmpty(eocMapList)){
            log.info("====>租户："+config.getTenantId() + "产品：" + config.getProductName() + "没有从esp找到eoc的信息, 按传入的eoc信息进行降级操作");
            eocMapList = new ArrayList<>();
            EocMapDTO newEocMap = new EocMapDTO();
            if(config.getEocMap() != null){
                //去除入参中eocMap里的空值
                if(StringUtils.isNotEmpty(config.getEocMap().getEocCompanyId())){
                    newEocMap.setEocCompanyId(config.getEocMap().getEocCompanyId());
                }
                if(StringUtils.isNotEmpty(config.getEocMap().getEocSiteId())){
                    newEocMap.setEocSiteId(config.getEocMap().getEocSiteId());
                }
                if(StringUtils.isNotEmpty(config.getEocMap().getEocRegionId())){
                    newEocMap.setEocRegionId(config.getEocMap().getEocRegionId());
                }
            }
            eocMapList.add(newEocMap);  //
//            throw new DWBusinessException("租户："+config.getTenantId() + "产品：" + config.getProductName() + "没有从esp找到eoc的信息");
        }

        //根据原先层级的运营单元，进行数据的更新操作
        Query query = new Query();
        Criteria criteria1 = Criteria.where("tenantId").is(config.getTenantId()).and("monitorRuleId").is(config.getMonitorRuleId());
//        OperationUnit operationUnit = this.operationUnitService.transToOperationUnit(new HashMap<>()); //集团级
        OperationUnit operationUnit = new OperationUnit();
        if(StringUtils.equalsIgnoreCase("company", beforeEocLevel)){
            operationUnit.setEoc_company_id(config.getEocMap().getEocCompanyId());
        }
        criteria1 = this.operationUnitService.addEocMapToCriteria(operationUnit, criteria1);
        query.addCriteria(criteria1);

        List<MonitorRuleTenantConfig> monitorRuleTenantConfigList = new ArrayList<>();



        for(EocMapDTO eocMapDTO : eocMapList){
            MonitorRuleTenantConfig monitorRuleTenantConfig = new MonitorRuleTenantConfig();
            monitorRuleTenantConfig.setTenantId(config.getTenantId());
            monitorRuleTenantConfig.setMonitorRuleId(config.getMonitorRuleId());
            monitorRuleTenantConfig.setProductName(config.getProductName());
//            monitorRuleTenantConfig.setStandardPollingRule(config.getStandardPollingRule());
            if(CollectionUtils.isEmpty(config.getStandardPollingRules())){
                List<Object> standardPollingRules = new ArrayList<>();
                if(config.getStandardPollingRule() != null){
                    standardPollingRules.add(config.getStandardPollingRule());
                }
                monitorRuleTenantConfig.setStandardPollingRules(standardPollingRules);
            }else{
                monitorRuleTenantConfig.setStandardPollingRules(config.getStandardPollingRules());
            }

            monitorRuleTenantConfig.setStatus(config.getStatus() == null ? 1 : config.getStatus());
            monitorRuleTenantConfig.setEocMap(eocMapDTO);
            if(!ObjectUtils.isEmpty(config.getTenantDynamicCondition())) {
                monitorRuleTenantConfig.setDynamicCondition(JSON.parseObject(JSON.toJSONString(config.getTenantDynamicCondition()), TenantDynamicConditionDO.class));
            }
            monitorRuleTenantConfig.setTransactionId(curTransactionId);
            monitorRuleTenantConfigList.add(monitorRuleTenantConfig);
        }

        MonitorRuleTenantConfig preTenantConfig = this.mongoTemplate.findOne(query, MonitorRuleTenantConfig.class, "monitorRuleTenantConfig");


        this.mongoTemplate.remove(query, MonitorRuleTenantConfig.class);
        this.mongoTemplate.insert(monitorRuleTenantConfigList, "monitorRuleTenantConfig");

        //通知sd侦测从集团级降级为运营单元层级
//        Object o = this.postEocChangeFromTenant(config.getTenantId(), config.getSendWay(), Arrays.asList(config.getMonitorRuleId()));
//        List<String> sendMessageList = (List<String>) o;

        String sendMessage = this.postEocChange(config.getTenantId(), config.getSendWay(), config.getMonitorRuleId(), beforeEocLevel, eocMapList);

        this.recordPreMonitorRuleTenantConfig(curTransactionId, config.getSendWay(), sendMessage, true, preTenantConfig, config.getMonitorRuleId());

        return sendMessage;
    }

    public void recordPreMonitorRuleTenantConfig(String curTransactionId, String sendWay, String sendMessage, Boolean crossLevel, MonitorRuleTenantConfig tenantConfig, String ruleId){
        MonitorRuleSyncRecord monitorRuleSyncRecord = new MonitorRuleSyncRecord();
        monitorRuleSyncRecord.setTransactionId(curTransactionId);
        monitorRuleSyncRecord.setType(StringUtils.equalsIgnoreCase("HTTP", sendWay) ? "HTTP" : "MQ");
        monitorRuleSyncRecord.setRuleId(ruleId);
        monitorRuleSyncRecord.setTenantId(tenantConfig == null ? null : tenantConfig.getTenantId());
        monitorRuleSyncRecord.setEocMap(tenantConfig == null ? null : tenantConfig.getEocMap());
        monitorRuleSyncRecord.setCrossLevel(crossLevel);
        monitorRuleSyncRecord.setPreTenantConfig(tenantConfig);
        monitorRuleSyncRecord.setSendMessage(sendMessage);
        monitorRuleSyncRecord.setCreateDate(new Date());
        monitorRuleSyncRecord.setErrorTimes(0);
        monitorRuleSyncRecord.setPreTransactionId(tenantConfig == null ? "" : tenantConfig.getTransactionId());

        this.mongoTemplate.insert(monitorRuleSyncRecord, "monitorRuleSyncRecord");

    }

    public List<EocMapDTO> getEocMapWithOutProduct(String eocLevel, String tenantId, String token) throws Exception{
        List<EocMapDTO> eocMapDTOList = new ArrayList<>();
        try {
            //这边换成和交付设计器首页上获取公司工厂同样的方法;
            //这边不用通过稳态产品查到对应的eoc信息；eoc是云端的
            Map operationUnitWithToken = this.eocService.getOperationUnitWithToken(token);
            log.info("operationUnitWithToken:{}" + operationUnitWithToken);
            if(operationUnitWithToken != null){

                    if(StringUtils.equals(eocLevel, "company")){
                        List<Map> companies = (List<Map>) operationUnitWithToken.get("companies");
                        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(companies)) {
                            for (Map i : companies) {
                                if(null != i.get("id")){
                                    EocMapDTO eocMapDTO = new EocMapDTO();
                                    eocMapDTO.setEocCompanyId(String.valueOf(i.get("id")));
                                    eocMapDTOList.add(eocMapDTO);
                                }

                            }
                        }
                    }else if(StringUtils.equals(eocLevel, "site")){
                        List<Map> factories = (List<Map>) operationUnitWithToken.get("factories");
                        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(factories)) {
                            for (Map i : factories) {
                                if(null != i.get("companyId") && null != i.get("id")){
                                    EocMapDTO eocMapDTO = new EocMapDTO();
                                    eocMapDTO.setEocCompanyId((String) i.get("companyId"));
                                    eocMapDTO.setEocSiteId((String) i.get("id"));
                                    eocMapDTOList.add(eocMapDTO);
                                }

                            }
                        }
                    }
            }
        } catch (Exception e) {
            log.error(e.getMessage(), e);
        }

        return eocMapDTOList;
    }

    public EocMapDTO getRootEocMapWithOutProductV2(String token) throws Exception {
        JSONObject operationUnitTree = eocUtils.getOperationUnitTree(token);
        if (operationUnitTree == null || operationUnitTree.get("id") == null) {
            return null;
        }
        EocMapDTO eocMapDTO = new EocMapDTO();
        OperationUnitV2 operationUnitV2 = new OperationUnitV2();
        operationUnitV2.setEoc_mapping_id(operationUnitTree.getString("id"));
        eocMapDTO.setOperation_unit_v2(operationUnitV2);
        return  eocMapDTO;
    }

    public List<EocMapDTO> getEocMap(String eocLevel, String tenantId, String productName) throws Exception{
        List<EocMapDTO> eocMapDTOList = new ArrayList<>();
        try {
            ProductOperationResult productEoc = this.productNameResolver.getProductEoc(tenantId);
            List<ProdEocMapping> prod_eoc_mapping = productEoc.getProd_eoc_mapping();
            if(!CollectionUtils.isEmpty(prod_eoc_mapping)){
                Optional<ProdEocMapping> any = prod_eoc_mapping.stream().filter(e -> StringUtils.equals(productName, e.getProd_name())).findAny();
                if(any.isPresent()){
                    ProdEocMapping prodEocMapping = any.get();
                    List<OrgTypeCompany> org_type_companyList = prodEocMapping.getOrg_type_company();
                    if(StringUtils.equals(eocLevel, "company")){
                        for(OrgTypeCompany orgTypeCompany : org_type_companyList){
                            EocMapDTO eocMapDTO = new EocMapDTO();
                            eocMapDTO.setEocCompanyId(orgTypeCompany.getEoc_company_id());
                            eocMapDTOList.add(eocMapDTO);
                        }
                    }else if(StringUtils.equals(eocLevel, "site")){
                        for(OrgTypeCompany orgTypeCompany : org_type_companyList){
                            String eoc_company_id = orgTypeCompany.getEoc_company_id();
                            List<OrgTypeSite> org_type_site = orgTypeCompany.getOrg_type_site();
                            for(OrgTypeSite orgTypeSite : org_type_site){
                                EocMapDTO eocMapDTO = new EocMapDTO();
                                eocMapDTO.setEocCompanyId(eoc_company_id);
                                eocMapDTO.setEocSiteId(orgTypeSite.getEoc_site_id());
                                eocMapDTOList.add(eocMapDTO);
                            }
                        }
                    }
                }
            }
        } catch (Exception e) {
            log.error(e.getMessage(), e);
        }

        return eocMapDTOList;
    }

    public List<EocMapDTO> getEocMap(String eocLevel, String tenantId, String productName, String beforeEocLevel, EocMapDTO eocMap) throws Exception{
        List<EocMapDTO> eocMapDTOList = new ArrayList<>();
        try {
            ProductOperationResult productEoc = this.productNameResolver.getProductEoc(tenantId);
            List<ProdEocMapping> prod_eoc_mapping = productEoc.getProd_eoc_mapping();
            if(!CollectionUtils.isEmpty(prod_eoc_mapping)){
                Optional<ProdEocMapping> any = prod_eoc_mapping.stream().filter(e -> StringUtils.equals(productName, e.getProd_name())).findAny();
                if(any.isPresent()){
                    ProdEocMapping prodEocMapping = any.get();
                    List<OrgTypeCompany> org_type_companyList = prodEocMapping.getOrg_type_company();
                    if(StringUtils.equals(eocLevel, "company")){
                        for(OrgTypeCompany orgTypeCompany : org_type_companyList){
                            EocMapDTO eocMapDTO = new EocMapDTO();
                            eocMapDTO.setEocCompanyId(orgTypeCompany.getEoc_company_id());
                            eocMapDTOList.add(eocMapDTO);
                        }
                    }else if(StringUtils.equals(eocLevel, "site")){
                        for(OrgTypeCompany orgTypeCompany : org_type_companyList){
                            String eoc_company_id = orgTypeCompany.getEoc_company_id();
                            if(StringUtils.equalsIgnoreCase(beforeEocLevel, "company") && !StringUtils.equals(eoc_company_id,eocMap.getEocCompanyId())){
                                //如果是从公司级升级来的，查看下当前公司级下面所有的工厂信息
                                continue;
                            }
                            List<OrgTypeSite> org_type_site = orgTypeCompany.getOrg_type_site();
                            for(OrgTypeSite orgTypeSite : org_type_site){
                                EocMapDTO eocMapDTO = new EocMapDTO();
                                eocMapDTO.setEocCompanyId(eoc_company_id);
                                eocMapDTO.setEocSiteId(orgTypeSite.getEoc_site_id());
                                eocMapDTOList.add(eocMapDTO);
                            }
                        }
                    }
                }
            }
        } catch (Exception e) {
            log.error(e.getMessage(), e);
        }

        return eocMapDTOList;
    }

    private boolean checkIsCropToEoc(MonitorRuleConfigDTO config) throws DWBusinessException{
        Query query = new Query();
        Criteria criteria1 = Criteria.where("tenantId").is(config.getTenantId());
        Criteria criteria2 = Criteria.where("monitorRuleId").is(config.getMonitorRuleId());
        Criteria criteria = new Criteria().andOperator(criteria1, criteria2);
        query.addCriteria(criteria);
        List<MonitorRuleTenantConfig> tenantConfigList = this.mongoTemplate.find(query, MonitorRuleTenantConfig.class);
        if(CollectionUtils.isEmpty(tenantConfigList)){
            return false;
        }
        if(this.checkIsCorpLevel(config.getEocMap())){
            //最新的是集团级，则如果有其他层级，则需报错？
            Optional<MonitorRuleTenantConfig> any = tenantConfigList.stream().filter(e ->
                    this.checkIsCompanyLevel(e.getEocMap()) || this.checkIsSiteLevel(e.getEocMap()) || this.checkIsRegionLevel(e.getEocMap()))
                    .findAny();
            if(any.isPresent()){
                throw new DWBusinessException(I18nUtils.getValue("knowledgegraph.canNotUpdateError",config.getTenantId(),config.getMonitorRuleId()));
            }
        }else{
            //如果最新的是公司或者工厂级，则查看下原来是不是集团级的侦测
            boolean allMatch = tenantConfigList.stream().allMatch(e -> this.checkIsCorpLevel(e.getEocMap()));
            if(allMatch){
                return true;
            }else{
                String eocLevel = this.operationUnitService.getEocLevel(this.operationUnitService.transToOperationUnit(config.getEocMap()));
                Optional<MonitorRuleTenantConfig> any = tenantConfigList.stream().filter(e ->
                        (StringUtils.equals(eocLevel, "company") && this.checkIsSiteLevel(e.getEocMap()))
                || (StringUtils.equals(eocLevel, "site") && this.checkIsCompanyLevel(e.getEocMap())))
                        .findAny();
                if(any.isPresent()){
                    throw new DWBusinessException(I18nUtils.getValue("knowledgegraph.dataNotConsistent",config.getTenantId(),config.getMonitorRuleId()));
                }
            }
        }
        return false;
    }

    /**
     *返回eoc变化前的层级，如果为null，表示层级没有变化
     */
    private String checkIsEocChange(MonitorRuleConfigDTO config) throws DWBusinessException{
        // 如果是V2版本则不需要考虑升降级
        if (iamUtils.isTenantOperationUnitV2()) {
            return null;
        }
        Query query = new Query();
        Criteria criteria1 = Criteria.where("tenantId").is(config.getTenantId());
        Criteria criteria2 = Criteria.where("monitorRuleId").is(config.getMonitorRuleId());
        Criteria criteria = new Criteria().andOperator(criteria1, criteria2);
        query.addCriteria(criteria);
        List<MonitorRuleTenantConfig> tenantConfigList = this.mongoTemplate.find(query, MonitorRuleTenantConfig.class);
        if(CollectionUtils.isEmpty(tenantConfigList)){
            return null;
        }
        if(this.checkIsCorpLevel(config.getEocMap())){
            //最新的是集团级，则如果有其他层级，则需报错？
            Optional<MonitorRuleTenantConfig> any = tenantConfigList.stream().filter(e ->
                    this.checkIsCompanyLevel(e.getEocMap()) || this.checkIsSiteLevel(e.getEocMap()) || this.checkIsRegionLevel(e.getEocMap()))
                    .findAny();
            if(any.isPresent()){
                throw new DWBusinessException("tenantId:"+config.getTenantId() + "侦测:" + config.getMonitorRuleId() + "原先为非集团级，无法升为集团级");
            }
        }else if(this.checkIsCompanyLevel(config.getEocMap())){
            //如果最新的是公司级
            boolean allMatch = tenantConfigList.stream().allMatch(e -> this.checkIsCorpLevel(e.getEocMap()));
            //如果原来的是集团级
            if(allMatch){
                return "crop"; //从集团级升级
            }
            //如果原来的是工厂级，报错
            boolean siteMatch = tenantConfigList.stream().filter(e -> StringUtils.equals(e.getEocMap().getEocCompanyId(), config.getEocMap().getEocCompanyId()))
                    .anyMatch(e -> this.checkIsSiteLevel(e.getEocMap()));
            if(siteMatch){
                throw new DWBusinessException("tenantId:"+config.getTenantId() + "侦测:" + config.getMonitorRuleId() + "无法从工厂级变为公司级");
            }

        }else if(this.checkIsSiteLevel(config.getEocMap())){ //如果最新的是工厂级
            boolean allMatch = tenantConfigList.stream().allMatch(e -> this.checkIsCorpLevel(e.getEocMap()));
            if(allMatch){
                return "crop"; //从集团级升级
            }
//            boolean companyMatch = tenantConfigList.stream().filter(e -> StringUtils.equals(e.getEocMap().getEocCompanyId(), config.getEocMap().getEocCompanyId()))
//                    .allMatch(e -> this.checkIsCompanyLevel(e.getEocMap()));
//            if(companyMatch){
//                return "company"; //从公司级升级
//            }
            //注意，一个空集合的allMatch返回true
            List<MonitorRuleTenantConfig> collect = tenantConfigList.stream().filter(e -> StringUtils.equals(e.getEocMap().getEocCompanyId(), config.getEocMap().getEocCompanyId()))
                    .collect(Collectors.toList());
            if(!CollectionUtils.isEmpty(collect)){
                boolean b = collect.stream().allMatch(e -> this.checkIsCompanyLevel(e.getEocMap()));
                if(b){
                    return "company"; //从公司级升级
                }
            }
        }
        return null;
    }
    /**
     * 检查运营单元是否从高到低，如果是的话，返回原来高层级的运营单元，否则返回null
     */
    private Map checkIsEocHighToLow(MonitorRuleConfigDTO config) throws DWBusinessException{
        Query query = new Query();
        Criteria criteria1 = Criteria.where("tenantId").is(config.getTenantId());
        Criteria criteria2 = Criteria.where("monitorRuleId").is(config.getMonitorRuleId());
        Criteria criteria = new Criteria().andOperator(criteria1, criteria2);
        query.addCriteria(criteria);
        List<MonitorRuleTenantConfig> tenantConfigList = this.mongoTemplate.find(query, MonitorRuleTenantConfig.class);
        if(this.checkIsCorpLevel(config.getEocMap())){
            //最新的是集团级，则如果有其他层级，则需报错？
            Optional<MonitorRuleTenantConfig> any = tenantConfigList.stream().filter(e ->
                    this.checkIsCompanyLevel(e.getEocMap()) || this.checkIsSiteLevel(e.getEocMap()) || this.checkIsRegionLevel(e.getEocMap()))
                    .findAny();
            if(any.isPresent()){
                throw new DWBusinessException("tenantId:"+config.getTenantId() + "侦测:" + config.getMonitorRuleId() + "非集团级数据");
            }
        }else if(this.checkIsCompanyLevel(config.getEocMap())){
            //如果最新的是公司级，则查看下原来是不是集团级的侦测
            Optional<MonitorRuleTenantConfig> any = tenantConfigList.stream().filter(e ->
                    this.checkIsCorpLevel(e.getEocMap()))
                    .findAny();
            if(any.isPresent()){
                return new HashMap();
            }
        }else if(this.checkIsSiteLevel(config.getEocMap())){
            //如果最新的是工厂级，则查看下原来是不是含有对应的公司级或者集团级
            Optional<MonitorRuleTenantConfig> any = tenantConfigList.stream().filter(e ->
                    this.checkIsCompanyLevel(e.getEocMap()) && StringUtils.equals(e.getEocMap().getEocCompanyId(), config.getEocMap().getEocCompanyId()))
                    .findAny();
            if(any.isPresent()){
                return JSON.parseObject(JSON.toJSONString(any.get().getEocMap()));
            }else{
                Optional<MonitorRuleTenantConfig> anyCorp = tenantConfigList.stream().filter(e ->
                        this.checkIsCorpLevel(e.getEocMap()))
                        .findAny();
                if(anyCorp.isPresent()){
                    return new HashMap();
                }
            }
        }
        return null;
    }

    private boolean checkIsCorpLevel(EocMapDTO eocMap){
        return eocMap == null || (StringUtils.isEmpty(eocMap.getEocCompanyId())
                && StringUtils.isEmpty(eocMap.getEocSiteId())&& StringUtils.isEmpty(eocMap.getEocRegionId()));
    }

    private boolean checkIsCompanyLevel(EocMapDTO eocMap){
        return eocMap != null && StringUtils.isNotEmpty(eocMap.getEocCompanyId())
                && StringUtils.isEmpty(eocMap.getEocSiteId())&& StringUtils.isEmpty(eocMap.getEocRegionId());
    }

    private boolean checkIsSiteLevel(EocMapDTO eocMap){
        return eocMap != null && StringUtils.isNotEmpty(eocMap.getEocCompanyId())
                && StringUtils.isNotEmpty(eocMap.getEocSiteId()) && StringUtils.isEmpty(eocMap.getEocRegionId());
    }

    private boolean checkIsRegionLevel(EocMapDTO eocMap){
        return eocMap != null && StringUtils.isNotEmpty(eocMap.getEocCompanyId())
                && StringUtils.isNotEmpty(eocMap.getEocSiteId()) && StringUtils.isNotEmpty(eocMap.getEocRegionId());
    }

    @Override
    public Object putEnable(String tenantId, String ruleId) throws Exception {
//        MongoCollection<Document> col = MongoDBManager.getMongoDBManager().getCollection(monitorRuleConfigColName, monitorRuleConfigKeyName);
//        col.updateOne(eq(monitorRuleConfigKeyName, configId), Updates.set("status", 1));
//
//        Document doc = this.get(configId);
//        if (doc != null) {
//            SendMessage((String) doc.get("tenantId"), (String) doc.get("ruleId"), ConfigChangeTypeEnum.ENABLED);
//        }
        this.sendMessage(tenantId, ruleId, ConfigChangeTypeEnum.ENABLED);

        //return DWServiceResultBuilder.build(true, null);
        return null;
    }

    @Override
    public Object putDisable(String tenantId, String ruleId) throws Exception {
        log.info("停用侦测，tenantId："+tenantId+"，ruleId：{}"+ ruleId);
//        MongoCollection<Document> col = MongoDBManager.getMongoDBManager().getCollection(monitorRuleConfigColName, monitorRuleConfigKeyName);
//        col.updateOne(eq(monitorRuleConfigKeyName, configId), Updates.set("status", 0));
//
//        Document doc = this.get(configId);
//        if (doc != null) {
//            SendMessage((String) doc.get("tenantId"), (String) doc.get("ruleId"), ConfigChangeTypeEnum.DISABLED);
//        }
        this.sendMessage(tenantId, ruleId, ConfigChangeTypeEnum.DISABLED);

        //return DWServiceResultBuilder.build(true, null);
        return null;
    }
    @Override
    public Object putEnable(String tenantId, String ruleId, EocMapDTO eocMap) throws Exception {
        //按逻辑 一个租户只有一个稳态产品 所以不加产品条件
        Query query = new Query();
        Criteria criteria1 = Criteria.where("tenantId").is(tenantId);
        Criteria criteria2 = Criteria.where("monitorRuleId").is(ruleId);
        Criteria criteria = new Criteria().andOperator(criteria1, criteria2);
        if (eocMap != null) {
            criteria = addOperationUnitCondition(criteria, eocMap);
        }
        query.addCriteria(criteria);
        Update update = new Update();
        update.set("status", 1);//更新状态
        try {
            this.mongoTemplate.updateMulti(query, update, MonitorRuleTenantConfig.class);
            this.sendMessage(tenantId, ruleId, eocMap, ConfigChangeTypeEnum.ENABLED);
        } catch (Exception e) {
            throw new DWBusinessException(e.getLocalizedMessage());
        }
        return null;
    }

    @Override
    public Object putDisable(String tenantId, String ruleId, EocMapDTO eocMap) throws Exception {
        //按逻辑 一个租户只有一个稳态产品 所以不加产品条件
        Query query = new Query();
        Criteria criteria1 = Criteria.where("tenantId").is(tenantId);
        Criteria criteria2 = Criteria.where("monitorRuleId").is(ruleId);
        Criteria criteria = new Criteria().andOperator(criteria1, criteria2);
        if (eocMap != null) {
            criteria = addOperationUnitCondition(criteria, eocMap);
        }
        query.addCriteria(criteria);
        Update update = new Update();
        update.set("status", 0);//更新状态
        try {
            this.mongoTemplate.updateMulti(query, update, MonitorRuleTenantConfig.class);
            this.sendMessage(tenantId, ruleId, eocMap, ConfigChangeTypeEnum.DISABLED);
        } catch (Exception e) {
            throw new DWBusinessException(e.getLocalizedMessage());
        }
        return null;
    }

    /**
     * 添加操作运营单元条件
     * @param criteria 查询条件
     * @param eocMap 运营单元
     */
    private Criteria addOperationUnitCondition(Criteria criteria, EocMapDTO eocMap) throws DWBusinessException {
        Criteria c = null;
        if (StringUtils.isNotEmpty(eocMap.getEocCompanyId())) {
            c = Criteria.where("eocMap.eocCompanyId").is(eocMap.getEocCompanyId());
        }
        if (StringUtils.isNotEmpty(eocMap.getEocSiteId())) {
            if (c == null) {
                c = Criteria.where("eocMap.eocSiteId").is(eocMap.getEocSiteId());
            } else {
                c = new Criteria().andOperator(c, Criteria.where("eocMap.eocSiteId").is(eocMap.getEocSiteId()));
            }
        }
        if (StringUtils.isNotEmpty(eocMap.getEocRegionId())) {
            if (c == null) {
                c = Criteria.where("eocMap.eocRegionId").is(eocMap.getEocRegionId());
            } else {
                c = new Criteria().andOperator(c, Criteria.where("eocMap.eocRegionId").is(eocMap.getEocRegionId()));
            }
        }
        if (iamUtils.isTenantOperationUnitV2()) {
            if (c == null) {
                c = Criteria.where("eocMap.operation_unit_v2.eoc_mapping_id").is(eocMap.getOperation_unit_v2().getEoc_mapping_id());
            } else {
                c = new Criteria().andOperator(c, Criteria.where("eocMap.operation_unit_v2.eoc_mapping_id").is(eocMap.getOperation_unit_v2().getEoc_mapping_id()));
            }
        }
        if (c != null) {
            return new Criteria().andOperator(criteria, c);
        }
        return criteria;
    }

    @Override
    public Object postNotice(MonitorRuleConfigDTO config) throws Exception{
        String tenantId = config.getTenantId();
        String ruleId = config.getMonitorRuleId();
        ConfigChangeTypeEnum configChangeTypeEnum = ConfigChangeTypeEnum.valueOf(config.getChangeType());
        if(configChangeTypeEnum == null || StringUtils.isEmpty(configChangeTypeEnum.toString())){
            throw new DWBusinessException("changeType不正确");
        }
        this.sendMessage(tenantId, ruleId, config.getEocMap(), configChangeTypeEnum);
        return null;
    }

    @Override
    public Object getRuleCodeByMechanism(String mechanismCode) throws DWBusinessException {
        try {
            return this.monitorRuleRepository.getCodeByMechainismCode(mechanismCode);
        } catch (Exception e) {
            throw new DWBusinessException(e.getLocalizedMessage());
        }
    }

    @Override
    public Object postRuleCodeByMechanismWithEoc(String mechanismCode, OperationUnit operationUnit,String product) throws DWBusinessException {
        String tenantId = AthenaUtils.getTenantId();
        String tenantVersion = kgInnerService.getTenantVersion(tenantId);
        try {
            List<String> result = new ArrayList<>();
            List<String> codeByMechainismCode = this.monitorRuleRepository.getCodeByMechainismCode(mechanismCode, tenantVersion);
            if(!CollectionUtils.isEmpty(codeByMechainismCode)){
                for(String code : codeByMechainismCode){
                    Criteria criteria1 = Criteria.where("productName").is(product).and("monitorRuleId").is(code);
                    MonitorRuleProductConfig productConfig = dataPickService.findOneByCondition(criteria1, MonitorRuleProductConfig.class, "monitorRuleProductConfig");
                    if(productConfig != null) {
                        String eocLevel = productConfig.getEocLevel();
                        String eocLevel1 = this.operationUnitService.getEocLevel(operationUnit);
                        if ((StringUtils.isEmpty(eocLevel) && StringUtils.isEmpty(eocLevel1)) || StringUtils.equalsIgnoreCase(eocLevel, eocLevel1)) {
                            result.add(code);
                        }
                    }

                }
            }

            return result;
        } catch (Exception e) {
            throw new DWBusinessException(e.getLocalizedMessage());
        }
    }

    @Override
    public Object get(String tenantId, String ruleId) throws Exception {
        MonitorRuleTenantConfig re = null;
        Query query = new Query();
        Criteria criteria1 = Criteria.where("tenantId").is(tenantId);
        Criteria criteria2 = Criteria.where("monitorRuleId").is(ruleId);
        query.addCriteria(new Criteria().andOperator(criteria1, criteria2));
        try {
            re = this.mongoTemplate.findOne(query, MonitorRuleTenantConfig.class);
        } catch (Exception e) {
            throw new DWBusinessException(e.getLocalizedMessage());
        }
        return re;
    }

    public Object postEocChangeFromHighToLow(String tenantId, List<String> ruleIds, Map oldEocMap, Map eocMap) throws Exception {
        String tenantVersion = kgInnerService.getTenantVersion(tenantId);
        Query query = new Query();
        Criteria criteria = Criteria.where("tenantId").is(tenantId).and("monitorRuleId").in(ruleIds).and("status").is(1);
        criteria = this.operationUnitService.addEocMapToCriteria(this.operationUnitService.transToOperationUnit(eocMap), criteria);
        query.addCriteria(criteria);
        List<MonitorRuleTenantConfig> monitorRuleTenantConfigs = this.mongoTemplate.find(query, MonitorRuleTenantConfig.class);
        if(CollectionUtils.isEmpty(monitorRuleTenantConfigs)) {
            throw new DWBusinessException("未找到相关的的侦测配置, tenantId:" +tenantId);
        }
        Map<String, List<MonitorRuleTenantConfig>> groupedTenantConfig = monitorRuleTenantConfigs.stream().collect(Collectors.groupingBy(e -> e.getMonitorRuleId() + "#" + e.getProductName()));

        Criteria criteria2 = Criteria.where("monitorRuleId").in(ruleIds);
        List<MonitorRuleProductConfig> monitorRuleProductConfigs = dataPickService.find(criteria2, MonitorRuleProductConfig.class, "monitorRuleProductConfig");

        List<String> sendContentList = new ArrayList<>();
        for(Map.Entry<String, List<MonitorRuleTenantConfig>> entry : groupedTenantConfig.entrySet()){
            String key = entry.getKey();
            String[] keySplit = key.split("#");
            List<MonitorRuleTenantConfig> value = entry.getValue();
            //检查tenant中的eoc信息是否与product中的eocLevel匹配
            List<Map<String, Object>> newEocMapList = new ArrayList<>();
            Optional<MonitorRuleProductConfig> any = monitorRuleProductConfigs.stream().filter(e -> StringUtils.equals(e.getMonitorRuleId(), keySplit[0]) && StringUtils.equals(e.getProductName(), keySplit[1])).findAny();
            if(any.isPresent()){
                MonitorRuleProductConfig monitorRuleProductConfig = any.get();
                for(MonitorRuleTenantConfig tenantConfig : value){
                    Map<String, Object> newEocMap = new HashMap<>();
                    if(this.checkEoc(monitorRuleProductConfig.getEocLevel(), tenantConfig.getEocMap())){
                        if(StringUtils.isNotEmpty(tenantConfig.getEocMap().getEocCompanyId())){
                            newEocMap.put("eocCompanyId", tenantConfig.getEocMap().getEocCompanyId());
                        }
                        if(StringUtils.isNotEmpty(tenantConfig.getEocMap().getEocSiteId())){
                            newEocMap.put("eocSiteId", tenantConfig.getEocMap().getEocSiteId());
                        }
                        if(StringUtils.isNotEmpty(tenantConfig.getEocMap().getEocRegionId())){
                            newEocMap.put("eocRegionId", tenantConfig.getEocMap().getEocRegionId());
                        }
                        if(iamUtils.isTenantOperationUnitV2()){
                            newEocMap.put("operation_unit_v2", tenantConfig.getEocMap().getOperation_unit_v2());
                        }
                        newEocMapList.add(newEocMap);
                    }else{
                        throw new DWBusinessException("产品级的eocLevel与租户级的eocMap不匹配,请修改正确后重试, monitorRuleId:" +keySplit[0] + " ,productName:" + keySplit[1] + " ,tenantId:" + tenantId);
                    }
                }
                sendContentList.add(this.generateSendContent(keySplit[0], tenantId, oldEocMap == null ? new HashMap<>() : oldEocMap, newEocMapList));
            }else{
                throw new DWBusinessException("未在侦测产品表MonitorRuleProductConfig找到数据, monitorRuleId:" +keySplit[0] + " productName:" + keySplit[1]);
            }
        }

        for(String str : sendContentList){
            //发送到队列
            this.sendMessage(str, monitorCrossLevelRoutingKey);
        }

        return "success";
    }

    public String postEocChange(String tenantId, String sendWay, String ruleId, String beforeEocLevel, List<EocMapDTO> eocMapList) throws Exception {
        List<Map<String, Object>> newEocMapList = new ArrayList<>();
        for(EocMapDTO eocMapDTO : eocMapList){
            Map<String, Object> newEocMap = new HashMap<>();
            if(StringUtils.isNotEmpty(eocMapDTO.getEocCompanyId())){
                newEocMap.put("eocCompanyId", eocMapDTO.getEocCompanyId());
            }
            if(StringUtils.isNotEmpty(eocMapDTO.getEocSiteId())){
                newEocMap.put("eocSiteId", eocMapDTO.getEocSiteId());
            }
            if(StringUtils.isNotEmpty(eocMapDTO.getEocRegionId())){
                newEocMap.put("eocRegionId", eocMapDTO.getEocRegionId());
            }
            if(iamUtils.isTenantOperationUnitV2()){
                newEocMap.put("operation_unit_v2", eocMapDTO.getOperation_unit_v2());
            }
            newEocMapList.add(newEocMap);
        }
        Map<String, Object> oldEocMap = new HashMap<>();
        if(StringUtils.equalsIgnoreCase("company", beforeEocLevel)){
            oldEocMap.put("eocCompanyId", eocMapList.get(0).getEocCompanyId());
        }
        String sendContent = this.generateSendContent(ruleId, tenantId, oldEocMap, newEocMapList);

        if(StringUtils.equalsIgnoreCase(sendWay, "HTTP")) { //http时，返回http的请求报文
            return sendContent;
        }else{ // 非HTTP时,默认都为MQ
                //发送到队列
            this.sendMessage(sendContent, monitorCrossLevelRoutingKey);
            return sendContent;
        }
    }

    public Object postEocChangeFromTenant(String tenantId, String sendWay, List<String> ruleIds) throws Exception {
        String tenantVersion = kgInnerService.getTenantVersion(tenantId);
        Query query = new Query();
        Criteria criteria = Criteria.where("tenantId").is(tenantId).and("monitorRuleId").in(ruleIds).and("status").is(1);
        query.addCriteria(criteria);
        List<MonitorRuleTenantConfig> monitorRuleTenantConfigs = this.mongoTemplate.find(query, MonitorRuleTenantConfig.class);
        if(CollectionUtils.isEmpty(monitorRuleTenantConfigs)) {
            throw new DWBusinessException("未找到相关的的侦测配置, tenantId:" +tenantId);
        }
        Map<String, List<MonitorRuleTenantConfig>> groupedTenantConfig = monitorRuleTenantConfigs.stream().collect(Collectors.groupingBy(e -> e.getMonitorRuleId() + "#" + e.getProductName()));

        Criteria criteria2 = Criteria.where("monitorRuleId").in(ruleIds);
        List<MonitorRuleProductConfig> monitorRuleProductConfigs = dataPickService.find(criteria2, MonitorRuleProductConfig.class, "monitorRuleProductConfig");


        List<String> sendContentList = new ArrayList<>();
        for(Map.Entry<String, List<MonitorRuleTenantConfig>> entry : groupedTenantConfig.entrySet()){
            String key = entry.getKey();
            String[] keySplit = key.split("#");
            List<MonitorRuleTenantConfig> value = entry.getValue();
            //检查tenant中的eoc信息是否与product中的eocLevel匹配
            List<Map<String, Object>> newEocMapList = new ArrayList<>();
            Optional<MonitorRuleProductConfig> any = monitorRuleProductConfigs.stream().filter(e -> StringUtils.equals(e.getMonitorRuleId(), keySplit[0]) && StringUtils.equals(e.getProductName(), keySplit[1])).findAny();
            if(any.isPresent()){
                MonitorRuleProductConfig monitorRuleProductConfig = any.get();
                for(MonitorRuleTenantConfig tenantConfig : value){
                    Map<String, Object> newEocMap = new HashMap<>();
                    if(this.checkEoc(monitorRuleProductConfig.getEocLevel(), tenantConfig.getEocMap())){
                        if(StringUtils.isNotEmpty(tenantConfig.getEocMap().getEocCompanyId())){
                            newEocMap.put("eocCompanyId", tenantConfig.getEocMap().getEocCompanyId());
                        }
                        if(StringUtils.isNotEmpty(tenantConfig.getEocMap().getEocSiteId())){
                            newEocMap.put("eocSiteId", tenantConfig.getEocMap().getEocSiteId());
                        }
                        if(StringUtils.isNotEmpty(tenantConfig.getEocMap().getEocRegionId())){
                            newEocMap.put("eocRegionId", tenantConfig.getEocMap().getEocRegionId());
                        }
                        if(iamUtils.isTenantOperationUnitV2()){
                            newEocMap.put("operation_unit_v2", tenantConfig.getEocMap().getOperation_unit_v2());
                        }
                        newEocMapList.add(newEocMap);
                    }else{
                        throw new DWBusinessException("产品级的eocLevel与租户级的eocMap不匹配,请修改正确后重试, monitorRuleId:" +keySplit[0] + " ,productName:" + keySplit[1] + " ,tenantId:" + tenantId);
                    }
                }
                sendContentList.add(this.generateSendContent(keySplit[0], tenantId, new HashMap<>(), newEocMapList));
            }else{
                throw new DWBusinessException("未在侦测产品表MonitorRuleProductConfig找到数据, monitorRuleId:" +keySplit[0] + " productName:" + keySplit[1]);
            }
        }

        if(StringUtils.equalsIgnoreCase(sendWay, "HTTP")) { //http时，返回http的请求报文
            return sendContentList;
        }else{ // 非HTTP时,默认都为MQ
            for (String str : sendContentList) {
                //发送到队列
                this.sendMessage(str, monitorCrossLevelRoutingKey);
            }
            return sendContentList;
        }

    }

    @Override
    public Object postEocChangeFromTenant(String tenantId, List<String> ruleIds) throws Exception {
        return this.postEocChangeFromTenant(tenantId, "MQ", ruleIds);
    }

    private boolean checkEoc(String eocLevel, EocMapDTO eocMap) throws Exception{
        if(StringUtils.isEmpty(eocLevel)){
            throw new DWBusinessException("MonitorRuleProductConfig eocLevel is null");
        }
        if(eocMap == null){
            throw new DWBusinessException("MonitorRuleTenantConfig eocMap is null");
        }
//        String[] split = eocLevel.split(",");
//        List<String> eocLevellist = Arrays.asList(split);
//        if(StringUtils.isNotEmpty(eocMap.getEocCompanyId()) && !eocLevellist.contains("company")){
//            return false;
//        }
//        if(StringUtils.isNotEmpty(eocMap.getEocSiteId()) && !eocLevellist.contains("site")){
//            return false;
//        }
//        if(StringUtils.isNotEmpty(eocMap.getEocRegionId()) && !eocLevellist.contains("region")){
//            return false;
//        }
        String level = null;
        if (StringUtils.isNotEmpty(eocMap.getEocRegionId()) &&
                StringUtils.isEmpty(eocMap.getEocCompanyId()) &&
                StringUtils.isEmpty(eocMap.getEocSiteId())) {
            level = "region";
        }
        if (StringUtils.isEmpty(eocMap.getEocRegionId()) &&
                StringUtils.isNotEmpty(eocMap.getEocCompanyId()) &&
                StringUtils.isNotEmpty(eocMap.getEocSiteId())) {
            level = "site";
        }
        if (StringUtils.isEmpty(eocMap.getEocRegionId()) &&
                StringUtils.isNotEmpty(eocMap.getEocCompanyId()) &&
                StringUtils.isEmpty(eocMap.getEocSiteId())) {
            level = "company";
        }
        if (StringUtils.isEmpty(level)) {
            throw new DWBusinessException("输入的运营单元值不合法，请核对");
        }
        return StringUtils.equals(level,eocLevel);
    }

    private String generateSendContent(String ruleId, String tenantId, Map<String, Object> oldEocMap, List<Map<String, Object>> newEocMap){
        JSONObject obj = new JSONObject();
        obj.put("ruleId", ruleId);
        obj.put("tenantId", tenantId);
        obj.put("eocMap", oldEocMap);
        obj.put("newEocList", newEocMap);
        return obj.toJSONString();
    }


    @Override
    public Object postEocChange(MonitorEocChangeVO monitorEocChange) throws Exception{
        //校验eocLevel和eocMap ？

        this.sendMessage(JSON.toJSONString(monitorEocChange), monitorCrossLevelRoutingKey);
        return "success";
    }

    //校验运营单元层级
    private boolean validateEocLevel(String ruleId, String productName, EocMapDTO eocMap) throws DWBusinessException {
        if (iamUtils.isTenantOperationUnitV2()) {
            // v2版本运营单元设置不了
            return true;
        }
        String level = null;
        if (StringUtils.isNotEmpty(eocMap.getEocRegionId()) &&
                StringUtils.isEmpty(eocMap.getEocCompanyId()) &&
                StringUtils.isEmpty(eocMap.getEocSiteId())) {
            level = "region";
        }
        if (StringUtils.isEmpty(eocMap.getEocRegionId()) &&
                StringUtils.isNotEmpty(eocMap.getEocCompanyId()) &&
                StringUtils.isNotEmpty(eocMap.getEocSiteId())) {
            level = "site";
        }
        if (StringUtils.isEmpty(eocMap.getEocRegionId()) &&
                StringUtils.isNotEmpty(eocMap.getEocCompanyId()) &&
                StringUtils.isEmpty(eocMap.getEocSiteId())) {
            level = "company";
        }
        if (StringUtils.isEmpty(level)) {
            throw new DWBusinessException("输入的运营单元值不合法，请核对");
        }

        Criteria criteria = Criteria.where("productName").is(productName)
                .and("monitorRuleId").is(ruleId)
                .and("eocLevel").is(level);
        MonitorRuleProductConfig config = dataPickService.findOneByCondition(criteria, MonitorRuleProductConfig.class, "monitorRuleProductConfig");
        return config != null;//按条件查找到数据 则校验通过
    }

    @Override
    public Object getProductNameByMonitorRule(String ruleId) throws Exception {
        List<String> names = new ArrayList<>();
        Criteria criteria = Criteria.where("monitorRuleId").is(ruleId);
        List<MonitorRuleProductConfig> configs = dataPickService.find(criteria, MonitorRuleProductConfig.class, "monitorRuleProductConfig");
        configs.forEach(r-> names.add(r.getProductName()));
        return names;
    }

    @Override
    public Object delete(MonitorRuleConfigDTO config) throws Exception {
        Query query = new Query();
        Criteria criteria1 = Criteria.where("tenantId").is(config.getTenantId());
        Criteria criteria2 = Criteria.where("monitorRuleId").is(config.getMonitorRuleId());
        Criteria criteria = new Criteria().andOperator(criteria1, criteria2);
//        EocMapDTO eocMap = config.getEocMap();
//        if (eocMap != null) {//删除不做运营单元校验
////            boolean check = this.validateEocLevel(config.getMonitorRuleId(), config.getProductName(), eocMap);
////            if (!check) {
////                throw new DWBusinessException("当前运营单元值与侦测所设定的运营单元层级不符，请修正ruleId:"+config.getMonitorRuleId());
////            }
//            Criteria c = null;
//            if (StringUtils.isNotEmpty(eocMap.getEocCompanyId())) {
//                c = Criteria.where("eocMap.eocCompanyId").is(eocMap.getEocCompanyId());
//            }
//            if (StringUtils.isNotEmpty(eocMap.getEocSiteId())) {
//                if (c == null) {
//                    c = Criteria.where("eocMap.eocSiteId").is(eocMap.getEocSiteId());
//                } else {
//                    c = new Criteria().andOperator(c, Criteria.where("eocMap.eocSiteId").is(eocMap.getEocSiteId()));
//                }
//            }
//            if (StringUtils.isNotEmpty(eocMap.getEocRegionId())) {
//                if (c == null) {
//                    c = Criteria.where("eocMap.eocRegionId").is(eocMap.getEocRegionId());
//                } else {
//                    c = new Criteria().andOperator(c, Criteria.where("eocMap.eocRegionId").is(eocMap.getEocRegionId()));
//                }
//            }
//            if (c != null) {
//                criteria = new Criteria().andOperator(criteria, c);
//            }
//        }
        criteria = this.operationUnitService.addEocMapToCriteria(this.operationUnitService.transToOperationUnit(config.getEocMap()), criteria);
        query.addCriteria(criteria);

        try {
            List<MonitorRuleTenantConfig> monitorRuleTenantConfigs = this.mongoTemplate.find(query, MonitorRuleTenantConfig.class);
            this.mongoTemplate.remove(query, MonitorRuleTenantConfig.class);

            for (MonitorRuleTenantConfig monitorRuleTenantConfig : monitorRuleTenantConfigs) {
                this.sendMessage(monitorRuleTenantConfig.getTenantId(), monitorRuleTenantConfig.getMonitorRuleId(), monitorRuleTenantConfig.getEocMap(), ConfigChangeTypeEnum.DELETED);
            }
        } catch (Exception e) {
            throw new DWBusinessException(e.getLocalizedMessage());
        }

        //   return DWServiceResultBuilder.build(true, null);
        return null;
    }

    @Override
    public Object getCheckExecutingAction(String ruleId) throws Exception {
        String tenantId = AthenaUtils.getTenantId();
        String tenantVersion = kgInnerService.getTenantVersion(tenantId);
        List<String> actionIds = new ArrayList<>();
        Query query = new Query();
        query.addCriteria(Criteria.where("monitorRuleId").is(ruleId).and("version").is(tenantVersion));

        try {
            MonitorRuleConfig config = this.mongoTemplateSystem.findOne(query, MonitorRuleConfig.class);
            if (config != null && !CollectionUtils.isEmpty(config.getCheckExecutingActionIds())) {
                actionIds = config.getCheckExecutingActionIds();
            }
        } catch (Exception e) {
            throw new DWBusinessException(e.getLocalizedMessage());
        }

        return actionIds;
    }

    @Override
    public  Object postFindMonitorRuleConfig(String tenantId, String ruleId, OperationUnit operationUnit, String product) throws Exception{
        String tenantVersion = kgInnerService.getTenantVersion(tenantId);
        List<MonitorRule> byCode = dataPickService.excludeWithSameCodeAndFilterTenant(this.monitorRuleRepository.findByCodeAndVersion(ruleId, tenantVersion));
        if (CollectionUtils.isEmpty(byCode)) {
            throw new DWBusinessException(String.format("Monitor rule %s not found", ruleId));
        }
        MonitorRuleDynamicParam monitorRuleDynamicParam = new MonitorRuleDynamicParam();


        Query query = new Query();
        Criteria criteria = Criteria.where("tenantId").is(tenantId).and("monitorRuleId").is(ruleId);
        criteria = this.operationUnitService.addEocMapToCriteria(operationUnit, criteria);
        query.addCriteria(criteria);
        MonitorRuleTenantConfig re = this.mongoTemplate.findOne(query, MonitorRuleTenantConfig.class);
        if(re != null){
            BeanUtils.copyProperties(re, monitorRuleDynamicParam);
        }

        String monitorProduct = re == null ? product : re.getProductName();

        MonitorRule monitorRule = byCode.get(0);
        String dynamicConditionFields = monitorRule.getDynamicConditionFields();
        String[] dynamicConditionFieldsSplit = null;
        if(StringUtils.isEmpty(dynamicConditionFields)){
            return monitorRuleDynamicParam;
        }else{
            dynamicConditionFieldsSplit = dynamicConditionFields.split(",");
        }
        Criteria criteria1 = Criteria.where("monitorRuleId").is(ruleId);
        List<MonitorRuleProductConfig> productConfigList = dataPickService.find(criteria1, MonitorRuleProductConfig.class, "monitorRuleProductConfig");
        if (CollectionUtils.isEmpty(productConfigList)) {
            throw new DWBusinessException(String.format("Monitor rule %s not found ProductConfig", ruleId));
        }
        MonitorRuleProductConfig productConfig = null;
//        if(StringUtils.isEmpty(product)){
        if(checkOnlyOneNonSteadyProductOnMonitorConfig(productConfigList)){
            productConfig = productConfigList.get(0);
        }else{
            Optional<MonitorRuleProductConfig> first = productConfigList.stream().filter(e -> StringUtils.equals(product, e.getProductName())).findFirst();
            if(first.isPresent()){
                productConfig = first.get();
            }
        }
        if(productConfig == null){
            throw new DWBusinessException(String.format("Monitor rule %s not found ProductConfig", ruleId));
        }
        List<FieldMappingConfigDO> dynamicfieldMappings = new ArrayList<>();
        List<FieldMappingConfigDO> fieldMappings = productConfig.getFieldMappings();
        if(!CollectionUtils.isEmpty(fieldMappings)){
            Map<String, FieldMappingConfigDO> collect = fieldMappings.stream().collect(Collectors.toMap(FieldMappingConfigDO::getField, e -> e, (a,b)->a));
            for (String returnFieldName : dynamicConditionFieldsSplit) {
                    if (collect.containsKey(returnFieldName)) {
                        dynamicfieldMappings.add(collect.get(returnFieldName));
                    }
            }
        }
        monitorRuleDynamicParam.setFieldMappings(dynamicfieldMappings);

        return monitorRuleDynamicParam;

    }

    @Override
    public  Object postFindMonitorRuleConfig(String tenantId, List<String> ruleIdList, OperationUnit operationUnit, String product) throws Exception{
        Map<String,Object> result = new HashMap<>();
        for(String ruleId : ruleIdList){
            Object obj= this.postFindMonitorRuleConfig(tenantId, ruleId, operationUnit, product);
            result.put(ruleId, obj);
        }
        return result;
    }

    private boolean checkOnlyOneNonSteadyProductOnMonitorConfig(List<MonitorRuleProductConfig> productConfigList) throws DWException {
        if(productConfigList.size() == 1){
            MonitorRuleProductConfig productConfig = productConfigList.get(0);
            Object steadyProduct = this.productService.getSteadyProduct(productConfig.getProductName());
            if(ObjectUtils.isEmpty(steadyProduct)){
                return true;
            }
        }
        return false;
    }

    @Override
    public Object getProductNamesByMonitorRuleList(List<String> ruleIdList) throws Exception{
        Map<String, List<String>> result = new HashMap<>();
        Query query = new Query();
        Criteria criteria = Criteria.where("monitorRuleId").in(ruleIdList);
        query.addCriteria(criteria);
        List<MonitorRuleProductConfig> configs = dataPickService.find(criteria, MonitorRuleProductConfig.class, "monitorRuleProductConfig");
        for(MonitorRuleProductConfig config : configs){
            List<String> o = result.get(config.getMonitorRuleId());
            if(o == null){
                o = new ArrayList<>();
            }
            o.add(config.getProductName());
            result.put(config.getMonitorRuleId(), o);
        }
        return result;
    }

    @Override
    public Object postReceiveMonitorRuleSyncResult(MonitorRuleSyncResult syncResult) throws Exception {
        log.info("ReceiveMonitorRuleSyncResult: " + JSON.toJSONString(syncResult));
        Query query = new Query();
        Criteria criteria = Criteria.where("transactionId").is(syncResult.getTransactionId());
        query.addCriteria(criteria);

        if(StringUtils.equalsIgnoreCase("success", syncResult.getResult())){  //如果成功，则直接把monitorRuleSyncRecord中的记录删除
            this.mongoTemplate.remove(query, "monitorRuleSyncRecord");
        }else{
            MonitorRuleSyncRecord monitorRuleSyncRecord = this.mongoTemplate.findOne(query, MonitorRuleSyncRecord.class, "monitorRuleSyncRecord");
            if(monitorRuleSyncRecord == null){
                return "success";
            }
            MonitorRuleTenantConfig monitorRuleTenantConfig = this.mongoTemplate.findOne(query, MonitorRuleTenantConfig.class, "monitorRuleTenantConfig");
            if(monitorRuleTenantConfig == null){  //说明有其他操作也修改过TenantConfig的配置 或者原来是delete操作
                Query query2 = new Query();
                Criteria criteria2 = Criteria.where("preTransactionId").is(syncResult.getTransactionId());
                query2.addCriteria(criteria2);
                MonitorRuleSyncRecord otherLinkedMonitorRuleSyncRecord = this.mongoTemplate.findOne(query2, MonitorRuleSyncRecord.class, "monitorRuleSyncRecord");
                if(otherLinkedMonitorRuleSyncRecord == null){ //说明后面有业务执行成功，把record的记录删除，则这次失败的记录直接删除，或者原来是delete操作
                    this.mongoTemplate.remove(query, "monitorRuleSyncRecord");
                }else{
                    Query query3 = new Query();
                    Criteria criteria3 = Criteria.where("transactionId").is(otherLinkedMonitorRuleSyncRecord.getTransactionId());
                    query3.addCriteria(criteria3);

                    Update update = new Update();
                    update.set("preTenantConfig", monitorRuleSyncRecord.getPreTenantConfig());
                    update.set("preTransactionId", monitorRuleSyncRecord.getPreTransactionId());
                    this.mongoTemplate.updateFirst(query3, update, "monitorRuleSyncRecord");
                    this.mongoTemplate.remove(query, "monitorRuleSyncRecord");
                }
            }else{ //相同，先删，后回滚
                this.mongoTemplate.remove(query, "monitorRuleTenantConfig");
                if(monitorRuleSyncRecord.getPreTenantConfig() != null){ //如果原来tenantMonitorRuleConfig非空
                    this.mongoTemplate.insert(monitorRuleSyncRecord.getPreTenantConfig(), "monitorRuleTenantConfig");
                }
                if(StringUtils.equalsIgnoreCase(monitorRuleSyncRecord.getType(), "HTTP")){
                    this.mongoTemplate.remove(query, "monitorRuleSyncRecord");
                }else{ // 如果是MQ，则不删除，保留记录
                    Update update = new Update();
                    update.set("errorMessage", syncResult.getErrorMessage());
                    update.set("errorTimes", monitorRuleSyncRecord.getErrorTimes() + 1);
                    this.mongoTemplate.updateFirst(query, update, "monitorRuleSyncRecord");
                }
            }

        }
        return "success";
    }

    @Override
    public Object getCodeByTenant() throws Exception {
//        String tenantId = AthenaUtils.getTenantId();
//        String tenantVersion = kgInnerService.getTenantVersion(tenantId);
//        List<String> ruleIds = this.monitorRuleRepository.getCodeByTenant(tenantId, tenantVersion);
        List<String> ruleIds = dataPickService.tenantApplicationRelationCodes("monitorRule");
        return ruleIds;
    }

    @Override
    public  Object postNoticeWhenMonitorRuleConfigChange(MonitorNoticeVO noticeInfo)  throws Exception{
        log.info("=======NoticeWhenMonitorRuleConfigChangeStart=======");
        Assert.notNull(noticeInfo.getRuleIds(), "monitorRule id is null");
        Query query = new Query();
        query.addCriteria(Criteria.where("monitorRuleId").in(noticeInfo.getRuleIds()));

        List<MonitorRuleTenantConfig> tenantConfigList = this.mongoTemplate.find(query, MonitorRuleTenantConfig.class);

        if(CollectionUtils.isEmpty(tenantConfigList)){
            return null;
        }

        Map<String, String> productChangeInfo = noticeInfo.getProductChangeInfo();
        if(productChangeInfo == null){
            productChangeInfo = new HashMap<>();
        }
        for(MonitorRuleTenantConfig monitorRuleTenantConfig : tenantConfigList){
            log.info("NoticeWhenMonitorRuleConfigChange tenantId:" + monitorRuleTenantConfig.getTenantId() + "ruleId:" + monitorRuleTenantConfig.getMonitorRuleId());
            // 当传了版本号时，只通知版本号匹配的租户
            if (StringUtils.isNotEmpty(noticeInfo.getVersion())) {
                TenantEntity tenantEntity = tenantService.getTenant(monitorRuleTenantConfig.getTenantId());
                if(null == tenantEntity || !StringUtils.equals(tenantEntity.getVersion(), noticeInfo.getVersion())){
                    continue;
                }
            }
            if(!CollectionUtils.isEmpty(noticeInfo.getLimitedTenantIdList()) && !noticeInfo.getLimitedTenantIdList().contains(monitorRuleTenantConfig.getTenantId())){
                continue;
            }

            if(!CollectionUtils.isEmpty(noticeInfo.getExcludedTenantIdList()) && noticeInfo.getExcludedTenantIdList().contains(monitorRuleTenantConfig.getTenantId())){
                continue;
            }

            if(BooleanUtils.isTrue(monitorRuleTenantConfig.getClosed())){
                log.info("NoticeWhenMonitorRuleConfigChange tenantId:" + monitorRuleTenantConfig.getTenantId() + ", rule:"+ monitorRuleTenantConfig.getMonitorRuleId() +" is closed");
                continue;
            }
            String newProductName = productChangeInfo.get(monitorRuleTenantConfig.getProductName());
            if(StringUtils.isNotEmpty(newProductName)){
                log.info("NoticeWhenMonitorRuleConfigChange modify productName:" + newProductName);
                monitorRuleTenantConfig.setProductName(newProductName);
                this.mongoTemplate.save(monitorRuleTenantConfig);
            }
            Integer status = monitorRuleTenantConfig.getStatus();
            this.sendMessage(monitorRuleTenantConfig.getTenantId(), monitorRuleTenantConfig.getMonitorRuleId(), monitorRuleTenantConfig.getEocMap(), ConfigChangeTypeEnum.MODIFIED, status != null ? status == 1 : false, null, "MQ", UUID.randomUUID().toString());
        }
        log.info("=======NoticeWhenMonitorRuleConfigChangeFinish=======");
        return null;
    }

    // 调用esp接口，获取租户的产品信息
    private List<String> handleEspTenantProduct(String tenantId) {
        JSONObject result = (JSONObject) espUtils.getTenantProduct(tenantId, "data.change.sql.get");
        if (result == null || result.getJSONObject("data").getJSONArray("gateway").size() == 0) {
            return Collections.emptyList();
        }

        JSONArray productArray = result.getJSONObject("data")
                .getJSONArray("gateway")
                .getJSONObject(0)
                .getJSONArray("product");
        if (productArray == null) {
            return Collections.emptyList();
        }
        return productArray.stream()
                .map(o -> ((JSONObject) o).getString("name"))
                .collect(Collectors.toList());
    }

    // 根据产品信息判断稳态或敏态，更新script
    private String handleScript(String monitorRuleId,String productName,List<String> tenantProductList,String tenantVersion) throws DWBusinessException {
        StringBuffer sb = new StringBuffer();
        Query query = new Query();
        Criteria criteria = Criteria.where("productName").is(productName).and("monitorRuleId").is(monitorRuleId)
                .and("version").is(tenantVersion);
        query.addCriteria(criteria);
        MonitorRuleProductConfig productConfig = dataPickService.findOneByCondition(criteria, MonitorRuleProductConfig.class, "monitorRuleProductConfig");

        if (null != productConfig && StringUtils.isNotEmpty(productConfig.getScript())) {
            if (!CollectionUtils.isEmpty(tenantProductList) && tenantProductList.contains(productName)) {
                sb.append(productConfig.getScript());
            }else {
                sb.append("select * from (");
                sb.append(productConfig.getScript());

                sb.append(")  tmp where tmp.tenant_id=@#{tenant_id}");
            }
        }
        return sb.toString();
    }

}
