package com.digiwin.athena.knowledgegraph.schedule;

import com.digiwin.athena.knowledgegraph.service.impl.TenantService;
import com.digiwin.athena.knowledgegraph.utils.OperationRecordUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
public class ScheduledTask {

    @Autowired
    private TenantService tenantService;
    @Autowired
    OperationRecordUtil recordUtil;
    /**
     * 每天凌晨01分执行
     */
    @Scheduled(cron = "0 1 0 * * ?")
    public void tenantAppExpire(){
        this.tenantService.postHandleTenantAppExpire();
    }

    @Scheduled(cron = "0 1 0 * * ?")
    public void tenantAppExpireRetainDaysAfter(){
        this.tenantService.postHandleTenantAppExpireRetainDaysAfter();
    }

    @Scheduled(cron = "0 0 0 * * ?")
    public void tenantUsersIntegrityCheck(){
        this.tenantService.getTenantUsersIntegrityCheck();
    }


    @Scheduled(cron = "0 30 5 * * ?")
    public void cleanOperationRecord(){
        this.recordUtil.cleanOperationRecord();
    }
}
