package com.digiwin.athena.knowledgegraph.service;

import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.app.service.DWService;
import com.digiwin.athena.knowledgegraph.service.model.QryTemplateListReq;
import com.digiwin.athena.knowledgegraph.service.model.ActivityTemplate;

/**
 * 模板相关服务
 * @javadoc
 */
public interface IAgileInteractionService extends DWService {

    /**
     * 模板复制
     * @param activityTemplate
     * @return
     * @throws DWBusinessException
     */
    Object postCopy(ActivityTemplate activityTemplate) throws DWBusinessException;

    /**
     * 模板删除
     * @param activityTemplate
     * @throws DWBusinessException
     */
    Object postDelete(ActivityTemplate activityTemplate) throws DWBusinessException;

    /**
     * 模板编辑
     * @param activityTemplate
     * @throws DWBusinessException
     */
    void postEdit(ActivityTemplate activityTemplate) throws DWBusinessException;

    /**
     * 获取模板列表
     * @param appCode 应用code
     * @param activityId 活动id
     * @param pattern    任务 BUSINESS_PERFORM  项目 BUSINESS_CHARGE   基础资料  DATA_ENTRY_PERFORM
     * @param targetId 目标id
     * @param client 客户端
     * @return
     * @throws DWBusinessException
     */
    Object getTemplateList(String appCode, String activityId, String pattern, String targetId, String client) throws DWBusinessException, NoSuchFieldException, IllegalAccessException;

    /**
     * 查询模板列表
     * @param qryTemplateListReq
     * @return
     * @throws DWBusinessException
     */
    Object postTemplateList(QryTemplateListReq qryTemplateListReq) throws Exception;
}
