package com.digiwin.athena.knowledgegraph.service;

import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.app.service.DWService;
import com.digiwin.athena.knowledgegraph.domain.application.AppTenantVersion;

/**
 * 租户应用版本服务接口
 * @program: athena_backend
 * @description: 租户应用版本服务接口
 * @author: lingxiang
 * @create: 2022-04-20 16:00
 * @javadoc
 **/
public interface IAppTenantVersionService extends DWService {
    /**
     * 新增租户应用版本
     * @param appTenantVersion 租户应用版本数据
     * @return
     * @throws DWBusinessException
     */
    Object put(AppTenantVersion appTenantVersion) throws DWBusinessException;
    /**
     * 新增租户应用版本
     * @param appTenantVersion 租户应用版本数据
     * @return
     * @throws DWBusinessException
     */
    Object post(AppTenantVersion appTenantVersion) throws DWBusinessException;
    /**
     * 根据当前登录租户tenantId和appCode删除对应的记录
     * @param appCode 应用code
     * @return
     * @throws DWBusinessException
     */
    Object delete(String appCode) throws DWBusinessException;

    /**
     * 根据当前登录租户tenantId和appCode查询对应的应用version和开发version
     * @param appCode 应用code
     * @return
     * @throws DWBusinessException
     */
    AppTenantVersion postQueryVersion(String appCode) throws DWBusinessException;
}